/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.util.containers.HashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.incremental.storage.ValidityState;

public class AndroidBuildConfigState
implements ValidityState {
    private final String myPackage;
    private final Set<String> myLibPackages;
    private final boolean myDebug;

    public AndroidBuildConfigState(@NotNull String aPackage, @NotNull Collection<String> libPackages, boolean debug) {
        this.myPackage = aPackage;
        this.myDebug = debug;
        this.myLibPackages = new HashSet(libPackages);
    }

    public AndroidBuildConfigState(@NotNull DataInput in) throws IOException {
        this.myPackage = in.readUTF();
        int libPackagesCount = in.readInt();
        this.myLibPackages = new HashSet(libPackagesCount);
        for (int i = 0; i < libPackagesCount; ++i) {
            this.myLibPackages.add(in.readUTF());
        }
        this.myDebug = in.readBoolean();
    }

    public boolean equalsTo(ValidityState otherState) {
        if (!(otherState instanceof AndroidBuildConfigState)) {
            return false;
        }
        AndroidBuildConfigState otherState1 = (AndroidBuildConfigState)otherState;
        return otherState1.myDebug == this.myDebug && otherState1.myPackage.equals(this.myPackage) && otherState1.myLibPackages.equals(this.myLibPackages);
    }

    public void save(DataOutput out) throws IOException {
        out.writeUTF(this.myPackage);
        out.writeInt(this.myLibPackages.size());
        for (String libPackage : this.myLibPackages) {
            out.writeUTF(libPackage);
        }
        out.writeBoolean(this.myDebug);
    }
}

