/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.workspace;

import com.android.tools.idea.apk.ApkProjects;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.ndk.GradleWorkspace;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.workspace.EmptyWorkspace;
import com.google.idea.blaze.base.settings.Blaze;
import com.google.idea.blaze.cpp.BlazeCWorkspace;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NdkWorkspaceManager
extends OCWorkspaceManager {
    @NonNls
    private static final String BLAZE_PLUGIN_ID = "com.google.idea.blaze.aswb";
    private static final Logger LOG = Logger.getInstance(NdkWorkspaceManager.class);
    @NotNull
    private final Project myProject;

    public NdkWorkspaceManager(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public OCWorkspace getWorkspace() {
        try {
            if (Projects.isBuildWithGradle((Project)this.myProject)) {
                return GradleWorkspace.getInstance((Project)this.myProject);
            }
            if (NdkWorkspaceManager.isBlazePluginAvailable() && Blaze.isBlazeProject((Project)this.myProject)) {
                return BlazeCWorkspace.getInstance((Project)this.myProject);
            }
            if (ApkProjects.isApkProject((Project)this.myProject)) {
                return EmptyWorkspace.getInstance(this.myProject);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to get the workspace of project " + this.myProject.getName(), (Throwable)e);
        }
        EmptyWorkspace workspace = EmptyWorkspace.getInstance(this.myProject);
        if (!((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false)).booleanValue()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("NDK support for project '" + this.myProject.getName() + "' is disabled because it's not a valid Android project");
            }
            NdkHelper.disableCppLanguageSupport((Project)this.myProject, (boolean)true);
            NdkWorkspaceManager.rebuildSymbols(this.myProject, workspace);
        }
        return workspace;
    }

    private static boolean isBlazePluginAvailable() {
        IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin((PluginId)PluginId.getId((String)BLAZE_PLUGIN_ID));
        return pluginDescriptor != null && pluginDescriptor.isEnabled();
    }

    private static void rebuildSymbols(@NotNull Project project, @NotNull OCWorkspace workspace) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                workspace.getModificationTrackers().getBuildSettingsChangesTracker().incModificationCount();
            }
        });
    }
}

