/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ID<K, V> {
    private static final TIntObjectHashMap<ID> ourRegistry = new TIntObjectHashMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();

    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            BufferedWriter w = new BufferedWriter(new FileWriter(f));
            try {
                final String[] names = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String key, int value) {
                        names[value - 1] = key;
                        return true;
                    }
                });
                for (String name : names) {
                    w.write(name);
                    w.newLine();
                }
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(indices));
            try {
                int cnt = 0;
                while (true) {
                    ++cnt;
                    String name = reader.readLine();
                    if (name == null) {
                        break;
                    }
                    ourNameToIdRegistry.put(name, cnt);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            ourNameToIdRegistry.clear();
            ID.writeEnumFile();
        }
    }
}

