/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueIntObjectHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ContainerUtil
extends ContainerUtilRt {
    private static final Logger LOG = Logger.getInstance(ContainerUtil.class);
    private static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(16, Runtime.getRuntime().availableProcessors());
    private static final ConcurrentMapFactory V8_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashStrategy) {
            if (hashStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(hashStrategy);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$19", "createMap"));
            }
            return concurrentHashMap;
        }
    };
    private static final ConcurrentMapFactory PLATFORM_MAP_FACTORY = new ConcurrentMapFactory(){

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap() {
            ConcurrentMap<T, V> concurrentMap = this.createMap(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity) {
            java.util.concurrent.ConcurrentHashMap concurrentHashMap = new java.util.concurrent.ConcurrentHashMap(initialCapacity);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            ConcurrentMap<T, V> concurrentMap = this.createMap();
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            java.util.concurrent.ConcurrentHashMap concurrentHashMap = new java.util.concurrent.ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentHashMap;
        }

        @Override
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashingStrategy) {
            if (hashingStrategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            if (hashingStrategy != ContainerUtil.canonicalStrategy()) {
                throw new UnsupportedOperationException("Custom hashStrategy is not supported in java.util.concurrent.ConcurrentHashMap");
            }
            ConcurrentMap<T, V> concurrentMap = this.createMap(initialCapacity, loadFactor, concurrencyLevel);
            if (concurrentMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$20", "createMap"));
            }
            return concurrentMap;
        }
    };
    private static final ConcurrentMapFactory CHM_FACTORY = SystemInfo.isOracleJvm || SystemInfo.isSunJvm || SystemInfo.isAppleJvm || ContainerUtil.isAtLeastJava7() ? V8_MAP_FACTORY : PLATFORM_MAP_FACTORY;

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "canonicalStrategy"));
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentMap concurrentMap = CHM_FACTORY.createMap();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return concurrentMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashStrategy) {
        if (hashStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashStrategy", "com/intellij/util/containers/ContainerUtil", "newConcurrentMap"));
        }
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return CHM_FACTORY.createMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
            }
            return list;
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "findAll"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "skipNulls"));
        }
        List<Object> list = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "skipNulls"));
        }
        return list;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (enumeration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "addAll"));
        }
        return c;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        if (iterable.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
            }
            return list;
        }
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "map"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "emptyList"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createLockFreeCopyOnWriteList"));
        }
        return concurrentList;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectMap"));
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentWeakValueIntObjectHashMap concurrentWeakValueIntObjectHashMap = new ConcurrentWeakValueIntObjectHashMap();
        if (concurrentWeakValueIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentIntObjectWeakValueMap"));
        }
        return concurrentWeakValueIntObjectHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakKeyWeakValueMap"));
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentSoftValueMap"));
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap();
        if (concurrentWeakHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentWeakMap"));
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil", "createConcurrentList"));
        }
        return lockFreeCopyOnWriteArrayList;
    }

    private static boolean isAtLeastJava7() {
        return StringUtil.compareVersionNumbers(SystemInfo.JAVA_VERSION, "1.7") >= 0;
    }

    private static interface ConcurrentMapFactory {
        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap();

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> var1);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3);

        @NotNull
        public <T, V> ConcurrentMap<T, V> createMap(int var1, float var2, int var3, @NotNull TObjectHashingStrategy<T> var4);
    }
}

