/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRefElementCreator;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementRef<T extends PsiElement> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiElementRef");
    private volatile PsiRefColleague<T> myColleague;

    public PsiElementRef(PsiRefColleague<T> colleague) {
        this.myColleague = colleague;
    }

    public final boolean isImaginary() {
        return this.getPsiElement() == null;
    }

    @Nullable
    public final T getPsiElement() {
        return this.myColleague.getPsiElement();
    }

    @NotNull
    public final T ensurePsiElementExists() {
        PsiRefColleague.Real<T> realColleague = this.myColleague.makeReal();
        this.myColleague = realColleague;
        T t = realColleague.getPsiElement();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef", "ensurePsiElementExists"));
        }
        return t;
    }

    @NotNull
    public final PsiElement getRoot() {
        PsiElement psiElement = this.myColleague.getRoot();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef", "getRoot"));
        }
        return psiElement;
    }

    public boolean equals(Object o) {
        return o instanceof PsiElementRef && this.myColleague.equals(((PsiElementRef)o).myColleague);
    }

    public int hashCode() {
        return this.myColleague.hashCode();
    }

    public final boolean isValid() {
        return this.myColleague.isValid();
    }

    public static <T extends PsiElement> PsiElementRef<T> real(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiElementRef", "real"));
        }
        return new PsiElementRef<T>(new PsiRefColleague.Real<T>(element));
    }

    public static <Child extends PsiElement, Parent extends PsiElement> PsiElementRef<Child> imaginary(PsiElementRef<? extends Parent> parent, PsiRefElementCreator<Parent, Child> creator) {
        return new PsiElementRef(new PsiRefColleague.Imaginary<Child, Parent>(parent, creator));
    }

    private static interface PsiRefColleague<T extends PsiElement> {
        public boolean isValid();

        @Nullable
        public T getPsiElement();

        @NotNull
        public Real<T> makeReal();

        @NotNull
        public PsiElement getRoot();

        public static class Imaginary<Child extends PsiElement, Parent extends PsiElement>
        implements PsiRefColleague<Child> {
            private final PsiElementRef<? extends Parent> myParent;
            private final PsiRefElementCreator<Parent, Child> myCreator;

            public Imaginary(PsiElementRef<? extends Parent> parent, PsiRefElementCreator<Parent, Child> creator) {
                this.myParent = parent;
                this.myCreator = creator;
            }

            @Override
            public boolean isValid() {
                return this.myParent.isValid();
            }

            @Override
            public Child getPsiElement() {
                return null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Imaginary imaginary = (Imaginary)o;
                if (!this.myCreator.equals(imaginary.myCreator)) {
                    return false;
                }
                return this.myParent.equals(imaginary.myParent);
            }

            public int hashCode() {
                int result = this.myParent.hashCode();
                result = 31 * result + this.myCreator.hashCode();
                return result;
            }

            @Override
            @NotNull
            public Real<Child> makeReal() {
                Real<PsiElement> real = new Real<PsiElement>((PsiElement)this.myCreator.createChild(this.myParent.ensurePsiElementExists()));
                if (real == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef$PsiRefColleague$Imaginary", "makeReal"));
                }
                return real;
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                PsiElement psiElement = this.myParent.getRoot();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef$PsiRefColleague$Imaginary", "getRoot"));
                }
                return psiElement;
            }
        }

        public static class Real<T extends PsiElement>
        implements PsiRefColleague<T> {
            private final T myElement;

            public Real(@NotNull T element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiElementRef$PsiRefColleague$Real", "<init>"));
                }
                PsiUtilCore.ensureValid(element);
                this.myElement = element;
            }

            @Override
            @NotNull
            public T getPsiElement() {
                T t = this.myElement;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef$PsiRefColleague$Real", "getPsiElement"));
                }
                return t;
            }

            @Override
            public boolean isValid() {
                return this.myElement.isValid();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Real real = (Real)o;
                return this.myElement.equals(real.myElement);
            }

            public int hashCode() {
                return this.myElement.hashCode();
            }

            @Override
            @NotNull
            public Real<T> makeReal() {
                Real real = this;
                if (real == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef$PsiRefColleague$Real", "makeReal"));
                }
                return real;
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                T t = this.myElement;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef$PsiRefColleague$Real", "getRoot"));
                }
                return t;
            }
        }
    }
}

