/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.JpsGradleModuleExtension;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.JpsGradleModuleExtensionImpl;
import org.jetbrains.jps.incremental.resources.ResourcesBuilder;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsGradleExtensionServiceImpl
extends JpsGradleExtensionService {
    private static final Logger LOG = Logger.getInstance(JpsGradleExtensionServiceImpl.class);
    private static final JpsElementChildRole<JpsSimpleElement<Boolean>> PRODUCTION_ON_TEST_ROLE = JpsElementChildRoleBase.create((String)"production on test");
    private final Map<File, GradleProjectConfiguration> myLoadedConfigs = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
    private final FactoryMap<File, Boolean> myConfigFileExists = new ConcurrentFactoryMap<File, Boolean>(){

        @Nullable
        protected Boolean create(File key) {
            return key.exists();
        }
    };

    public JpsGradleExtensionServiceImpl() {
        ResourcesBuilder.registerEnabler((StandardResourceBuilderEnabler)new StandardResourceBuilderEnabler(){

            public boolean isResourceProcessingEnabled(JpsModule module) {
                return JpsGradleExtensionServiceImpl.this.getExtension(module) == null;
            }
        });
    }

    @Override
    @Nullable
    public JpsGradleModuleExtension getExtension(@NotNull JpsModule module) {
        return (JpsGradleModuleExtension)module.getContainer().getChild(JpsGradleModuleExtensionImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsGradleModuleExtension getOrCreateExtension(@NotNull JpsModule module) {
        JpsGradleModuleExtension extension = (JpsGradleModuleExtension)module.getContainer().getChild(JpsGradleModuleExtensionImpl.ROLE);
        if (extension == null) {
            extension = new JpsGradleModuleExtensionImpl();
            module.getContainer().setChild(JpsGradleModuleExtensionImpl.ROLE, (JpsElement)extension);
        }
        return extension;
    }

    @Override
    public void setProductionOnTestDependency(@NotNull JpsDependencyElement dependency, boolean value) {
        if (value) {
            dependency.getContainer().setChild(PRODUCTION_ON_TEST_ROLE, (JpsElement)JpsElementFactory.getInstance().createSimpleElement((Object)true));
        } else {
            dependency.getContainer().removeChild(PRODUCTION_ON_TEST_ROLE);
        }
    }

    @Override
    public boolean isProductionOnTestDependency(@NotNull JpsDependencyElement dependency) {
        JpsSimpleElement child = (JpsSimpleElement)dependency.getContainer().getChild(PRODUCTION_ON_TEST_ROLE);
        return child != null && (Boolean)child.getData() != false;
    }

    @Override
    public boolean hasGradleProjectConfiguration(@NotNull BuildDataPaths paths) {
        return (Boolean)this.myConfigFileExists.get((Object)new File(paths.getDataStorageRoot(), "gradle/configuration.xml"));
    }

    @Override
    @NotNull
    public GradleProjectConfiguration getGradleProjectConfiguration(BuildDataPaths paths) {
        File dataStorageRoot = paths.getDataStorageRoot();
        return this.getGradleProjectConfiguration(dataStorageRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GradleProjectConfiguration getGradleProjectConfiguration(@NotNull File dataStorageRoot) {
        GradleProjectConfiguration config;
        File configFile = new File(dataStorageRoot, "gradle/configuration.xml");
        Map<File, GradleProjectConfiguration> map = this.myLoadedConfigs;
        synchronized (map) {
            config = this.myLoadedConfigs.get(configFile);
            if (config == null) {
                config = new GradleProjectConfiguration();
                try {
                    Document document = JDOMUtil.loadDocument((File)configFile);
                    XmlSerializer.deserializeInto((Object)config, (Element)document.getRootElement());
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
                this.myLoadedConfigs.put(configFile, config);
            }
        }
        return config;
    }
}

