/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.gradle.model.impl.GradleResourceFileFilter;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTarget;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;

public class GradleResourceRootDescriptor
extends BuildRootDescriptor {
    private final GradleResourcesTarget myTarget;
    private final ResourceRootConfiguration myConfig;
    private final File myFile;
    private final String myId;
    private final boolean myOverwrite;
    private final int myIndexInPom;

    public GradleResourceRootDescriptor(@NotNull GradleResourcesTarget target, ResourceRootConfiguration config, int indexInPom, boolean overwrite) {
        this.myTarget = target;
        this.myConfig = config;
        String path = FileUtil.toCanonicalPath((String)config.directory);
        this.myFile = new File(path);
        this.myId = path;
        this.myIndexInPom = indexInPom;
        this.myOverwrite = overwrite;
    }

    public ResourceRootConfiguration getConfiguration() {
        return this.myConfig;
    }

    public String getRootId() {
        return this.myId;
    }

    public File getRootFile() {
        return this.myFile;
    }

    public GradleResourcesTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public FileFilter createFileFilter() {
        return new GradleResourceFileFilter(this.myFile, this.myConfig);
    }

    public boolean canUseFileCache() {
        return true;
    }

    public int getIndexInPom() {
        return this.myIndexInPom;
    }

    public boolean isOverwrite() {
        return this.myOverwrite;
    }
}

