/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.CompileOptions;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import org.gradle.api.JavaVersion;
import org.gradle.api.tasks.compile.AbstractCompile;

public class AbstractCompilesUtil {
    public static void configureLanguageLevel(AbstractCompile compileTask, CompileOptions compileOptions, String compileSdkVersion) {
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)compileSdkVersion);
        Integer compileSdkLevel = hash == null ? null : Integer.valueOf(hash.getApiLevel());
        JavaVersion javaVersionToUse = compileSdkLevel == null || 0 <= compileSdkLevel && compileSdkLevel <= 20 ? JavaVersion.VERSION_1_6 : JavaVersion.VERSION_1_7;
        JavaVersion jdkVersion = JavaVersion.toVersion((Object)System.getProperty("java.specification.version"));
        if (jdkVersion.compareTo((Enum)javaVersionToUse) < 0) {
            compileTask.getLogger().warn("Default language level for compileSdkVersion '{}' is {}, but the JDK used is {}, so the JDK language level will be used.", new Object[]{compileSdkVersion, javaVersionToUse, jdkVersion});
            javaVersionToUse = jdkVersion;
        }
        compileOptions.setDefaultJavaVersion(javaVersionToUse);
        compileTask.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        compileTask.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
    }
}

