/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.SdkHandler;
import com.android.builder.core.AndroidBuilder;
import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope {
    private Project project;
    private AndroidBuilder androidBuilder;
    private AndroidConfig extension;
    private SdkHandler sdkHandler;
    private ToolingModelBuilderRegistry toolingRegistry;
    private final File intermediatesDir;
    private final File generatedDir;
    private final File reportsDir;
    private final File outputsDir;
    private File mockableAndroidJarFile;

    public GlobalScope(Project project, AndroidBuilder androidBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry) {
        this.project = project;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
        this.sdkHandler = sdkHandler;
        this.toolingRegistry = toolingRegistry;
        this.intermediatesDir = new File(this.getBuildDir(), "intermediates");
        this.generatedDir = new File(this.getBuildDir(), "generated");
        this.reportsDir = new File(this.getBuildDir(), "reports");
        this.outputsDir = new File(this.getBuildDir(), "outputs");
    }

    public Project getProject() {
        return this.project;
    }

    public AndroidConfig getExtension() {
        return this.extension;
    }

    public AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    public String getProjectBaseName() {
        return (String)this.project.property("archivesBaseName");
    }

    public SdkHandler getSdkHandler() {
        return this.sdkHandler;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    public File getIntermediatesDir() {
        return this.intermediatesDir;
    }

    public File getGeneratedDir() {
        return this.generatedDir;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    public File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    public File getMockableAndroidJarFile() {
        if (this.mockableAndroidJarFile == null) {
            String fileExt = this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues() ? ".default-values.jar" : ".jar";
            File outDir = new File(this.getProject().getRootProject().getBuildDir(), "generated");
            CharMatcher safeCharacters = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)"-."));
            String sdkName = safeCharacters.negate().replaceFrom((CharSequence)this.getExtension().getCompileSdkVersion(), '-');
            this.mockableAndroidJarFile = new File(outDir, "mockable-" + sdkName + fileExt);
        }
        return this.mockableAndroidJarFile;
    }

    public File getOutputsDir() {
        return this.outputsDir;
    }

    public String getDefaultApkLocation() {
        return this.getBuildDir() + "/" + "outputs" + "/apk";
    }

    public String getApkLocation() {
        return (String)Objects.firstNonNull((Object)AndroidGradleOptions.getApkLocation(this.project), (Object)this.getDefaultApkLocation());
    }
}

