/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.assistant.view.UIUtils;
import com.google.api.client.util.Lists;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.DataSharingSetting;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.mobilesdk.CountryConstants;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.FirebaseDialog;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.LinkButton;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectToOnlineProjectPanel
extends JBPanel {
    private static final int PAD = 10;
    private static final int MAX_COPY_WIDTH = 500;
    private JBRadioButton myExistingProjectSelector;
    private JBRadioButton myCreateNewProjectSelector;
    private JBLabel myProjectCountryLabel;
    private JBList myExistingProjectSelectList;
    private JFormattedTextField myCreateProjectName;
    private GoogleLogin myGoogleLogin;
    private boolean myCreateMode = true;
    private Module myAndroidModule;
    private ComboBox myProjectCountry;
    private JPanel myDataSharingSmallPrintPanel;
    private JPanel myDataSharingCheckboxPanel;
    private JBCheckBox myProjectDataSharingSetting;
    private FirebaseConfig myFirebaseConfig;

    public ConnectToOnlineProjectPanel(@NotNull Module androidModule, @NotNull FirebaseConfig firebaseConfig, @NotNull Collection<OnlineProject> existingProjects, @Nullable(value="Terms of Service confirmation not needed") URL tosUrl) throws IllegalStateException {
        this(GoogleLogin.getInstance(), androidModule, firebaseConfig, existingProjects, tosUrl);
    }

    ConnectToOnlineProjectPanel(@NotNull GoogleLogin googleLogin, @NotNull Module androidModule, @NotNull FirebaseConfig firebaseConfig, @NotNull Collection<OnlineProject> existingProjects, @Nullable(value="Terms of Service confirmation not needed") URL tosUrl) throws IllegalStateException {
        this.setName(FirebaseBundle.message("ui.connect.input.panel.title", new Object[0]));
        if (!googleLogin.isConnected() || googleLogin.getActiveUser() == null) {
            throw new IllegalStateException(FirebaseBundle.message("firebaseService.userError.googleSignInRequired", new Object[0]));
        }
        this.myGoogleLogin = googleLogin;
        this.myAndroidModule = androidModule;
        this.myFirebaseConfig = firebaseConfig;
        Project project = androidModule.getProject();
        String projectName = MobileSdkUtil.getValidProjectName(project.getName());
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        ButtonGroup group = new ButtonGroup();
        JPanel createLine = new JPanel();
        createLine.setAlignmentX(0.0f);
        this.add(createLine);
        createLine.setLayout(new BoxLayout(createLine, 0));
        createLine.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myCreateNewProjectSelector = new JBRadioButton(FirebaseBundle.message("ui.connect.input.panel.label.create.new.project.selector", new Object[0]));
        group.add((AbstractButton)this.myCreateNewProjectSelector);
        createLine.add((Component)this.myCreateNewProjectSelector);
        String standardBG = UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor());
        int contentOffset = this.myCreateNewProjectSelector.getIconTextGap() + UIUtil.getRadioButtonIcon().getIconWidth() + FirebaseDialog.SIDE_INSET + 8;
        JEditorPane whatsThisLink = new JEditorPane();
        UIUtils.setHtml((JEditorPane)whatsThisLink, (String)FirebaseBundle.message("ui.connect.input.panel.action.buttons.more.info", new Object[0]), (String)("body { background-color: " + standardBG + "; margin: 5px 20px 0 5px; }"));
        whatsThisLink.setOpaque(true);
        createLine.add(whatsThisLink);
        createLine.add(Box.createHorizontalGlue());
        JPanel createLineRhs = new JPanel(new FlowLayout(2, 0, 0));
        createLine.add(createLineRhs);
        JEditorPane signinState = new JEditorPane();
        UIUtils.setHtml((JEditorPane)signinState, (String)FirebaseBundle.message("ui.connect.input.panel.label.signed.in", googleLogin.getEmail()), (String)("body { font-size: 9px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; background-color: " + standardBG + "; margin: 3px 5px 0 0; }"));
        signinState.setOpaque(true);
        createLineRhs.add(signinState);
        LinkButton mySignOutButton = new LinkButton(FirebaseBundle.message("ui.connect.input.panel.action.buttons.sign.out", new Object[0]));
        mySignOutButton.setFont(mySignOutButton.getFont().deriveFont(11.0f));
        createLineRhs.add(mySignOutButton);
        mySignOutButton.addActionListener(e -> this.myGoogleLogin.logOut(true));
        JPanel projectNameWrapper = new JPanel(new BorderLayout(0, 0));
        projectNameWrapper.setBorder(BorderFactory.createEmptyBorder(0, contentOffset, 10, FirebaseDialog.SIDE_INSET));
        this.myCreateProjectName = new JFormattedTextField();
        this.myCreateProjectName.setText(projectName);
        this.myCreateProjectName.setInputVerifier(new ProjectNameInputVerifier());
        projectNameWrapper.add(this.myCreateProjectName);
        projectNameWrapper.setAlignmentX(0.0f);
        this.add(projectNameWrapper);
        JPanel existingProjectWrapper = new JPanel(new BorderLayout(0, 0));
        existingProjectWrapper.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myExistingProjectSelector = new JBRadioButton(FirebaseBundle.message("ui.connect.input.panel.label.choose.existing.project.selector", new Object[0]));
        group.add((AbstractButton)this.myExistingProjectSelector);
        this.myCreateNewProjectSelector.setSelected(true);
        existingProjectWrapper.add((Component)this.myExistingProjectSelector);
        existingProjectWrapper.setAlignmentX(0.0f);
        this.add(existingProjectWrapper);
        JPanel existingProjectListWrapper = new JPanel(new BorderLayout(0, 0));
        existingProjectListWrapper.setBorder(BorderFactory.createEmptyBorder(0, contentOffset, 10, FirebaseDialog.SIDE_INSET));
        existingProjectListWrapper.setAlignmentX(0.0f);
        this.myExistingProjectSelectList = new JBList();
        this.myExistingProjectSelectList.setModel((ListModel)((Object)new OnlineProjectModel(existingProjects)));
        this.myExistingProjectSelectList.setCellRenderer((ListCellRenderer)new OnlineProjectRenderer());
        this.myExistingProjectSelectList.setEmptyText(FirebaseBundle.message("ui.connect.input.panel.validation.project.not.selected", new Object[0]));
        this.myExistingProjectSelectList.addListSelectionListener(e -> {
            this.updateCountryDisplay();
            this.updateProjectSharingDisplay();
        });
        JBScrollPane projectScroller = new JBScrollPane((Component)this.myExistingProjectSelectList);
        existingProjectListWrapper.add((Component)projectScroller);
        this.add(existingProjectListWrapper);
        this.myProjectCountryLabel = new JBLabel(FirebaseBundle.message("ui.connect.input.panel.label.country", new Object[0]));
        this.myProjectCountryLabel.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myProjectCountryLabel.setAlignmentX(0.0f);
        this.add((Component)this.myProjectCountryLabel);
        JPanel countryWrapper = new JPanel(new BorderLayout(0, 0));
        countryWrapper.setBorder(BorderFactory.createEmptyBorder(0, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myProjectCountry = ConnectToOnlineProjectPanel.createCountryComboBox();
        countryWrapper.add((Component)this.myProjectCountry);
        countryWrapper.setAlignmentX(0.0f);
        this.add(countryWrapper);
        this.myDataSharingCheckboxPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        this.myDataSharingCheckboxPanel.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        JPanel subPanel = new JPanel((LayoutManager)new HorizontalLayout(0, 0));
        this.myProjectDataSharingSetting = new JBCheckBox();
        this.myProjectDataSharingSetting.setEnabled(true);
        JEditorPane checkboxLabel = new JEditorPane();
        UIUtils.setHtml((JEditorPane)checkboxLabel, (String)FirebaseBundle.message("ui.connect.dialog.dataSharing", new Object[0]), (String)("body { background-color: " + standardBG + "; padding-top: 15px; font-size: 11px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; width: " + 500 + "px; }"));
        checkboxLabel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        checkboxLabel.setOpaque(true);
        checkboxLabel.setBackground(UIUtils.getAsStandardBackgroundColor());
        subPanel.add((Component)this.myProjectDataSharingSetting);
        subPanel.add(checkboxLabel);
        this.myDataSharingCheckboxPanel.add(subPanel);
        this.myDataSharingCheckboxPanel.setAlignmentX(0.0f);
        this.add(this.myDataSharingCheckboxPanel);
        this.myDataSharingSmallPrintPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        this.myDataSharingSmallPrintPanel.setBorder(BorderFactory.createEmptyBorder(10, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
        this.myDataSharingSmallPrintPanel.setAlignmentX(0.0f);
        JEditorPane smallPrint = new JEditorPane();
        this.myDataSharingSmallPrintPanel.add(smallPrint);
        UIUtils.setHtml((JEditorPane)smallPrint, (String)FirebaseBundle.message("ui.connect.dialog.smallPrint", new Object[0]), (String)("body { background-color: " + standardBG + "; padding-top: 15px; font-size: 11px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; width: " + 500 + "px; }"));
        smallPrint.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIUtils.getSeparatorColor()));
        smallPrint.setOpaque(true);
        smallPrint.setBackground(UIUtils.getAsStandardBackgroundColor());
        this.add(this.myDataSharingSmallPrintPanel);
        if (tosUrl != null) {
            JPanel tosWrapper = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
            tosWrapper.setBorder(BorderFactory.createEmptyBorder(0, FirebaseDialog.SIDE_INSET, 10, FirebaseDialog.SIDE_INSET));
            tosWrapper.setAlignmentX(0.0f);
            JEditorPane tos = new JEditorPane();
            tosWrapper.add(tos);
            UIUtils.setHtml((JEditorPane)tos, (String)FirebaseBundle.message("ui.tosCopy", tosUrl.toString()), (String)("body { background-color: " + standardBG + "; width: " + 500 + "px; padding-top: 10px; font-size: 11px; color: " + UIUtils.getCssColor((Color)UIUtils.getSecondaryColor()) + "; } .important { color: " + UIUtils.getCssColor((Color)tosWrapper.getForeground()) + " }"));
            tos.setOpaque(true);
            tos.setBackground(UIUtils.getAsStandardBackgroundColor());
            this.add(tosWrapper);
        }
        this.enableCreateProjectMode(true);
        try {
            if (this.myGoogleLogin.fetchOAuth2Token() == null) {
                FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
            }
        }
        catch (IOException exception) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, exception, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
        }
        this.initializeRadioButtonActionListeners();
    }

    @NotNull
    public Module getAndroidModule() {
        return this.myAndroidModule;
    }

    public boolean isCreateMode() {
        return this.myCreateMode;
    }

    @NotNull
    public String getNewProjectDisplayName() {
        if (!this.isCreateMode()) {
            throw new IllegalStateException("Panel is not in create mode");
        }
        return this.myCreateProjectName.getText();
    }

    @NotNull
    public String getNewProjectCountryCode() {
        return ConnectToOnlineProjectPanel.getCountryCode(this.myProjectCountry);
    }

    @NotNull
    public static String getCountryCode(@NotNull ComboBox comboBox) {
        String selectedItem = comboBox.getSelectedItem().toString();
        String selectedKey = null;
        for (String key : CountryConstants.COUNTRY_MAP.keySet()) {
            if (!CountryConstants.COUNTRY_MAP.get(key).equals(selectedItem)) continue;
            selectedKey = key;
        }
        return selectedKey == null ? "US" : selectedKey;
    }

    @NotNull
    public static ComboBox createCountryComboBox() {
        ArrayList<String> countries = new ArrayList<String>(CountryConstants.COUNTRY_MAP.values());
        Collections.sort(countries);
        String defaultValue = CountryConstants.COUNTRY_MAP.get(MobileSdkUtil.getRegionCode());
        if (defaultValue == null) {
            defaultValue = "United States";
        }
        int defaultIndex = countries.indexOf(defaultValue);
        ComboBox comboBox = new ComboBox(countries.toArray());
        comboBox.setSelectedIndex(defaultIndex);
        comboBox.setBackground(UIUtils.getBackgroundColor());
        return comboBox;
    }

    @NotNull
    public OnlineProject getExistingProjectToConnect() {
        if (this.isCreateMode()) {
            throw new IllegalStateException("Panel is in create mode");
        }
        return (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
    }

    public DataSharingSetting getProjectDataSharingEnabled() {
        return DataSharingSetting.fromCheckbox(this.myProjectDataSharingSetting);
    }

    private void initializeRadioButtonActionListeners() {
        this.myExistingProjectSelector.addActionListener(e -> this.enableCreateProjectMode(false));
        this.myCreateNewProjectSelector.addActionListener(e -> this.enableCreateProjectMode(true));
    }

    private void enableCreateProjectMode(boolean createMode) {
        this.myCreateMode = createMode;
        this.myCreateProjectName.setEnabled(createMode);
        this.myExistingProjectSelectList.setEnabled(!createMode);
        this.updateCountryDisplay();
        this.updateProjectSharingDisplay();
    }

    private void updateCountryDisplay() {
        boolean show = this.myCreateNewProjectSelector.isSelected();
        if (!show) {
            OnlineProject selected = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
            show = selected == null || selected.isRequiredFirebaseMigration();
        }
        this.myProjectCountry.setVisible(show);
        this.myProjectCountryLabel.setVisible(show);
    }

    private void updateProjectSharingDisplay() {
        Boolean showProjectSharingCheckbox = false;
        this.myProjectDataSharingSetting.setSelected(true);
        if (this.myCreateNewProjectSelector.isSelected()) {
            showProjectSharingCheckbox = false;
        } else {
            OnlineProject selectedProject = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
            if (selectedProject != null) {
                showProjectSharingCheckbox = selectedProject.shouldShowProjectDataSharingSetting();
            }
        }
        if (showProjectSharingCheckbox == null) {
            throw new IllegalStateException("Can't proceed without project data sharing data being loaded.");
        }
        this.myDataSharingCheckboxPanel.setVisible(showProjectSharingCheckbox);
        this.myDataSharingSmallPrintPanel.setVisible(showProjectSharingCheckbox == false);
    }

    @Nullable
    public ValidationInfo doValidate() {
        if (this.myCreateMode) {
            String newProjectName = this.myCreateProjectName.getText();
            boolean isValidProjectName = MobileSdkUtil.isValidProjectName(newProjectName);
            if (!isValidProjectName) {
                return new ValidationInfo(FirebaseBundle.message("ui.connect.input.panel.validation.invalid.project.display.name", new Object[0]), (JComponent)this.myCreateProjectName);
            }
        } else {
            boolean needToAddAndroidAuthClients;
            OnlineProject selected = (OnlineProject)this.myExistingProjectSelectList.getSelectedValue();
            if (selected == null) {
                return new ValidationInfo(FirebaseBundle.message("ui.connect.input.panel.validation.project.not.selected", new Object[0]), (JComponent)this.myExistingProjectSelectList);
            }
            boolean bl = needToAddAndroidAuthClients = this.myFirebaseConfig.getResolvedAndroidClientMap().getUnregisteredClients().size() > 0;
            if ((selected.isRequiredFirebaseMigration() || needToAddAndroidAuthClients) && !selected.isEditable()) {
                return new ValidationInfo(FirebaseBundle.message("connectDialog.validationError.noEditRightsToProject", new Object[0]), (JComponent)this.myExistingProjectSelectList);
            }
        }
        return null;
    }

    private static class OnlineProjectRenderer
    extends DefaultListCellRenderer {
        private OnlineProjectRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(@NotNull JList list, @NotNull Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            OnlineProject project = (OnlineProject)value;
            this.setText(project.getDisplayName());
            return comp;
        }
    }

    private static class OnlineProjectModel
    extends CollectionListModel<OnlineProject> {
        final List<OnlineProject> projects;
        private final Collection<OnlineProject> myExistingProjects;

        public OnlineProjectModel(@NotNull Collection<OnlineProject> existingProjects) {
            super((Object[])new OnlineProject[0]);
            this.myExistingProjects = existingProjects;
            this.projects = Lists.newArrayList(this.myExistingProjects);
        }

        public int getSize() {
            return this.projects == null ? 0 : this.projects.size();
        }

        public OnlineProject getElementAt(int index) {
            return this.projects.get(index);
        }

        public void addListDataListener(@NotNull ListDataListener l) {
        }

        public void removeListDataListener(@NotNull ListDataListener l) {
        }
    }

    private static class ProjectNameInputVerifier
    extends InputVerifier {
        private ProjectNameInputVerifier() {
        }

        @Override
        public boolean verify(@NotNull JComponent input) {
            JFormattedTextField textField;
            boolean valid = MobileSdkUtil.isValidProjectName((textField = (JFormattedTextField)input).getText());
            textField.setForeground(valid ? UIUtils.getSuccessColor() : UIUtils.getFailureColor());
            return valid;
        }
    }
}

