/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.google.services.firebase.ConnectFirebaseTask;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseUsageTracker;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.ConnectToOnlineProjectPanel;
import com.google.services.firebase.view.FirebaseDialog;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import java.net.URL;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectToOnlineProjectDialog
extends FirebaseDialog {
    private static final int SUCCESS_RETURN_CODE = 0;
    private boolean isAcceptTos;
    @NotNull
    private ConnectToOnlineProjectPanel myConnectPanel;
    @NotNull
    private FirebaseConfig myFirebaseConfig;

    public ConnectToOnlineProjectDialog(@NotNull Module androidLibraryModule, @NotNull FirebaseConfig firebaseConfig, @NotNull Collection<OnlineProject> existingProjects, @Nullable(value="If TOS is not required") URL tosUrl) {
        super(androidLibraryModule.getProject());
        this.setOkLabel(FirebaseBundle.message("ui.connect.dialog.action.button.connect.to.firebase", new Object[0]));
        this.setTitle(FirebaseBundle.message("ui.connect.input.panel.title", new Object[0]));
        this.myConnectPanel = new ConnectToOnlineProjectPanel(androidLibraryModule, firebaseConfig, existingProjects, tosUrl);
        this.addContentPanel((JComponent)((Object)this.myConnectPanel));
        this.isAcceptTos = tosUrl != null;
        this.myFirebaseConfig = firebaseConfig;
        this.init();
        this.pack();
        FirebaseUsageTracker.trackEvent("connectDialogOpened");
    }

    private static Logger getLog() {
        return Logger.getInstance(ConnectToOnlineProjectPanel.class);
    }

    protected void doOKAction() {
        this.close(0);
        FirebaseUsageTracker.trackEvent("connectDialogSyncRequested");
        Project project = this.myConnectPanel.getAndroidModule().getProject();
        ConnectFirebaseTask task = this.myConnectPanel.isCreateMode() ? new ConnectFirebaseTask(this.myConnectPanel.getAndroidModule(), this.myFirebaseConfig, this.myConnectPanel.getNewProjectDisplayName(), this.myConnectPanel.getNewProjectCountryCode(), MobileSdkUtil.getCurrentTimeZoneId(), this.isAcceptTos) : new ConnectFirebaseTask(this.myConnectPanel.getAndroidModule(), this.myFirebaseConfig, this.myConnectPanel.getExistingProjectToConnect(), this.myConnectPanel.getNewProjectCountryCode(), MobileSdkUtil.getCurrentTimeZoneId(), this.isAcceptTos, this.myConnectPanel.getProjectDataSharingEnabled());
        FirebaseUiUtils.showInfoBalloon(project, FirebaseBundle.message("firebase.service.notification.connect.process.started", new Object[0]), null);
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable(value="When all input is valid")
    protected ValidationInfo doValidate() {
        super.doValidate();
        ValidationInfo validateInfo = this.myConnectPanel.doValidate();
        if (validateInfo != null) {
            ConnectToOnlineProjectDialog.getLog().debug("Component didn't validate: " + validateInfo.component.getName());
        }
        return validateInfo;
    }
}

