/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.AndroidClientMap;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseConfig {
    public static final String CONFIG_ELEMENT_PROJECT_INFO = "project_info";
    public static final String CONFIG_ELEMENT_PROJECT_NUMBER = "project_number";
    public static final String CONFIG_ELEMENT_PROJECT_ID = "project_id";
    @NotNull
    AndroidClientMap myResolvedAndroidClientMap;
    @Nullable(value="When a local Firebase configuration doesn't exist.")
    private File myLocalFirebaseConfigFile;
    @Nullable(value="When a local Firebase configuration doesn't exist.")
    private String myLocalFirebaseConfigProjectNumber;
    @Nullable(value="When a local Firebase configuration doesn't exist.")
    private String myLocalFirebaseConfigProjectId;
    @Nullable(value="When a local Firebase configuration doesn't exist.")
    private JsonElement myLocalFirebaseConfig;
    @Nullable(value="When a project in mOnlineProjects doesn't match the myLocalFirebaseConfigProjectNumber")
    private OnlineProject myResolvedProject;
    @NotNull
    private Module myAndroidApplicationModule;

    public FirebaseConfig(@NotNull Module androidApplicationModule, @Nullable(value="When online configuration comparison isn't needed") Collection<OnlineProject> projectsUserCanAccess) throws InvalidConfigException {
        Pair<AndroidClient, OnlineProject> matchedClientProjectPair;
        this.myAndroidApplicationModule = androidApplicationModule;
        this.locateLocalFirebaseConfig();
        if (this.myLocalFirebaseConfigFile != null && this.myLocalFirebaseConfig != null) {
            this.loadLocalFirebaseConfig();
        }
        this.myResolvedAndroidClientMap = AndroidClientMap.resolveAndroidClients(projectsUserCanAccess, androidApplicationModule);
        if (!Strings.isNullOrEmpty((String)this.myLocalFirebaseConfigProjectNumber) && projectsUserCanAccess != null) {
            for (OnlineProject project : projectsUserCanAccess) {
                if (project == null || !this.myLocalFirebaseConfigProjectNumber.equals(project.getProjectNumber())) continue;
                this.myResolvedProject = project;
                break;
            }
        }
        if (this.myResolvedProject == null && (matchedClientProjectPair = this.getFirstMatchedClientAndProject()) != null) {
            this.myResolvedProject = (OnlineProject)matchedClientProjectPair.getSecond();
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConfig.class);
    }

    public boolean isMultipleOnlineProjectsResolvedToAndroidClientMappings() {
        return this.myResolvedAndroidClientMap.getMappedOnlineProjects().size() > 1;
    }

    @Nullable(value="When no clients were matched.")
    public Pair<AndroidClient, OnlineProject> getFirstMatchedClientAndProject() {
        Map<AndroidClient, OnlineProject> clientToProjectMap = this.myResolvedAndroidClientMap.getClientToProjectMap();
        if (clientToProjectMap.size() > 0) {
            AndroidClient matchedClient = clientToProjectMap.keySet().iterator().next();
            OnlineProject matchedProject = clientToProjectMap.get(matchedClient);
            return Pair.create((Object)matchedClient, (Object)matchedProject);
        }
        return null;
    }

    @NotNull
    public AndroidClientMap getResolvedAndroidClientMap() {
        return this.myResolvedAndroidClientMap;
    }

    @Nullable(value="Local config doesn't exist or is invalid")
    public File getLocalFirebaseConfigFile() {
        return this.myLocalFirebaseConfigFile;
    }

    @Nullable(value="Local config doesn't exist or is invalid.")
    public String getLocalFirebaseConfigProjectId() {
        return this.myLocalFirebaseConfigProjectId;
    }

    public boolean isLocalConfigPresent() {
        return this.myLocalFirebaseConfigFile != null && this.myLocalFirebaseConfig != null;
    }

    @Nullable
    public OnlineProject getResolvedProject() {
        return this.myResolvedProject;
    }

    private void locateLocalFirebaseConfig() {
        VirtualFile imlFile = this.myAndroidApplicationModule.getModuleFile();
        if (imlFile == null) {
            return;
        }
        File configFile = new File(imlFile.getParent().getCanonicalPath(), "google-services.json");
        if (!configFile.exists()) {
            return;
        }
        FirebaseConfig.getLog().info("Config file being inspected: " + configFile);
        try {
            this.myLocalFirebaseConfig = new JsonParser().parse((Reader)Files.newReader((File)configFile, (Charset)Charsets.UTF_8));
            this.myLocalFirebaseConfigFile = configFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        FirebaseConfig.getLog().info("Config file loaded: " + this.myLocalFirebaseConfigFile);
    }

    public boolean isConnected() {
        return this.myResolvedProject != null && !this.myResolvedProject.isRequiredFirebaseMigration() && this.myResolvedAndroidClientMap.getUnregisteredClients().isEmpty() && !this.myResolvedAndroidClientMap.getClientToProjectMap().isEmpty() && this.myLocalFirebaseConfigProjectNumber != null && this.myLocalFirebaseConfigProjectNumber.equals(this.myResolvedProject.getProjectNumber());
    }

    private void loadLocalFirebaseConfig() throws InvalidConfigException {
        String projectId;
        String projectNumber;
        assert (this.myLocalFirebaseConfigFile != null);
        assert (this.myLocalFirebaseConfig != null);
        FirebaseConfig.getLog().info("Loading existing firebase config from file: " + this.myLocalFirebaseConfigFile.getAbsolutePath());
        if (!this.myLocalFirebaseConfig.isJsonObject()) {
            throw new InvalidConfigException(new InvalidDataException("Malformed json, couldn't find a root json object"), "firebaseService.internalError.invalidConfigFileFormat", this.myLocalFirebaseConfigFile.getAbsolutePath());
        }
        JsonObject rootObject = this.myLocalFirebaseConfig.getAsJsonObject();
        JsonObject projectInfoElement = rootObject.getAsJsonObject(CONFIG_ELEMENT_PROJECT_INFO);
        if (projectInfoElement == null) {
            throw new InvalidConfigException(new InvalidDataException("project_info couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", this.myLocalFirebaseConfigFile.getAbsolutePath());
        }
        JsonElement projectNumberElement = projectInfoElement.get(CONFIG_ELEMENT_PROJECT_NUMBER);
        if (projectNumberElement == null || Strings.isNullOrEmpty((String)(projectNumber = projectNumberElement.getAsString()))) {
            throw new InvalidConfigException(new InvalidDataException("project_number couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", this.myLocalFirebaseConfigFile.getAbsolutePath());
        }
        JsonElement projectIdElement = projectInfoElement.get(CONFIG_ELEMENT_PROJECT_ID);
        if (projectIdElement == null || Strings.isNullOrEmpty((String)(projectId = projectIdElement.getAsString()))) {
            throw new InvalidConfigException(new InvalidDataException("project_id couldn't be found in config file."), "firebaseService.internalError.invalidConfigFileFormat", this.myLocalFirebaseConfigFile.getAbsolutePath());
        }
        FirebaseConfig.getLog().info("Found existing project number in local config: " + projectNumber + " - " + projectId);
        this.myLocalFirebaseConfigProjectNumber = projectNumber;
        this.myLocalFirebaseConfigProjectId = projectId;
    }

    public static class InvalidConfigException
    extends InvalidDataException {
        InvalidConfigException(@NotNull Throwable cause, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
            super(FirebaseBundle.message(messageKey, messageArguments), cause);
        }
    }
}

