/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.android.builder.model.SigningConfig;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.templates.KeystoreUtils;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.client.util.Maps;
import com.google.common.collect.ImmutableList;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidClient {
    @NotNull
    private final String mySha1;
    @NotNull
    private final String myPackageName;

    private AndroidClient(@NotNull String packageName, @NotNull String sha1) throws InvalidDataException {
        if (Strings.isNullOrEmpty((String)packageName)) {
            throw new InvalidDataException("Invalid packageName: " + packageName);
        }
        if (Strings.isNullOrEmpty((String)sha1)) {
            throw new InvalidDataException("Invalid sha1: " + sha1);
        }
        this.myPackageName = packageName;
        this.mySha1 = AndroidClient.normalizeSha1(sha1);
    }

    @Nullable(value="When the packageName and/or sha1 are not valid")
    public static AndroidClient createClient(@NotNull String packageName, @NotNull String sha1) {
        try {
            return new AndroidClient(packageName, sha1);
        }
        catch (InvalidDataException exception) {
            return null;
        }
    }

    @NotNull
    private static String normalizeSha1(@NotNull String sha1) {
        return sha1.replaceAll(":", "").toLowerCase(Locale.ENGLISH);
    }

    private static boolean isSha1Equal(@NotNull String left, @NotNull String right) {
        return AndroidClient.normalizeSha1(left).equals(AndroidClient.normalizeSha1(right));
    }

    @NotNull
    public static Collection<AndroidClient> getAndroidClients(@NotNull Module androidModule, @NotNull AndroidFacet appAndroidFacet) {
        ArrayList<AndroidClient> androidClients = new ArrayList<AndroidClient>();
        AndroidGradleModel gradleModel = AndroidGradleModel.get((Module)androidModule);
        if (gradleModel == null) {
            FirebaseUiUtils.showTrackedErrorBalloon(androidModule.getProject(), null, "firebaseService.userError.gradleSyncNeeded", new Object[0]);
            throw new IllegalStateException("Couldn't retrieve Android gradle model for current Android model");
        }
        Collection variants = gradleModel.getAndroidProject().getVariants();
        HashMap signingConfigMap = Maps.newHashMap();
        gradleModel.getAndroidProject().getSigningConfigs().forEach(signingConfig -> signingConfigMap.put(signingConfig.getName(), signingConfig));
        for (Variant variant : variants) {
            AndroidClient.getLog().debug("Found variant to inspect: " + variant);
            String packageName = variant.getMainArtifact().getApplicationId();
            String sha1 = AndroidClient.getSigningCertSha1(androidModule, appAndroidFacet, signingConfigMap, variant);
            if (Strings.isNullOrEmpty((String)packageName) || Strings.isNullOrEmpty((String)sha1)) {
                AndroidClient.getLog().warn("Ignoring variant because signing config couldn't be found, applicationId: " + packageName + ", buildType: " + variant.getBuildType());
                continue;
            }
            AndroidClient.getLog().info("Found variant:" + packageName + " - " + sha1);
            try {
                AndroidClient client = new AndroidClient(packageName, sha1);
                androidClients.add(client);
            }
            catch (InvalidDataException | IllegalArgumentException exception) {
                AndroidClient.getLog().info("Ignoring variant with '" + packageName + "' and cert sha1 '" + sha1 + "'");
            }
        }
        return ImmutableList.copyOf(androidClients);
    }

    @Nullable(value="When the SHA1 couldn't be calculated")
    private static String getSigningCertSha1(@NotNull Module androidModule, @NotNull AndroidFacet appAndroidFacet, @NotNull Map<String, SigningConfig> signingConfigMap, @NotNull Variant variant) {
        SigningConfig signingConfig = null;
        File storeFile = null;
        if (!Strings.isNullOrEmpty((String)variant.getMainArtifact().getSigningConfigName())) {
            signingConfig = signingConfigMap.get(variant.getMainArtifact().getSigningConfigName());
            if (signingConfig != null && signingConfig.getStoreFile() != null) {
                storeFile = signingConfig.getStoreFile();
            }
        } else if ("debug".equals(variant.getBuildType())) {
            try {
                storeFile = KeystoreUtils.getDebugKeystore((AndroidFacet)appAndroidFacet);
            }
            catch (Exception e) {
                FirebaseUiUtils.showWarningBalloon(androidModule.getProject(), FirebaseBundle.message("firebaseConnectAction.userError.couldNotFileDefaultDebugKeystore", new Object[0]), e);
            }
        }
        if (storeFile == null) {
            return null;
        }
        try {
            if (signingConfig != null && !Strings.isNullOrEmpty((String)signingConfig.getKeyAlias())) {
                return KeystoreUtils.sha1((File)signingConfig.getStoreFile(), (String)signingConfig.getKeyAlias(), (String)signingConfig.getStorePassword());
            }
            return KeystoreUtils.sha1((File)storeFile);
        }
        catch (Exception exception) {
            AndroidClient.getLog().warn("Skipping variant; unable to calculate SHA1 of certificate in " + storeFile.getAbsolutePath());
            return null;
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(AndroidClient.class);
    }

    @NotNull
    public String getSha1() {
        return this.mySha1;
    }

    @NotNull
    public String getPackageName() {
        return this.myPackageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidClient that = (AndroidClient)o;
        if (!AndroidClient.isSha1Equal(this.mySha1, that.mySha1)) {
            return false;
        }
        return this.myPackageName.equals(that.myPackageName);
    }

    public String toString() {
        return "AndroidClient{myPackageName='" + this.myPackageName + '\'' + ", mySha1='" + this.mySha1 + '\'' + '}';
    }

    public int hashCode() {
        int result = this.mySha1.hashCode();
        result = 31 * result + this.myPackageName.hashCode();
        return result;
    }
}

