/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.datamodel.StepElementType;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.IconLoader;
import java.io.Reader;
import java.util.List;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

@XmlRootElement(name="tutorialBundle")
public class TutorialBundle
implements TutorialBundleData {
    private static final int VERSION = 1;
    @XmlAttribute(name="minPluginVersion")
    private Integer myMinPluginVersion;
    @XmlAttribute(name="name")
    private String myName;
    @XmlAttribute(name="icon")
    @Nullable
    private String myIcon;
    @XmlAttribute(name="logo")
    @Nullable
    private String myLogo;
    @XmlAttribute(name="id")
    private String myId;
    @XmlAttribute(name="contentRoot")
    private String myContentRoot;
    @XmlAttribute(name="resourceRoot")
    private String myResourceRoot;
    @XmlElement(name="welcome")
    private String myWelcome;
    @XmlElement(name="learnMoreLink")
    private String myLearnMoreLink;
    @XmlElements(value={@XmlElement(name="feature", type=Feature.class)})
    private List<Feature> myFeatures = Lists.newArrayList();

    public static TutorialBundle parse(@NotNull Reader xmlReader) throws JAXBException {
        return TutorialBundle.unmarshal(xmlReader);
    }

    private static TutorialBundle unmarshal(@NotNull Reader xmlReader) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{TutorialBundle.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (TutorialBundle)unmarshaller.unmarshal(xmlReader);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            return null;
        }
        return IconLoader.getIcon((String)(this.myResourceRoot + "/" + this.myIcon));
    }

    public Icon getLogo() {
        if (this.myLogo == null) {
            return null;
        }
        return IconLoader.getIcon((String)(this.myResourceRoot + "/" + this.myLogo));
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getContentRoot() {
        return this.myContentRoot;
    }

    @NotNull
    public List<Feature> getFeatures() {
        return ImmutableList.copyOf(this.myFeatures);
    }

    public Integer getMinPluginVersion() {
        return this.myMinPluginVersion;
    }

    @NotNull
    public String getWelcome() {
        return this.myWelcome;
    }

    public String getLearnMoreLink() {
        return this.myLearnMoreLink;
    }

    public String toString() {
        return "TutorialBundle{myMinPluginVersion=" + this.myMinPluginVersion + ", myName='" + this.myName + '\'' + ", myIcon='" + this.myIcon + '\'' + ", myLogo='" + this.myLogo + '\'' + ", myId='" + this.myId + '\'' + ", myContentRoot='" + this.myContentRoot + '\'' + ", myResourceRoot='" + this.myResourceRoot + '\'' + ", myWelcome='" + this.myWelcome + '\'' + ", myLearnMoreLink='" + this.myLearnMoreLink + '\'' + ", myFeatures=" + this.myFeatures + '}';
    }

    public static final class Version {
        @XmlAttribute(name="name", required=true)
        private String myName;
        @XmlAttribute(name="min", required=true)
        private String myMin;
        @XmlAttribute(name="max")
        private String myMax;

        public String getName() {
            return this.myName;
        }

        public String getMin() {
            return this.myMin;
        }

        @Nullable
        public String getMax() {
            return this.myMax;
        }

        public String toString() {
            return "Version{myName='" + this.myName + '\'' + ", myMin='" + this.myMin + '\'' + ", myMax='" + this.myMax + '\'' + '}';
        }
    }

    public static final class TargetVersions {
        @XmlElements(value={@XmlElement(name="target", type=Version.class)})
        private List<Version> myVersions = Lists.newArrayList();

        public List<Version> getVersions() {
            return this.myVersions;
        }

        public String toString() {
            return "TargetVersions{myVersions=" + this.myVersions + '}';
        }
    }

    public static final class Action
    implements ActionData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="actionArgument")
        private String myActionArgument;
        @XmlAttribute(name="successMessage")
        private String mySuccessMessage;
        @XmlAttribute(name="editAction")
        private String myEditAction;

        public String getLabel() {
            return this.myLabel;
        }

        public String getKey() {
            return this.myKey;
        }

        public String getActionArgument() {
            return this.myActionArgument;
        }

        public String getSuccessMessage() {
            return this.mySuccessMessage;
        }

        public String getEditAction() {
            return this.myEditAction;
        }

        public String toString() {
            return "Action{myLabel='" + this.myLabel + "'" + ", myKey='" + this.myKey + "'" + ", myActionArgument='" + this.myActionArgument + "'" + ", mySuccessMessage='" + this.mySuccessMessage + "'" + ", myEditAction='" + this.myEditAction + "'" + '}';
        }
    }

    public static final class Code {
        @XmlValue
        private String myCode;
        @XmlAttribute(name="fileType")
        private String myCodeType;

        public String getCode() {
            return this.myCode;
        }

        public FileType getCodeType() {
            if (this.myCodeType == null) {
                return null;
            }
            String type = this.myCodeType.trim().toUpperCase();
            if (type.equals("JAVA")) {
                return StdFileTypes.JAVA;
            }
            if (type.equals("XML")) {
                return StdFileTypes.XML;
            }
            if (type.equals("GROOVY")) {
                return GroovyFileType.GROOVY_FILE_TYPE;
            }
            if (type.equals("PLAIN_TEXT")) {
                return StdFileTypes.PLAIN_TEXT;
            }
            return null;
        }
    }

    public static final class StepElement
    implements StepElementData {
        private StepElementType myType;
        @XmlElement(name="code", type=Code.class)
        private Code myCode;
        @XmlElement(name="section")
        private String mySection;
        @XmlElement(name="action", type=Action.class)
        private Action myAction;

        public StepElementType getType() {
            if (this.myType != null) {
                return this.myType;
            }
            if (this.myAction != null) {
                this.myType = StepElementType.ACTION;
            } else if (this.mySection != null) {
                this.myType = StepElementType.SECTION;
            } else if (this.myCode != null) {
                this.myType = StepElementType.CODE;
            }
            if (this.myType == null) {
                throw new RuntimeException("Unsupported StepElement.");
            }
            return this.myType;
        }

        public String getCode() {
            return this.myCode.getCode();
        }

        public FileType getCodeType() {
            return this.myCode == null ? null : this.myCode.getCodeType();
        }

        public String getSection() {
            return this.mySection;
        }

        public Action getAction() {
            return this.myAction;
        }

        public String toString() {
            return "StepElement{myType='" + this.getType() + "'" + '}';
        }
    }

    public static final class Step
    implements StepData {
        @XmlElements(value={@XmlElement(name="stepElement", type=StepElement.class)})
        private List<StepElement> myStepElements = Lists.newArrayList();
        @XmlAttribute(name="label")
        private String myLabel;

        public List<StepElement> getStepElements() {
            return ImmutableList.copyOf(this.myStepElements);
        }

        public String getLabel() {
            return this.myLabel;
        }

        public String toString() {
            return "Step{myLabel='" + this.myLabel + "'" + '}';
        }
    }

    public static final class Tutorial
    implements TutorialData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlElement(name="description")
        private String myDescription;
        @XmlAttribute(name="remoteLink")
        private String myRemoteLink;
        @XmlAttribute(name="remoteLinkLabel")
        private String myRemoteLinkLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlElement(name="targetVersions", type=TargetVersions.class)
        private TargetVersions myTargetVersions = new TargetVersions();
        @XmlElements(value={@XmlElement(name="step", type=Step.class)})
        private List<Step> mySteps = Lists.newArrayList();

        public String getLabel() {
            return this.myLabel;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public String getRemoteLink() {
            return this.myRemoteLink;
        }

        public String getRemoteLinkLabel() {
            return this.myRemoteLinkLabel;
        }

        public String getKey() {
            return this.myKey;
        }

        public List<Version> getVersions() {
            return this.myTargetVersions.getVersions();
        }

        public List<Step> getSteps() {
            return ImmutableList.copyOf(this.mySteps);
        }

        public String toString() {
            return "Tutorial{myLabel='" + this.myLabel + '\'' + ", myDescription='" + this.myDescription + '\'' + ", myRemoteLink='" + this.myRemoteLink + '\'' + ", myRemoteLinkLabel='" + this.myRemoteLinkLabel + '\'' + ", myKey='" + this.myKey + '\'' + ", myTargetVersions=" + this.myTargetVersions + ", mySteps=" + this.mySteps + '}';
        }
    }

    public static final class Feature
    implements FeatureData {
        @XmlAttribute(name="name")
        @NotNull
        private String myName;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIcon;
        @XmlAttribute(name="resourceRoot")
        @NotNull
        private String myResourceRoot;
        @XmlAttribute(name="serviceId")
        @NotNull
        private String myServiceId;
        @XmlElements(value={@XmlElement(name="resource", type=String.class)})
        private List<String> myResources = Lists.newArrayList();
        @XmlElement(name="description")
        private String myDescription;
        @XmlElements(value={@XmlElement(name="tutorial", type=Tutorial.class)})
        private List<Tutorial> myTutorials = Lists.newArrayList();

        @NotNull
        public List<String> getResources() {
            return ImmutableList.copyOf(this.myResources);
        }

        @NotNull
        public String getResourceRoot() {
            return this.myResourceRoot;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getServiceId() {
            return this.myServiceId;
        }

        @Nullable
        public Icon getIcon() {
            if (this.myIcon == null) {
                return null;
            }
            return IconLoader.getIcon((String)(this.myResourceRoot + "/" + this.myIcon));
        }

        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public List<Tutorial> getTutorials() {
            return ImmutableList.copyOf(this.myTutorials);
        }

        public String toString() {
            return "Feature{myName='" + this.myName + "'" + ", myResourceRoot='" + this.myResourceRoot + "'" + ", myResources=" + this.myResources + '}';
        }
    }
}

