/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.view.FeaturesPanel;
import com.android.tools.idea.structure.services.DeveloperServiceCreator;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.collections.ObservableList;
import com.google.services.creators.FileServiceCreators;
import com.google.services.firebase.TutorialBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseServiceCreators
extends FileServiceCreators {
    private static final String SERVICE_CONFIG_FILENAME = "/firebase_service_bundle.xml";
    private static final String TUTORIAL_CONFIG_FILENAME = "/firebase_tutorial_bundle.xml";
    private TutorialBundle myBundle = null;

    private static Logger getLog() {
        return Logger.getInstance(FirebaseServiceCreators.class);
    }

    @NotNull
    public Component getPanel(@NotNull DeveloperServiceMap serviceMap) {
        TutorialBundle bundle = this.getBundle();
        if (bundle == null) {
            throw new IllegalStateException("Unable to acquire TutorialBundle");
        }
        return new FeaturesPanel((TutorialBundleData)bundle, serviceMap);
    }

    @Nullable
    private TutorialBundle getBundle() {
        if (this.myBundle != null) {
            return this.myBundle;
        }
        URL resource = this.getResource(TUTORIAL_CONFIG_FILENAME);
        if (resource == null) {
            throw new RuntimeException(String.format("Could not find service file %1$s", TUTORIAL_CONFIG_FILENAME));
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = resource.openStream();
            inputStreamReader = new InputStreamReader(inputStream);
            this.myBundle = TutorialBundle.parse(inputStreamReader);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse /firebase_tutorial_bundle.xml to read services configuration.", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception e) {
                FirebaseServiceCreators.getLog().warn((Throwable)e);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                FirebaseServiceCreators.getLog().warn((Throwable)e);
            }
        }
        return this.myBundle;
    }

    protected DeveloperServiceCreator getServiceCreator(final String resourceRoot, List<String> resources) {
        final String[] resourceArray = ArrayUtil.toStringArray(resources);
        return new DeveloperServiceCreator(){

            @NotNull
            protected String getResourceRoot() {
                return resourceRoot;
            }

            @NotNull
            protected String[] getResources() {
                return resourceArray;
            }

            private void addDependenciesAndClasspathsToContext(@NotNull ServiceContext serviceContext) {
                for (TutorialBundle.Feature feature : FirebaseServiceCreators.this.getBundle().getFeatures()) {
                    for (TutorialBundle.Tutorial tutorial : feature.getTutorials()) {
                        if (!feature.getResourceRoot().equals(resourceRoot)) continue;
                        ArrayList<String> dependencies = new ArrayList<String>();
                        ArrayList<String> classpaths = new ArrayList<String>();
                        for (TutorialBundle.Version version : tutorial.getVersions()) {
                            if (version.getName().endsWith(":google-services")) {
                                classpaths.add(String.format("%s:%s", version.getName(), version.getMin()));
                                continue;
                            }
                            dependencies.add(String.format("%s:%s", version.getName(), version.getMin()));
                        }
                        serviceContext.putValue("dependencies", (ObservableValue)new ObservableList(dependencies));
                        serviceContext.putValue("classpaths", (ObservableValue)new ObservableList(classpaths));
                    }
                }
            }

            protected void initializeContext(@NotNull ServiceContext serviceContext) {
                serviceContext.hiddenFromStructureDialog().set((Object)true);
                this.addDependenciesAndClasspathsToContext(serviceContext);
            }
        };
    }

    @NotNull
    public String getBundleId() {
        return "DeveloperServices.Firebase";
    }

    protected String getResourceConfigFileName() {
        return SERVICE_CONFIG_FILENAME;
    }
}

