/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.InvalidThreadTypeException;
import com.google.services.firebase.ConnectFirebaseTask;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseUsageTracker;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.ConnectToOnlineProjectDialog;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.ReconnectDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseConnectAction
implements AssistActionHandler {
    protected static final String ACTION_KEY = "firebase.connect";

    private static void openConnectDialog(final @NotNull Module module, boolean attemptLogin) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = module.getProject();
        try {
            FirebaseUiUtils.checkGradleState(module);
        }
        catch (FirebaseUiUtils.GradleStateException exception) {
            Messages.showWarningDialog((Project)module.getProject(), (String)FirebaseBundle.message("firebaseService.userError.gradleSyncNeeded", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]));
            return;
        }
        GoogleLogin googleLogin = GoogleLogin.getInstance();
        if (!googleLogin.isLoggedIn() && attemptLogin) {
            try {
                FirebaseUsageTracker.trackEvent("attemptLogin");
                GoogleLogin.promptToLogIn(null, (IGoogleLoginCompletedCallback)new IGoogleLoginCompletedCallback(){

                    public void onLoginCompleted() {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                FirebaseConnectAction.openConnectDialog(module, false);
                            }
                        });
                    }
                });
            }
            catch (InvalidThreadTypeException invalidThreadException) {
                FirebaseUiUtils.showTrackedErrorBalloon(project, invalidThreadException, "firebaseService.internalError.couldNotVerifySignIn", new Object[0]);
            }
            return;
        }
        if (!googleLogin.isLoggedIn()) {
            FirebaseConnectAction.getLog().warn("Google Login rejected.");
            return;
        }
        FirebaseUsageTracker.trackEvent("loginSuccess");
        PrepareConnectDialogTask task = new PrepareConnectDialogTask(module, module.getProject());
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, task.getProgressIndicator());
    }

    private static void showAlreadyConnectedDialog(final @NotNull FirebaseConfig firebaseConfig, final @NotNull Module androidApplicationModule, final @NotNull OnlineProject matchedProject, final URL pendingTermsUrl) {
        final Project project = androidApplicationModule.getProject();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ReconnectDialog dialog = new ReconnectDialog(project, firebaseConfig, pendingTermsUrl);
                    if (dialog.showAndGet()) {
                        FirebaseUsageTracker.trackEvent("reconnectDialogSyncRequested");
                        FirebaseUiUtils.showInfoBalloon(project, FirebaseBundle.message("firebase.service.notification.connect.process.started", new Object[0]), null);
                        FirebaseConnectAction.getLog().info("Project data sharing setting was: " + (Object)((Object)dialog.getProjectDataSharingEnabled()));
                        ProgressManager.getInstance().run((Task)new ConnectFirebaseTask(androidApplicationModule, firebaseConfig, matchedProject, dialog.getCountryCode(), MobileSdkUtil.getCurrentTimeZoneId(), pendingTermsUrl != null, dialog.getProjectDataSharingEnabled()));
                    } else {
                        FirebaseUiUtils.showWarningBalloon(project, FirebaseBundle.message("firebaseService.userNotification.connectedCancelled", new Object[0]), null);
                    }
                }
                catch (IllegalStateException exception) {
                    FirebaseUiUtils.showTrackedErrorBalloon(project, exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
                }
            }
        });
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseConnectAction.class);
    }

    @Nullable(value="Returns null when a valid module doesn't exist.")
    private static Module getAndroidModuleToConnect(Project project) {
        Module selectedModule;
        Module[] eligibleModules = FirebaseConnectAction.filterEligibleModules(ModuleManager.getInstance((Project)project).getModules());
        if (eligibleModules.length < 1) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseConnectAction.userError.couldNotFindAndroidModule", new Object[0]);
            return null;
        }
        if (eligibleModules.length == 1) {
            selectedModule = eligibleModules[0];
            FirebaseConnectAction.getLog().debug("Found one Firebase project:" + selectedModule.getName());
        } else {
            ArrayList moduleSelectButtons = Lists.newArrayList();
            for (Module module : eligibleModules) {
                moduleSelectButtons.add(module.getName());
            }
            moduleSelectButtons.add(FirebaseBundle.message("firebase.service.dialog.action.button.cancel", new Object[0]));
            int choice = Messages.showDialog((Project)project, (String)FirebaseBundle.message("firebase.service.dialog.label.select.dialog", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]), (String[])ArrayUtil.toStringArray((Collection)moduleSelectButtons), (int)0, null);
            if (choice == eligibleModules.length) {
                return null;
            }
            selectedModule = eligibleModules[choice];
            FirebaseConnectAction.getLog().debug("Selected project: " + selectedModule.getName() + " to connect to Firebase");
        }
        return selectedModule;
    }

    private static Module[] filterEligibleModules(Module[] modules) {
        Iterable iterable = Iterables.filter(Arrays.asList(modules), (Predicate)new Predicate<Module>(){

            public boolean apply(Module input) {
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)input);
                return androidFacet != null && !androidFacet.isLibraryProject();
            }
        });
        return (Module[])Iterables.toArray((Iterable)iterable, Module.class);
    }

    @NotNull
    public String getId() {
        return ACTION_KEY;
    }

    public void handleAction(@Nullable(value="Not needed for this action") String actionArgument, @NotNull DeveloperServiceMap.DeveloperServiceList services) {
        FirebaseUsageTracker.trackEvent("projectConnectRequested");
        Module selectedModule = FirebaseConnectAction.getAndroidModuleToConnect(services.getProject());
        if (selectedModule == null) {
            return;
        }
        FirebaseConnectAction.openConnectDialog(selectedModule, true);
    }

    private static class PrepareConnectDialogTask
    extends Task.ConditionalModal {
        private final Module myModule;
        private final Project myProject;
        private boolean myCancelRequested;

        public ProgressIndicator getProgressIndicator() {
            return new BackgroundableProcessIndicator((Task.Backgroundable)this){

                protected void onRunningChange() {
                    if (this.isCanceled()) {
                        this.requestCancel();
                    }
                }
            };
        }

        public PrepareConnectDialogTask(Module module, Project project) {
            super(module.getProject(), FirebaseBundle.message("ui.connect.dialog.action.start", new Object[0]), true, PerformInBackgroundOption.DEAF);
            this.myModule = module;
            this.myProject = project;
            this.myCancelRequested = false;
        }

        public void requestCancel() {
            this.myCancelRequested = true;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            FirebaseConfig firebaseConfig;
            List<OnlineProject> existingProjects;
            URL pendingTermsUrl;
            MobileSdkWrapper mobileSdkWrapper;
            try {
                mobileSdkWrapper = MobileSdkUtil.getNewMobileSdkWrapper(GoogleLogin.getInstance());
            }
            catch (MobileSdkCommException exception) {
                this.showErrorIfNotCancelled(exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
                return;
            }
            try {
                pendingTermsUrl = mobileSdkWrapper.getPendingTosUrl();
            }
            catch (MobileSdkCommException exception) {
                this.showErrorIfNotCancelled(exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            try {
                existingProjects = mobileSdkWrapper.getExistingProjects();
            }
            catch (MobileSdkCommException exception) {
                this.showErrorIfNotCancelled(exception, FirebaseBundle.message("firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]), new Object[0]);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            try {
                firebaseConfig = new FirebaseConfig(this.myModule, existingProjects);
            }
            catch (FirebaseConfig.InvalidConfigException configException) {
                FirebaseUiUtils.showErrorBalloon(this.myModule.getProject(), configException.getMessage(), (Throwable)((Object)configException));
                return;
            }
            if (firebaseConfig.isMultipleOnlineProjectsResolvedToAndroidClientMappings()) {
                this.showErrorIfNotCancelled(null, "firebaseService.userNotification.multipleExistingMatchesFound", new Object[0]);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            if (firebaseConfig.isLocalConfigPresent()) {
                if (firebaseConfig.getResolvedProject() != null) {
                    if (this.assertUserAccess(firebaseConfig.getResolvedProject(), firebaseConfig)) {
                        return;
                    }
                    FirebaseConnectAction.showAlreadyConnectedDialog(firebaseConfig, this.myModule, firebaseConfig.getResolvedProject(), pendingTermsUrl);
                    return;
                }
                this.showErrorIfNotCancelled(null, "firebaseService.userError.existingConfigButNoMatchFound", firebaseConfig.getLocalFirebaseConfigFile(), firebaseConfig.getLocalFirebaseConfigProjectId());
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            Pair<AndroidClient, OnlineProject> matchedPair = firebaseConfig.getFirstMatchedClientAndProject();
            if (matchedPair != null) {
                OnlineProject matchedProject = (OnlineProject)matchedPair.getSecond();
                if (this.assertUserAccess(matchedProject, firebaseConfig)) {
                    return;
                }
                FirebaseConnectAction.showAlreadyConnectedDialog(firebaseConfig, this.myModule, (OnlineProject)matchedPair.second, pendingTermsUrl);
                return;
            }
            if (this.myCancelRequested) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    new ConnectToOnlineProjectDialog(this.myModule, firebaseConfig, existingProjects, pendingTermsUrl).show();
                }
                catch (IllegalStateException exception) {
                    this.showErrorIfNotCancelled(exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
                }
            });
        }

        private void showErrorIfNotCancelled(@Nullable Throwable throwable, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
            if (!this.myCancelRequested) {
                FirebaseUiUtils.showTrackedErrorBalloon(this.myProject, throwable, messageKey, messageArguments);
            } else {
                FirebaseUiUtils.logSilentError(messageKey);
            }
        }

        private boolean assertUserAccess(@NotNull OnlineProject matchedProject, @NotNull FirebaseConfig firebaseConfig) {
            boolean needToAddAndroidAuthClients;
            boolean bl = needToAddAndroidAuthClients = firebaseConfig.getResolvedAndroidClientMap().getUnregisteredClients().size() > 0;
            if ((matchedProject.isRequiredFirebaseMigration() || needToAddAndroidAuthClients) && !matchedProject.isEditable()) {
                String projectDisplayName = matchedProject.getDisplayName();
                if (Strings.isNullOrEmpty((String)projectDisplayName)) {
                    projectDisplayName = matchedProject.getProjectNumber();
                }
                FirebaseUiUtils.showTrackedErrorBalloon(this.myModule.getProject(), null, "connect.reconnect.dialog.noEditRightsToProject", projectDisplayName);
                return true;
            }
            return false;
        }
    }
}

