/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.indices.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class ModuleExcludeIndexImpl
implements ModuleExcludeIndex {
    private final Set<File> myExcludedRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
    private final Set<File> myContentRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
    private final Map<JpsModule, List<File>> myModuleToExcludesMap = new THashMap();

    public ModuleExcludeIndexImpl(JpsModel model) {
        String url;
        List allModules = model.getProject().getModules();
        for (Object module : allModules) {
            ArrayList<File> moduleExcludes = new ArrayList<File>();
            for (String string : module.getExcludeRootsList().getUrls()) {
                moduleExcludes.add(JpsPathUtil.urlToFile((String)string));
            }
            JpsJavaModuleExtension moduleExtension = JpsJavaExtensionService.getInstance().getModuleExtension((JpsModule)module);
            if (moduleExtension != null && !moduleExtension.isInheritOutput() && moduleExtension.isExcludeOutput()) {
                String testOutputUrl;
                String string = moduleExtension.getOutputUrl();
                if (string != null) {
                    moduleExcludes.add(JpsPathUtil.urlToFile((String)string));
                }
                if ((testOutputUrl = moduleExtension.getTestOutputUrl()) != null) {
                    moduleExcludes.add(JpsPathUtil.urlToFile((String)testOutputUrl));
                }
            }
            this.myModuleToExcludesMap.put((JpsModule)module, moduleExcludes);
            this.myExcludedRoots.addAll(moduleExcludes);
        }
        THashMap contentToModule = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        for (Object module : allModules) {
            for (String string : module.getContentRootsList().getUrls()) {
                File contentRoot = JpsPathUtil.urlToFile((String)string);
                contentToModule.put(contentRoot, module);
            }
        }
        ArrayList<File> parents = new ArrayList<File>();
        for (JpsModule module : allModules) {
            for (String contentUrl : module.getContentRootsList().getUrls()) {
                File contentRoot = JpsPathUtil.urlToFile((String)contentUrl);
                JpsModule parentModule = null;
                parents.clear();
                for (File parent = contentRoot.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    parents.add(parent);
                    if (!contentToModule.containsKey(parent)) continue;
                    parentModule = (JpsModule)contentToModule.get(parent);
                    break;
                }
                if (parentModule != null) {
                    this.myModuleToExcludesMap.get(parentModule).add(contentRoot);
                } else {
                    this.myContentRoots.add(contentRoot);
                }
                for (File file : parents) {
                    contentToModule.put(file, parentModule);
                }
            }
        }
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(model.getProject());
        if (projectExtension != null && !StringUtil.isEmpty((String)(url = projectExtension.getOutputUrl()))) {
            File file;
            File parent = file = JpsPathUtil.urlToFile((String)url);
            while (parent != null) {
                JpsModule module = (JpsModule)contentToModule.get(parent);
                if (module != null) {
                    this.myModuleToExcludesMap.get(module).add(file);
                }
                parent = FileUtil.getParentFile((File)parent);
            }
            this.myExcludedRoots.add(file);
        }
        for (List list : this.myModuleToExcludesMap.values()) {
            ((ArrayList)list).trimToSize();
        }
    }

    @Override
    public boolean isExcluded(File file) {
        return JpsPathUtil.isUnder(this.myExcludedRoots, (File)file);
    }

    @Override
    public boolean isInContent(File file) {
        return JpsPathUtil.isUnder(this.myContentRoots, (File)file);
    }

    @Override
    public Collection<File> getModuleExcludes(JpsModule module) {
        return this.myModuleToExcludesMap.get(module);
    }
}

