/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.io.IOException;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public abstract class CompositeStorageOwner
implements StorageOwner {
    protected abstract Iterable<? extends StorageOwner> getChildStorages();

    @Override
    public void flush(boolean memoryCachesOnly) {
        for (StorageOwner storageOwner : this.getChildStorages()) {
            if (storageOwner == null) continue;
            storageOwner.flush(memoryCachesOnly);
        }
    }

    @Override
    public void clean() throws IOException {
        IOException exc = null;
        for (StorageOwner storageOwner : this.getChildStorages()) {
            if (storageOwner == null) continue;
            try {
                storageOwner.clean();
            }
            catch (IOException e) {
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    public void close() throws IOException {
        IOException exc = null;
        for (StorageOwner storageOwner : this.getChildStorages()) {
            if (storageOwner == null) continue;
            try {
                storageOwner.close();
            }
            catch (IOException e) {
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }
}

