/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.impl.storage.BuildTargetStorages;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.CompositeStorageOwner;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.incremental.storage.OutputToTargetRegistry;
import org.jetbrains.jps.incremental.storage.SourceToOutputMappingImpl;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class BuildDataManager
implements StorageOwner {
    private static final int VERSION = 27 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.storage.BuildDataManager");
    private static final String SRC_TO_FORM_STORAGE = "src-form";
    private static final String OUT_TARGET_STORAGE = "out-target";
    private static final String MAPPINGS_STORAGE = "mappings";
    private static final int CONCURRENCY_LEVEL = BuildRunner.PARALLEL_BUILD_ENABLED ? IncProjectBuilder.MAX_BUILDER_THREADS : 1;
    private final ConcurrentMap<BuildTarget<?>, AtomicNotNullLazyValue<SourceToOutputMappingImpl>> mySourceToOutputs = new ConcurrentHashMap(16, 0.75f, CONCURRENCY_LEVEL);
    private final ConcurrentMap<BuildTarget<?>, AtomicNotNullLazyValue<BuildTargetStorages>> myTargetStorages = new ConcurrentHashMap(16, 0.75f, CONCURRENCY_LEVEL);
    private final OneToManyPathsMapping mySrcToFormMap;
    private final Mappings myMappings;
    private final BuildDataPaths myDataPaths;
    private final BuildTargetsState myTargetsState;
    private final OutputToTargetRegistry myOutputToTargetRegistry;
    private final File myVersionFile;
    private final StorageOwner myTargetStoragesOwner = new CompositeStorageOwner(){

        @Override
        protected Iterable<? extends StorageOwner> getChildStorages() {
            return new Iterable<StorageOwner>(){

                @Override
                public Iterator<StorageOwner> iterator() {
                    final Iterator iterator = BuildDataManager.this.myTargetStorages.values().iterator();
                    return new Iterator<StorageOwner>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public StorageOwner next() {
                            return (StorageOwner)((AtomicNotNullLazyValue)iterator.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            iterator.remove();
                        }
                    };
                }
            };
        }
    };
    private LazyValueFactory<BuildTarget<?>, SourceToOutputMappingImpl> SOURCE_OUTPUT_MAPPING_VALUE_FACTORY = new LazyValueFactory<BuildTarget<?>, SourceToOutputMappingImpl>(){

        @Override
        public AtomicNotNullLazyValue<SourceToOutputMappingImpl> create(final BuildTarget<?> key) {
            return new AtomicNotNullLazyValue<SourceToOutputMappingImpl>(){

                @NotNull
                protected SourceToOutputMappingImpl compute() {
                    try {
                        return new SourceToOutputMappingImpl(new File(BuildDataManager.this.getSourceToOutputMapRoot(key), "data"));
                    }
                    catch (IOException e) {
                        throw new BuildDataCorruptedException(e);
                    }
                }
            };
        }
    };
    private LazyValueFactory<BuildTarget<?>, BuildTargetStorages> TARGET_STORAGES_VALUE_FACTORY = new LazyValueFactory<BuildTarget<?>, BuildTargetStorages>(){

        @Override
        public AtomicNotNullLazyValue<BuildTargetStorages> create(final BuildTarget<?> target) {
            return new AtomicNotNullLazyValue<BuildTargetStorages>(){

                @NotNull
                protected BuildTargetStorages compute() {
                    return new BuildTargetStorages(target, BuildDataManager.this.myDataPaths);
                }
            };
        }
    };
    private Boolean myVersionDiffers = null;

    public BuildDataManager(BuildDataPaths dataPaths, BuildTargetsState targetsState, boolean useMemoryTempCaches) throws IOException {
        this.myDataPaths = dataPaths;
        this.myTargetsState = targetsState;
        this.mySrcToFormMap = new OneToManyPathsMapping(new File(this.getSourceToFormsRoot(), "data"));
        this.myOutputToTargetRegistry = new OutputToTargetRegistry(new File(this.getOutputToSourceRegistryRoot(), "data"));
        this.myMappings = new Mappings(BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot()), useMemoryTempCaches);
        this.myVersionFile = new File(this.myDataPaths.getDataStorageRoot(), "version.dat");
    }

    public BuildTargetsState getTargetsState() {
        return this.myTargetsState;
    }

    public OutputToTargetRegistry getOutputToTargetRegistry() {
        return this.myOutputToTargetRegistry;
    }

    public SourceToOutputMapping getSourceToOutputMap(BuildTarget<?> target) throws IOException {
        SourceToOutputMappingImpl sourceToOutputMapping = BuildDataManager.fetchValue(this.mySourceToOutputs, target, this.SOURCE_OUTPUT_MAPPING_VALUE_FACTORY);
        int buildTargetId = this.myTargetsState.getBuildTargetId(target);
        return new SourceToOutputMappingWrapper(sourceToOutputMapping, buildTargetId);
    }

    @NotNull
    public <S extends StorageOwner> S getStorage(@NotNull BuildTarget<?> target, @NotNull StorageProvider<S> provider) throws IOException {
        BuildTargetStorages storages = BuildDataManager.fetchValue(this.myTargetStorages, target, this.TARGET_STORAGES_VALUE_FACTORY);
        return storages.getOrCreateStorage(provider);
    }

    public OneToManyPathsMapping getSourceToFormMap() {
        return this.mySrcToFormMap;
    }

    public Mappings getMappings() {
        return this.myMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTargetStorages(BuildTarget<?> target) throws IOException {
        try {
            AtomicNotNullLazyValue storages = (AtomicNotNullLazyValue)this.myTargetStorages.remove(target);
            if (storages != null) {
                ((BuildTargetStorages)storages.getValue()).close();
            }
        }
        finally {
            File[] targetData = this.myDataPaths.getTargetDataRoot(target).listFiles();
            if (targetData != null) {
                File srcOutputMapRoot = this.getSourceToOutputMapRoot(target);
                for (File dataFile : targetData) {
                    if (FileUtil.filesEqual((File)dataFile, (File)srcOutputMapRoot)) continue;
                    FileUtil.delete((File)dataFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() throws IOException {
        try {
            this.myTargetStoragesOwner.clean();
            this.myTargetStorages.clear();
        }
        finally {
            try {
                this.closeSourceToOutputStorages();
            }
            finally {
                try {
                    BuildDataManager.wipeStorage(this.getSourceToFormsRoot(), this.mySrcToFormMap);
                }
                finally {
                    try {
                        BuildDataManager.wipeStorage(this.getOutputToSourceRegistryRoot(), this.myOutputToTargetRegistry);
                    }
                    finally {
                        Mappings mappings = this.myMappings;
                        if (mappings != null) {
                            Mappings mappings2 = mappings;
                            synchronized (mappings2) {
                                mappings.clean();
                            }
                        } else {
                            FileUtil.delete((File)BuildDataManager.getMappingsRoot(this.myDataPaths.getDataStorageRoot()));
                        }
                    }
                }
            }
            this.myTargetsState.clean();
        }
        this.saveVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean memoryCachesOnly) {
        this.myTargetStoragesOwner.flush(memoryCachesOnly);
        for (AtomicNotNullLazyValue mapping : this.mySourceToOutputs.values()) {
            ((SourceToOutputMappingImpl)mapping.getValue()).flush(memoryCachesOnly);
        }
        this.myOutputToTargetRegistry.flush(memoryCachesOnly);
        this.mySrcToFormMap.flush(memoryCachesOnly);
        Mappings mappings = this.myMappings;
        if (mappings != null) {
            Mappings mappings2 = mappings;
            synchronized (mappings2) {
                mappings.flush(memoryCachesOnly);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.myTargetsState.save();
            try {
                this.myTargetStoragesOwner.close();
            }
            finally {
                this.myTargetStorages.clear();
            }
        }
        finally {
            try {
                this.closeSourceToOutputStorages();
            }
            finally {
                try {
                    this.myOutputToTargetRegistry.close();
                }
                finally {
                    try {
                        BuildDataManager.closeStorage(this.mySrcToFormMap);
                    }
                    finally {
                        Mappings mappings = this.myMappings;
                        if (mappings != null) {
                            try {
                                mappings.close();
                            }
                            catch (BuildDataCorruptedException e) {
                                throw e.getCause();
                            }
                        }
                    }
                }
            }
        }
    }

    public void closeSourceToOutputStorages(Collection<BuildTargetChunk> chunks) throws IOException {
        for (BuildTargetChunk chunk : chunks) {
            for (BuildTarget<?> target : chunk.getTargets()) {
                AtomicNotNullLazyValue mapping = (AtomicNotNullLazyValue)this.mySourceToOutputs.remove(target);
                if (mapping == null) continue;
                ((SourceToOutputMappingImpl)mapping.getValue()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSourceToOutputStorages() throws IOException {
        IOException ex = null;
        try {
            for (AtomicNotNullLazyValue mapping : this.mySourceToOutputs.values()) {
                try {
                    ((SourceToOutputMappingImpl)mapping.getValue()).close();
                }
                catch (IOException e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
        }
        finally {
            this.mySourceToOutputs.clear();
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static <K, V> V fetchValue(ConcurrentMap<K, AtomicNotNullLazyValue<V>> container, K key, LazyValueFactory<K, V> valueFactory) throws IOException {
        AtomicNotNullLazyValue<V> newValue;
        AtomicNotNullLazyValue<V> lazy = (AtomicNotNullLazyValue<V>)container.get(key);
        if (lazy == null && (lazy = container.putIfAbsent(key, newValue = valueFactory.create(key))) == null) {
            lazy = newValue;
        }
        try {
            return (V)lazy.getValue();
        }
        catch (BuildDataCorruptedException e) {
            throw e.getCause();
        }
    }

    private File getSourceToOutputMapRoot(BuildTarget<?> target) {
        return new File(this.myDataPaths.getTargetDataRoot(target), "src-out");
    }

    private File getSourceToFormsRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), SRC_TO_FORM_STORAGE);
    }

    private File getOutputToSourceRegistryRoot() {
        return new File(this.myDataPaths.getDataStorageRoot(), OUT_TARGET_STORAGE);
    }

    public BuildDataPaths getDataPaths() {
        return this.myDataPaths;
    }

    public static File getMappingsRoot(File dataStorageRoot) {
        return new File(dataStorageRoot, MAPPINGS_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wipeStorage(File root, @Nullable AbstractStateStorage<?, ?> storage) {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.wipe();
            }
        } else {
            FileUtil.delete((File)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeStorage(@Nullable AbstractStateStorage<?, ?> storage) throws IOException {
        if (storage != null) {
            AbstractStateStorage<?, ?> abstractStateStorage = storage;
            synchronized (abstractStateStorage) {
                storage.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean versionDiffers() {
        boolean bl;
        Boolean cached = this.myVersionDiffers;
        if (cached != null) {
            return cached;
        }
        DataInputStream is = new DataInputStream(new FileInputStream(this.myVersionFile));
        try {
            boolean diff = is.readInt() != VERSION;
            this.myVersionDiffers = diff;
            bl = diff;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (FileNotFoundException ignored) {
                return false;
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
                return true;
            }
        }
        is.close();
        return bl;
    }

    public void saveVersion() {
        Boolean differs = this.myVersionDiffers;
        if (differs == null || differs.booleanValue()) {
            try {
                FileUtil.createIfDoesntExist((File)this.myVersionFile);
                DataOutputStream os = new DataOutputStream(new FileOutputStream(this.myVersionFile));
                try {
                    os.writeInt(VERSION);
                    this.myVersionDiffers = Boolean.FALSE;
                }
                finally {
                    os.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class SourceToOutputMappingWrapper
    implements SourceToOutputMapping {
        private final SourceToOutputMapping myDelegate;
        private final int myBuildTargetId;

        SourceToOutputMappingWrapper(SourceToOutputMapping delegate, int buildTargetId) {
            this.myDelegate = delegate;
            this.myBuildTargetId = buildTargetId;
        }

        @Override
        public void setOutputs(@NotNull String srcPath, @NotNull Collection<String> outputs) throws IOException {
            try {
                this.myDelegate.setOutputs(srcPath, outputs);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputs, this.myBuildTargetId);
            }
        }

        @Override
        public void setOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            try {
                this.myDelegate.setOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void appendOutput(@NotNull String srcPath, @NotNull String outputPath) throws IOException {
            try {
                this.myDelegate.appendOutput(srcPath, outputPath);
            }
            finally {
                BuildDataManager.this.myOutputToTargetRegistry.addMapping(outputPath, this.myBuildTargetId);
            }
        }

        @Override
        public void remove(@NotNull String srcPath) throws IOException {
            this.myDelegate.remove(srcPath);
        }

        @Override
        public void removeOutput(@NotNull String sourcePath, @NotNull String outputPath) throws IOException {
            this.myDelegate.removeOutput(sourcePath, outputPath);
        }

        @Override
        @NotNull
        public Collection<String> getSources() throws IOException {
            return this.myDelegate.getSources();
        }

        @Override
        @Nullable
        public Collection<String> getOutputs(@NotNull String srcPath) throws IOException {
            return this.myDelegate.getOutputs(srcPath);
        }

        @Override
        @NotNull
        public Iterator<String> getSourcesIterator() throws IOException {
            return this.myDelegate.getSourcesIterator();
        }
    }

    private static interface LazyValueFactory<K, V> {
        public AtomicNotNullLazyValue<V> create(K var1);
    }
}

