/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class BuildingTargetProgressMessage
extends BuildMessage {
    private final Collection<? extends BuildTarget<?>> myTargets;
    @NotNull
    private final Event myEventType;

    public BuildingTargetProgressMessage(@NotNull Collection<? extends BuildTarget<?>> targets, @NotNull Event event) {
        super(BuildingTargetProgressMessage.composeMessageText(targets, event), BuildMessage.Kind.PROGRESS);
        this.myTargets = targets;
        this.myEventType = event;
    }

    private static String composeMessageText(Collection<? extends BuildTarget<?>> targets, Event event) {
        String targetsString = StringUtil.join(targets, (Function)new NotNullFunction<BuildTarget<?>, String>(){

            @NotNull
            public String fun(BuildTarget<?> dom) {
                return dom.getPresentableName();
            }
        }, (String)", ");
        return (event == Event.STARTED ? "Started" : "Finished") + " building " + targetsString;
    }

    @NotNull
    public Collection<? extends BuildTarget<?>> getTargets() {
        return this.myTargets;
    }

    @NotNull
    public Event getEventType() {
        return this.myEventType;
    }

    public static enum Event {
        STARTED,
        FINISHED;

    }
}

