/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;

public class JarBasedArtifactRootDescriptor
extends ArtifactRootDescriptor {
    private final String myPathInJar;
    private final Condition<String> myPathInJarFilter;

    public JarBasedArtifactRootDescriptor(@NotNull File jarFile, @NotNull String pathInJar, @NotNull SourceFileFilter filter, int index, @NotNull ArtifactBuildTarget target, @NotNull DestinationInfo destinationInfo, @NotNull Condition<String> pathInJarFilter) {
        super(jarFile, filter, index, target, destinationInfo);
        this.myPathInJar = pathInJar;
        this.myPathInJarFilter = pathInJarFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEntries(EntryProcessor processor) throws IOException {
        if (!this.myRoot.isFile()) {
            return;
        }
        String prefix = StringUtil.trimStart((String)this.myPathInJar, (String)"/");
        if (!StringUtil.endsWithChar((CharSequence)prefix, (char)'/')) {
            prefix = prefix + "/";
        }
        if (prefix.equals("/")) {
            prefix = "";
        }
        try {
            ZipFile zipFile = new ZipFile(this.myRoot);
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String relativePath;
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(prefix) || !this.myPathInJarFilter.value((Object)(relativePath = name.substring(prefix.length())))) continue;
                    processor.process(entry.isDirectory() ? null : zipFile.getInputStream(entry), relativePath, entry);
                }
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException e) {
            throw new IOException("Error occurred during processing zip file " + this.myRoot + ": " + e.getMessage(), e);
        }
    }

    @Override
    protected String getFullPath() {
        return this.myRoot.getPath() + "!/" + this.myPathInJar;
    }

    @Override
    public void copyFromRoot(final String filePath, final int rootIndex, final String outputPath, CompileContext context, final BuildOutputConsumer outputConsumer, final ArtifactOutputToSourceMapping outSrcMapping) throws IOException {
        if (!this.myRoot.isFile()) {
            return;
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        if (logger.isEnabled()) {
            logger.logCompiledPaths(Collections.singletonList(filePath), "Artifacts builder", "Extracting archive:");
        }
        this.processEntries(new EntryProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(@Nullable InputStream inputStream, @NotNull String relativePath, ZipEntry entry) throws IOException {
                String fullOutputPath = JpsArtifactPathUtil.appendToPath(outputPath, relativePath);
                File outputFile = new File(fullOutputPath);
                FileUtil.createParentDirs((File)outputFile);
                if (inputStream == null) {
                    outputFile.mkdir();
                } else {
                    if (outSrcMapping.getState(fullOutputPath) == null) {
                        BufferedInputStream from = new BufferedInputStream(inputStream);
                        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(outputFile));
                        try {
                            FileUtil.copy((InputStream)from, (OutputStream)to);
                        }
                        finally {
                            from.close();
                            to.close();
                        }
                        outputConsumer.registerOutputFile(outputFile, Collections.singletonList(filePath));
                    }
                    outSrcMapping.appendData(fullOutputPath, rootIndex, filePath);
                }
            }
        });
    }

    public static interface EntryProcessor {
        public void process(@Nullable InputStream var1, @NotNull String var2, ZipEntry var3) throws IOException;
    }
}

