/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;

public final class FilteredResourceRootDescriptor
extends ResourceRootDescriptor {
    public FilteredResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        super(root, target, packagePrefix, excludes);
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsProject project = this.getTarget().getModule().getProject();
        final JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        final JpsCompilerExcludes excludes = configuration.getCompilerExcludes();
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !excludes.isExcluded(file) && configuration.isResourceFile(file, FilteredResourceRootDescriptor.this.getRootFile());
            }
        };
    }
}

