/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.ArtifactContainer;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifact;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.managed.BuildType;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.managed.NativeSourceFolder;
import com.android.build.gradle.managed.NativeToolchain;
import com.android.build.gradle.managed.NdkAbiOptions;
import com.android.build.gradle.managed.NdkConfig;
import com.android.build.gradle.managed.ProductFlavor;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.AndroidComponentModelPlugin;
import com.android.build.gradle.model.AndroidComponentSpec;
import com.android.build.gradle.model.NativeComponentModelBuilder;
import com.android.build.gradle.model.NativeSourceSet;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.model.internal.DefaultNativeSourceSet;
import com.android.build.gradle.ndk.internal.NdkConfiguration;
import com.android.build.gradle.ndk.internal.NdkExtensionConvention;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import com.android.build.gradle.ndk.internal.StlNativeToolSpecification;
import com.android.build.gradle.ndk.internal.ToolchainConfiguration;
import com.android.builder.core.VariantConfiguration;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.c.plugins.CPlugin;
import org.gradle.language.cpp.plugins.CppPlugin;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.nativeplatform.BuildTypeContainer;
import org.gradle.nativeplatform.FlavorContainer;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryBinarySpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class NdkComponentModelPlugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final ModelRegistry modelRegistry;

    @Inject
    private NdkComponentModelPlugin(ToolingModelBuilderRegistry toolingRegistry, ModelRegistry modelRegistry) {
        this.toolingRegistry = toolingRegistry;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(AndroidComponentModelPlugin.class);
        project.getPluginManager().apply(CPlugin.class);
        project.getPluginManager().apply(CppPlugin.class);
        this.toolingRegistry.register((ToolingModelBuilder)new NativeComponentModelBuilder(this.modelRegistry));
    }

    public static void configureScopeForNdk(VariantScope scope) {
        GradleVariantConfiguration config = scope.getVariantConfiguration();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Abi abi : NdkHandler.getAbiList()) {
            scope.addNdkDebuggableLibraryFolders(abi, new File(scope.getGlobalScope().getBuildDir(), NdkNamingScheme.getDebugLibraryDirectoryName(config.getBuildType().getName(), config.getFlavorName(), abi.getName())));
            builder.add((Object)new File(scope.getGlobalScope().getBuildDir(), NdkNamingScheme.getOutputDirectoryName(config.getBuildType().getName(), config.getFlavorName(), abi.getName())).getParentFile());
        }
        scope.setNdkSoFolder((Collection)builder.build());
    }

    private static Collection<NativeLibraryBinarySpec> getNativeBinaries(NativeLibrarySpec library, final BuildType buildType, final List<ProductFlavor> productFlavors) {
        final ProductFlavorCombo flavorGroup = new ProductFlavorCombo(productFlavors);
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)library.getBinaries().withType(NativeLibraryBinarySpec.class).values(), (Predicate)new Predicate<NativeLibraryBinarySpec>(){

            public boolean apply(NativeLibraryBinarySpec binary) {
                return binary.getBuildType().getName().equals(buildType.getName()) && (binary.getFlavor().getName().equals(flavorGroup.getName()) || productFlavors.isEmpty() && binary.getFlavor().getName().equals("default"));
            }
        }));
    }

    public Collection<? extends BuildableComponentSpec> getBinaries(VariantConfiguration variantConfig) {
        if (variantConfig.getType().isForTesting()) {
            return Collections.emptyList();
        }
        ModelMap binaries = (ModelMap)this.modelRegistry.realize(new ModelPath("binaries"), ModelTypes.modelMap((ModelType)ModelType.of(BinarySpec.class)));
        ArrayList matches = Lists.newArrayList();
        for (BinarySpec binary : binaries.values()) {
            if (!(binary instanceof AndroidBinary) || !binary.getName().equals(variantConfig.getFullName())) continue;
            matches.add((AndroidBinary)binary);
        }
        return matches;
    }

    public static class Rules
    extends RuleSource {
        private static final Predicate<File> SHARED_OBJECT_FILTER = new Predicate<File>(){

            public boolean apply(File file) {
                return file.getName().endsWith(".so");
            }
        };

        @ComponentType
        public static void registerNativeSourceSet(TypeBuilder<NativeSourceSet> builder) {
            builder.defaultImplementation(DefaultNativeSourceSet.class);
        }

        @Defaults
        public static void initializeNdkConfig(@Path(value="android.ndk") NdkConfig ndk) {
            ndk.setModuleName("");
            ndk.setToolchain("");
            ndk.setToolchainVersion("");
            ndk.setStl("");
            ndk.setRenderscriptNdkMode(false);
        }

        @Finalize
        public static void setDefaultNdkExtensionValue(@Path(value="android.ndk") NdkConfig ndkConfig) {
            NdkExtensionConvention.setExtensionDefault(ndkConfig);
        }

        @Validate
        public static void checkNdkDir(NdkHandler ndkHandler, @Path(value="android.ndk") NdkConfig ndkConfig) {
            if (!ndkConfig.getModuleName().isEmpty() && !ndkHandler.isNdkDirConfigured()) {
                throw new InvalidUserDataException("NDK location not found. Define location with ndk.dir in the local.properties file or with an ANDROID_NDK_HOME environment variable.");
            }
            if (ndkHandler.isNdkDirConfigured() && !ndkHandler.getNdkDirectory().exists()) {
                throw new InvalidUserDataException("Specified NDK location does not exists.  Please ensure ndk.dir in local.properties file or ANDROID_NDK_HOME is configured correctly.");
            }
        }

        @Defaults
        public static void addDefaultNativeSourceSet(@Path(value="android.sources") ModelMap<FunctionalSourceSet> sources) {
            sources.beforeEach((Action)new Action<FunctionalSourceSet>(){

                public void execute(final FunctionalSourceSet sourceSet) {
                    sourceSet.create("jni", NativeSourceSet.class, (Action)new Action<NativeSourceSet>(){

                        public void execute(NativeSourceSet nativeSourceSet) {
                            nativeSourceSet.getSource().srcDir((Object)("src/" + sourceSet.getName() + "/" + "jni"));
                            nativeSourceSet.getExportedHeaders().srcDir((Object)("src/" + sourceSet.getName() + "/" + "headers"));
                            nativeSourceSet.getSource().srcDir((Object)("src/" + nativeSourceSet.getParentName() + "/" + "jni"));
                        }
                    });
                }
            });
        }

        @Model(value="ndkHandler")
        public static NdkHandler ndkHandler(ProjectIdentifier projectId, @Path(value="android.compileSdkVersion") String compileSdkVersion, @Path(value="android.ndk") NdkConfig ndkConfig) {
            while (projectId.getParentIdentifier() != null) {
                projectId = projectId.getParentIdentifier();
            }
            return new NdkHandler(projectId.getProjectDir(), (String)Objects.firstNonNull((Object)ndkConfig.getPlatformVersion(), (Object)compileSdkVersion), ndkConfig.getToolchain(), ndkConfig.getToolchainVersion());
        }

        @Defaults
        public static void initBuildTypeNdk(@Path(value="android.buildTypes") ModelMap<BuildType> buildTypes) {
            buildTypes.named("debug", (Action)new Action<BuildType>(){

                public void execute(BuildType buildType) {
                    if (buildType.getNdk().getDebuggable() == null) {
                        buildType.getNdk().setDebuggable(true);
                    }
                }
            });
        }

        @Mutate
        public static void createAndroidPlatforms(PlatformContainer platforms, NdkHandler ndkHandler) {
            if (!ndkHandler.isNdkDirConfigured()) {
                return;
            }
            ToolchainConfiguration.configurePlatforms(platforms, ndkHandler);
        }

        @Validate
        public static void validateAbi(@Path(value="android.abis") ModelMap<NdkAbiOptions> abiConfigs) {
            for (NdkAbiOptions abiOptions : abiConfigs.values()) {
                if (Abi.getByName((String)abiOptions.getName()) != null) continue;
                throw new InvalidUserDataException("Target ABI '" + abiOptions.getName() + "' is not supported.");
            }
        }

        @Mutate
        public static void createToolchains(NativeToolChainRegistry toolchainRegistry, @Path(value="android.abis") ModelMap<NdkAbiOptions> abis, @Path(value="android.ndk") NdkConfig ndkConfig, NdkHandler ndkHandler) {
            if (!ndkHandler.isNdkDirConfigured()) {
                return;
            }
            ToolchainConfiguration.configureToolchain(toolchainRegistry, ndkConfig.getToolchain(), abis, ndkHandler);
        }

        @Mutate
        public static void createNativeBuildTypes(BuildTypeContainer nativeBuildTypes, @Path(value="android.buildTypes") ModelMap<BuildType> androidBuildTypes) {
            for (BuildType buildType : androidBuildTypes.values()) {
                nativeBuildTypes.maybeCreate(buildType.getName());
            }
        }

        @Mutate
        public static void createNativeFlavors(FlavorContainer nativeFlavors, List<ProductFlavorCombo<ProductFlavor>> androidFlavorGroups) {
            if (androidFlavorGroups.isEmpty()) {
                nativeFlavors.maybeCreate("");
            } else {
                for (ProductFlavorCombo<ProductFlavor> group : androidFlavorGroups) {
                    nativeFlavors.maybeCreate(group.getName());
                }
            }
        }

        @Mutate
        public static void createNativeLibrary(ModelMap<NativeLibrarySpec> nativeComponents, final @Path(value="android.ndk") NdkConfig ndkConfig, final NdkHandler ndkHandler, final @Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, final @Path(value="buildDir") File buildDir, final ServiceRegistry serviceRegistry) {
            if (!ndkHandler.isNdkDirConfigured()) {
                return;
            }
            if (!ndkConfig.getModuleName().isEmpty()) {
                nativeComponents.create(ndkConfig.getModuleName(), (Action)new Action<NativeLibrarySpec>(){

                    public void execute(NativeLibrarySpec nativeLib) {
                        NdkConfiguration.configureProperties(nativeLib, (ModelMap<FunctionalSourceSet>)sources, buildDir, ndkHandler, serviceRegistry);
                        nativeLib.getBinaries().all((Action)new Action<BinarySpec>(){

                            public void execute(BinarySpec binarySpec) {
                                NdkConfiguration.configureNativeBinaryOutputFile((NativeLibraryBinarySpec)binarySpec, buildDir, ndkConfig.getModuleName());
                            }
                        });
                    }
                });
            }
        }

        @Model(value="nativeDependencies")
        public static Multimap<String, NativeDependencyResolveResult> resolveNativeDependencies(@Path(value="binaries") ModelMap<NativeBinarySpec> nativeBinaries, @Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, ServiceRegistry serviceRegistry) {
            ArrayListMultimap dependencies = ArrayListMultimap.create();
            for (NativeBinarySpec nativeBinary : nativeBinaries.values()) {
                Collection<NativeSourceSet> jniSources = NdkConfiguration.findNativeSourceSets(nativeBinary, sources).values();
                for (NativeSourceSet jniSource : jniSources) {
                    dependencies.put((Object)nativeBinary.getName(), (Object)NdkConfiguration.resolveDependency(serviceRegistry, nativeBinary, jniSource));
                }
            }
            return dependencies;
        }

        @Mutate
        public static void createAdditionalTasksForNatives(ModelMap<Task> tasks, ModelMap<AndroidComponentSpec> specs, @Path(value="android.ndk") NdkConfig ndkConfig, @Path(value="nativeDependencies") Multimap<String, NativeDependencyResolveResult> dependencies, NdkHandler ndkHandler, @Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries, @Path(value="buildDir") File buildDir) {
            if (!ndkHandler.isNdkDirConfigured()) {
                return;
            }
            for (AndroidBinaryInternal binary : binaries.values()) {
                for (NativeLibraryBinarySpec nativeBinary : binary.getNativeBinaries()) {
                    NdkConfiguration.createTasks(tasks, (NativeBinarySpec)nativeBinary, buildDir, binary.getMergedNdkConfig(), ndkHandler, dependencies);
                }
            }
        }

        @Mutate
        public static void configureNativeBinary(BinaryContainer binaries, ModelMap<NativeLibrarySpec> specs, final @Path(value="android.ndk") NdkConfig ndkConfig, final NdkHandler ndkHandler) {
            final NativeLibrarySpec library = (NativeLibrarySpec)specs.get(ndkConfig.getModuleName());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Abi abi : NdkHandler.getAbiList()) {
                builder.add((Object)abi.getName());
            }
            final ImmutableSet supportedAbis = builder.build();
            binaries.withType(AndroidBinaryInternal.class, (Action)new Action<AndroidBinaryInternal>(){

                public void execute(AndroidBinaryInternal binary) {
                    binary.computeMergedNdk(ndkConfig, binary.getProductFlavors(), binary.getBuildType());
                    if (binary.getMergedNdkConfig().getAbiFilters().isEmpty()) {
                        binary.getMergedNdkConfig().getAbiFilters().addAll((Collection<String>)supportedAbis);
                    }
                    if (library != null) {
                        Collection nativeBinaries = NdkComponentModelPlugin.getNativeBinaries(library, binary.getBuildType(), binary.getProductFlavors());
                        for (NativeLibraryBinarySpec nativeBin : nativeBinaries) {
                            if (!binary.getMergedNdkConfig().getAbiFilters().contains(nativeBin.getTargetPlatform().getName())) continue;
                            NdkConfiguration.configureBinary(nativeBin, binary.getMergedNdkConfig(), ndkHandler);
                            binary.getNativeBinaries().add(nativeBin);
                        }
                    }
                }
            });
        }

        @Model(value="nativeBuildConfig")
        public static void createNativeBuildModel(NativeBuildConfig config, @Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries, final NdkHandler ndkHandler) {
            if (!ndkHandler.isNdkDirConfigured()) {
                return;
            }
            config.getCFileExtensions().addAll(NdkConfiguration.C_FILE_EXTENSIONS);
            config.getCppFileExtensions().addAll(NdkConfiguration.CPP_FILE_EXTENSIONS);
            for (AndroidBinaryInternal binary : binaries.values()) {
                for (NativeLibraryBinarySpec nativeBinary : binary.getNativeBinaries()) {
                    if (!(nativeBinary instanceof SharedLibraryBinarySpec)) continue;
                    String abi = nativeBinary.getTargetPlatform().getName();
                    config.getLibraries().create(binary.getName() + '-' + abi, (Action)new CreateNativeLibraryAction(binary, (SharedLibraryBinarySpec)nativeBinary));
                }
            }
            for (final Abi abi : ndkHandler.getSupportedAbis()) {
                config.getToolchains().create("ndk-" + abi.getName(), (Action)new Action<NativeToolchain>(){

                    public void execute(NativeToolchain nativeToolchain) {
                        nativeToolchain.setCCompilerExecutable(ndkHandler.getCCompiler(abi));
                        nativeToolchain.setCppCompilerExecutable(ndkHandler.getCppCompiler(abi));
                    }
                });
            }
        }

        @Finalize
        public static void attachNativeTasksToAndroidBinary(@Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries) {
            binaries.afterEach((Action)new Action<AndroidBinaryInternal>(){

                public void execute(AndroidBinaryInternal binary) {
                    for (NativeLibraryBinarySpec nativeBinary : binary.getNativeBinaries()) {
                        if (!binary.getTargetAbi().isEmpty() && !binary.getTargetAbi().contains(nativeBinary.getTargetPlatform().getName())) continue;
                        binary.getBuildTask().dependsOn(new Object[]{NdkNamingScheme.getNdkBuildTaskName((NativeBinarySpec)nativeBinary)});
                    }
                }
            });
        }

        @Model(value="artifacts")
        public static void createNativeLibraryArtifacts(ArtifactContainer artifactContainer, @Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries, @Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, ModelMap<Task> tasks, @Path(value="nativeDependencies") Multimap<String, NativeDependencyResolveResult> dependencies, NdkHandler ndkHandler, ProjectIdentifier project) {
            if (!ndkHandler.isNdkDirConfigured()) {
                return;
            }
            for (AndroidBinaryInternal binary : binaries.values()) {
                for (NativeLibraryBinarySpec nativeBinary : binary.getNativeBinaries()) {
                    String linkage = nativeBinary instanceof SharedLibraryBinarySpec ? "shared" : "static";
                    String name = Joiner.on((char)'-').join((Object)binary.getName(), (Object)nativeBinary.getTargetPlatform().getName(), new Object[]{linkage});
                    artifactContainer.getNativeArtifacts().create(name, (Action)new CreateNativeLibraryArtifactAction(binary, nativeBinary, dependencies.get((Object)nativeBinary.getName()), ndkHandler, project));
                }
            }
        }

        @Mutate
        public static void hideNativeTasks(TaskContainer tasks, @Path(value="binaries") ModelMap<NativeLibraryBinarySpec> binaries) {
            Task nonExecutableTask = tasks.create("nonExecutableTask");
            nonExecutableTask.dependsOn(new Object[]{nonExecutableTask});
            nonExecutableTask.setDescription("Dummy task to hide other unwanted tasks in the task list.");
            for (NativeLibraryBinarySpec binary : binaries.values()) {
                Task buildTask = binary.getBuildTask();
                nonExecutableTask.dependsOn(new Object[]{buildTask});
                buildTask.setGroup(null);
            }
        }

        private static class CreateNativeLibraryArtifactAction
        implements Action<NativeLibraryArtifact> {
            private final AndroidBinaryInternal binary;
            private final NativeLibraryBinarySpec nativeBinary;
            private final Collection<NativeDependencyResolveResult> dependencies;
            private final NdkHandler ndkHandler;
            private final ProjectIdentifier projectId;

            public CreateNativeLibraryArtifactAction(AndroidBinaryInternal binary, NativeLibraryBinarySpec nativeBinary, Collection<NativeDependencyResolveResult> dependencies, NdkHandler ndkHandler, ProjectIdentifier projectId) {
                this.binary = binary;
                this.nativeBinary = nativeBinary;
                this.dependencies = dependencies;
                this.ndkHandler = ndkHandler;
                this.projectId = projectId;
            }

            public void execute(NativeLibraryArtifact artifact) {
                NativePlatform abi;
                NativeDependencyLinkage linkage = this.nativeBinary instanceof SharedLibraryBinarySpec ? NativeDependencyLinkage.SHARED : NativeDependencyLinkage.STATIC;
                File output = this.nativeBinary instanceof SharedLibraryBinarySpec ? ((SharedLibraryBinarySpec)this.nativeBinary).getSharedLibraryFile() : ((StaticLibraryBinarySpec)this.nativeBinary).getStaticLibraryFile();
                artifact.getLibraries().add(output);
                artifact.setBuildType(this.binary.getBuildType().getName());
                for (ProductFlavor flavor : this.binary.getProductFlavors()) {
                    artifact.getProductFlavors().add(flavor.getName());
                }
                artifact.setVariantName(this.binary.getName());
                artifact.setAbi(this.nativeBinary.getTargetPlatform().getName());
                artifact.setLinkage(linkage);
                ArrayList builtBy = Lists.newArrayList();
                builtBy.add(this.nativeBinary);
                builtBy.add(this.projectId.getPath() + ":" + NdkNamingScheme.getNdkBuildTaskName((NativeBinarySpec)this.nativeBinary));
                artifact.setBuiltBy(builtBy);
                for (LanguageSourceSet sourceSet : this.nativeBinary.getSources()) {
                    if (!(sourceSet instanceof HeaderExportingSourceSet)) continue;
                    HeaderExportingSourceSet source = (HeaderExportingSourceSet)sourceSet;
                    artifact.getExportedHeaderDirectories().addAll(source.getExportedHeaders().getSrcDirs());
                }
                String stl = this.binary.getMergedNdkConfig().getStl();
                if (stl.endsWith("_shared")) {
                    abi = this.nativeBinary.getTargetPlatform();
                    StlNativeToolSpecification stlConfig = new StlNativeToolSpecification(this.ndkHandler, stl, this.binary.getMergedNdkConfig().getStlVersion(), abi);
                    artifact.getLibraries().addAll(stlConfig.getStlLib(abi.getName()));
                }
                abi = Abi.getByName((String)this.nativeBinary.getTargetPlatform().getName());
                assert (abi != null);
                for (NativeDependencyResolveResult dependency : this.dependencies) {
                    for (NativeLibraryBinary lib : dependency.getPrebuiltLibraries()) {
                        if (!(lib instanceof SharedLibraryBinary) || !abi.getName().equals(lib.getTargetPlatform().getName())) continue;
                        artifact.getLibraries().add(((SharedLibraryBinary)lib).getSharedLibraryFile());
                    }
                    Collection<NativeLibraryArtifact> artifacts = dependency.getNativeArtifacts();
                    for (NativeLibraryArtifact dep : artifacts) {
                        if (!abi.getName().equals(dep.getAbi())) continue;
                        Iterables.addAll(artifact.getLibraries(), (Iterable)Iterables.filter(dep.getLibraries(), (Predicate)SHARED_OBJECT_FILTER));
                    }
                }
            }
        }

        private static class CreateNativeLibraryAction
        implements Action<NativeLibrary> {
            private final AndroidBinaryInternal binary;
            private final SharedLibraryBinarySpec nativeBinary;

            public CreateNativeLibraryAction(AndroidBinaryInternal binary, SharedLibraryBinarySpec nativeBinary) {
                this.binary = binary;
                this.nativeBinary = nativeBinary;
            }

            public void execute(NativeLibrary nativeLibrary) {
                String abi = this.nativeBinary.getTargetPlatform().getName();
                nativeLibrary.setOutput(this.nativeBinary.getSharedLibraryFile());
                HashSet srcFolders = Sets.newHashSet();
                nativeLibrary.setGroupName(this.binary.getName());
                final List cFlags = this.nativeBinary.getcCompiler().getArgs();
                final List cppFlags = this.nativeBinary.getCppCompiler().getArgs();
                for (LanguageSourceSet sourceSet : this.nativeBinary.getSources()) {
                    srcFolders.addAll(sourceSet.getSource().getSrcDirs());
                    if (!(sourceSet instanceof HeaderExportingSourceSet)) continue;
                    Set headerDirs = ((HeaderExportingSourceSet)sourceSet).getExportedHeaders().getSrcDirs();
                    for (File headerDir : headerDirs) {
                        if (!headerDir.isDirectory() || nativeLibrary.getExportedHeaders().contains(headerDir)) continue;
                        nativeLibrary.getExportedHeaders().add(headerDir);
                        cFlags.add("-I" + headerDir);
                        cppFlags.add("-I" + headerDir);
                    }
                }
                for (NativeDependencySet dependency : this.nativeBinary.getLibs()) {
                    for (File includeDir : dependency.getIncludeRoots()) {
                        cFlags.add("-I" + includeDir);
                        cppFlags.add("-I" + includeDir);
                    }
                }
                for (final File srcFolder : srcFolders) {
                    nativeLibrary.getFolders().create((Action)new Action<NativeSourceFolder>(){

                        public void execute(NativeSourceFolder nativeSourceFolder) {
                            nativeSourceFolder.setSrc(srcFolder);
                            nativeSourceFolder.getCFlags().addAll(cFlags);
                            nativeSourceFolder.getCppFlags().addAll(cppFlags);
                        }
                    });
                }
                nativeLibrary.setToolchain("ndk-" + abi);
            }
        }
    }
}

