/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifact;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.model.NativeLibraryImpl;
import com.android.build.gradle.internal.ndk.NativeCompilerArgsUtil;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.managed.NdkAbiOptions;
import com.android.build.gradle.managed.NdkConfig;
import com.android.build.gradle.managed.NdkOptions;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.builder.model.NativeLibrary;
import com.android.utils.StringHelper;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryBinarySpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.StaticLibraryBinary;

public class ComponentNativeLibraryFactory
implements NativeLibraryFactory {
    ModelMap<AndroidBinaryInternal> binaries;
    NdkHandler ndkHandler;
    ModelMap<NdkAbiOptions> abiOptions;
    Multimap<String, NativeDependencyResolveResult> nativeDependencies;
    Multimap<String, NativeDependencyResolveResult> jniLibsDependencies;

    public ComponentNativeLibraryFactory(ModelMap<AndroidBinaryInternal> binaries, NdkHandler ndkHandler, ModelMap<NdkAbiOptions> abiOptions, Multimap<String, NativeDependencyResolveResult> nativeDependencies, Multimap<String, NativeDependencyResolveResult> jniLibsDependencies) {
        this.binaries = binaries;
        this.ndkHandler = ndkHandler;
        this.abiOptions = abiOptions;
        this.nativeDependencies = nativeDependencies;
        this.jniLibsDependencies = jniLibsDependencies;
    }

    public Optional<NativeLibrary> create(VariantScope scope, String toolchainName, final Abi abi) {
        BaseVariantData variantData = scope.getVariantData();
        AndroidBinaryInternal androidBinary = (AndroidBinaryInternal)this.binaries.get("android" + StringHelper.capitalize((String)variantData.getName()));
        if (androidBinary == null) {
            return Optional.absent();
        }
        Optional nativeBinary = Iterables.tryFind(androidBinary.getNativeBinaries(), (Predicate)new Predicate<NativeLibraryBinarySpec>(){

            public boolean apply(NativeLibraryBinarySpec binary) {
                return binary.getTargetPlatform().getName().equals(abi.getName());
            }
        });
        if (!nativeBinary.isPresent()) {
            return Optional.of((Object)new NativeLibraryImpl(abi.getName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.findDebuggableLibraryDirectories((BaseVariantData<? extends BaseVariantOutputData>)variantData, androidBinary, abi)));
        }
        NdkOptions targetOptions = (NdkOptions)this.abiOptions.get(abi.getName());
        Iterable cFlags = ((NativeLibraryBinarySpec)nativeBinary.get()).getcCompiler().getArgs();
        Iterable cppFlags = ((NativeLibraryBinarySpec)nativeBinary.get()).getCppCompiler().getArgs();
        if (targetOptions != null) {
            if (!targetOptions.getCFlags().isEmpty()) {
                cFlags = Iterables.concat((Iterable)cFlags, targetOptions.getCFlags());
            }
            if (!targetOptions.getCppFlags().isEmpty()) {
                cppFlags = Iterables.concat((Iterable)cppFlags, targetOptions.getCppFlags());
            }
        }
        List<File> debuggableLibDir = this.findDebuggableLibraryDirectories((BaseVariantData<? extends BaseVariantOutputData>)variantData, androidBinary, abi);
        NdkConfig ndkConfig = androidBinary.getMergedNdkConfig();
        return Optional.of((Object)new NativeLibraryImpl(ndkConfig.getModuleName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.ndkHandler.getStlIncludes(ndkConfig.getStl(), ndkConfig.getStlVersion(), abi), Collections.emptyList(), Collections.emptyList(), NativeCompilerArgsUtil.transform((Iterable)cFlags), NativeCompilerArgsUtil.transform((Iterable)cppFlags), debuggableLibDir));
    }

    private List<File> findDebuggableLibraryDirectories(BaseVariantData<? extends BaseVariantOutputData> variantData, AndroidBinaryInternal binary, Abi abi) {
        LinkedHashSet debuggableLibDir = Sets.newLinkedHashSet();
        debuggableLibDir.add(variantData.getScope().getNdkDebuggableLibraryFolders(abi));
        ComponentNativeLibraryFactory.addNativeDebuggableLib(debuggableLibDir, binary, abi, this.nativeDependencies);
        ComponentNativeLibraryFactory.addJniLibsDebuggableLib(debuggableLibDir, binary, abi, this.jniLibsDependencies);
        return ImmutableList.copyOf((Collection)debuggableLibDir);
    }

    private static void addNativeDebuggableLib(Collection<File> debuggableLibDir, AndroidBinaryInternal binary, final Abi abi, Multimap<String, NativeDependencyResolveResult> dependencyMap) {
        NativeLibraryBinarySpec nativeBinary = (NativeLibraryBinarySpec)Iterables.find(binary.getNativeBinaries(), (Predicate)new Predicate<NativeLibraryBinarySpec>(){

            public boolean apply(NativeLibraryBinarySpec nativeBinary) {
                return nativeBinary.getTargetPlatform().getName().equals(abi.getName());
            }
        }, null);
        if (nativeBinary != null) {
            ComponentNativeLibraryFactory.addDebuggableLib(debuggableLibDir, binary, abi, dependencyMap.get((Object)nativeBinary.getName()));
        }
    }

    private static void addJniLibsDebuggableLib(Collection<File> debuggableLibDir, AndroidBinary binary, Abi abi, Multimap<String, NativeDependencyResolveResult> dependencyMap) {
        ComponentNativeLibraryFactory.addDebuggableLib(debuggableLibDir, binary, abi, dependencyMap.get((Object)binary.getName()));
    }

    private static void addDebuggableLib(Collection<File> debuggableLibDir, AndroidBinary binary, Abi abi, Iterable<NativeDependencyResolveResult> dependencies) {
        for (NativeDependencyResolveResult dependency : dependencies) {
            for (NativeLibraryArtifact artifact : dependency.getNativeArtifacts()) {
                for (File lib : artifact.getLibraries()) {
                    debuggableLibDir.add(lib.getParentFile());
                }
            }
            for (NativeLibraryBinary nativeBinary : dependency.getPrebuiltLibraries()) {
                File output;
                if (!nativeBinary.getTargetPlatform().getName().equals(abi.getName()) || (output = nativeBinary instanceof SharedLibraryBinary ? ((SharedLibraryBinary)nativeBinary).getSharedLibraryFile() : ((StaticLibraryBinary)nativeBinary).getStaticLibraryFile()) == null) continue;
                debuggableLibDir.add(output.getParentFile());
            }
        }
    }
}

