/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.model.TaskModelMapAdaptor;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.model.internal.AndroidComponentSpecInternal;
import com.android.builder.core.VariantType;
import com.google.common.base.Preconditions;
import org.gradle.api.Task;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;

public class AndroidComponentModelTestPlugin
extends RuleSource {
    @Mutate
    public void createConnectedTestTasks(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries, TaskManager taskManager, ModelMap<AndroidComponentSpecInternal> specs) {
        VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
        for (AndroidBinaryInternal binary : binaries.values()) {
            BaseVariantData testedVariantData = binary.getVariantData();
            TestVariantData unitTestVariantData = variantManager.createTestVariantData(testedVariantData, VariantType.UNIT_TEST);
            variantManager.getVariantDataList().add(unitTestVariantData);
            variantManager.createTasksForVariantData((TaskFactory)new TaskModelMapAdaptor(tasks), (BaseVariantData)unitTestVariantData);
            if (!binary.getBuildType().getName().equals("debug")) continue;
            Preconditions.checkState((testedVariantData != null ? 1 : 0) != 0, (Object)"Internal error: tested variant must be created before test variant.");
            TestVariantData testVariantData = variantManager.createTestVariantData(testedVariantData, VariantType.ANDROID_TEST);
            variantManager.getVariantDataList().add(testVariantData);
            variantManager.createTasksForVariantData((TaskFactory)new TaskModelMapAdaptor(tasks), (BaseVariantData)testVariantData);
        }
    }
}

