/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.SharedObjectFile;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dependency.AndroidNativeDependencySpec;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeDependencyResolver;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifact;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.JniLibsSourceSet;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.tasks.StripDependenciesTask;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.platform.base.BinarySpec;

public class JniLibsLanguageTransform
implements LanguageTransform<JniLibsSourceSet, SharedObjectFile> {
    private NdkHandler ndkHandler;

    public JniLibsLanguageTransform(NdkHandler ndkHandler) {
        this.ndkHandler = ndkHandler;
    }

    public String getLanguageName() {
        return "jniLibs";
    }

    public Class<JniLibsSourceSet> getSourceSetType() {
        return JniLibsSourceSet.class;
    }

    public Class<SharedObjectFile> getOutputType() {
        return SharedObjectFile.class;
    }

    public Map<String, Class<?>> getBinaryTools() {
        return ImmutableMap.of();
    }

    public SourceTransformTaskConfig getTransformTask() {
        return new TransformConfig();
    }

    public boolean applyToBinary(BinarySpec binary) {
        return binary instanceof AndroidBinary;
    }

    private class TransformConfig
    implements SourceTransformTaskConfig {
        private TransformConfig() {
        }

        public String getTaskPrefix() {
            return "process";
        }

        public Class<? extends DefaultTask> getTaskType() {
            return StripDependenciesTask.class;
        }

        public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet languageSourceSet, ServiceRegistry serviceRegistry) {
            AndroidBinaryInternal binary = (AndroidBinaryInternal)binarySpec;
            String binaryBuildType = binary.getBuildType().getName();
            String binaryProductFlavor = ProductFlavorCombo.getFlavorComboName(binary.getProductFlavors());
            JniLibsSourceSet sourceSet = (JniLibsSourceSet)languageSourceSet;
            for (AndroidNativeDependencySpec dependencySpec : sourceSet.getDependencies().getDependencies()) {
                dependencySpec.validate();
                if (dependencySpec.getLinkage() == null) continue;
                throw new InvalidUserDataException("Cannot specify linkage for native dependency for jniLibs.");
            }
            NativeDependencyResolveResult dependencies = new NativeDependencyResolver(serviceRegistry, sourceSet.getDependencies(), new AndroidNativeDependencySpec(null, null, binaryBuildType, binaryProductFlavor, NativeDependencyLinkage.SHARED)).resolve();
            HashMap inputFiles = Maps.newHashMap();
            StripDependenciesTask stripTask = (StripDependenciesTask)task;
            for (NativeLibraryArtifact artifacts : dependencies.getNativeArtifacts()) {
                String abi = artifacts.getAbi();
                assert (abi != null);
                if (!binary.getMergedNdkConfig().getAbiFilters().contains(abi)) continue;
                stripTask.dependsOn(new Object[]{artifacts.getBuiltBy()});
                for (File output : artifacts.getLibraries()) {
                    if (!output.getName().endsWith(".so")) continue;
                    inputFiles.put(output, Abi.getByName((String)abi));
                }
            }
            ArrayListMultimap stripedFiles = ArrayListMultimap.create();
            for (NativeLibraryBinary nativeBinary : dependencies.getPrebuiltLibraries()) {
                if (!(nativeBinary instanceof SharedLibraryBinary)) continue;
                File output = ((SharedLibraryBinary)nativeBinary).getSharedLibraryFile();
                Abi abi = Abi.getByName((String)nativeBinary.getTargetPlatform().getName());
                if (output == null || abi == null) continue;
                stripedFiles.put((Object)output, (Object)abi);
            }
            new StripDependenciesTask.ConfigAction(binary.getBuildType().getName(), ProductFlavorCombo.getFlavorComboName(binary.getProductFlavors()), inputFiles, (Multimap<File, Abi>)stripedFiles, task.getProject().getBuildDir(), JniLibsLanguageTransform.this.ndkHandler).execute(stripTask);
            binarySpec.builtBy(new Object[]{task});
        }
    }
}

