/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SSHConfig {
    final List<HostEntry> myEntries = new ArrayList<HostEntry>();
    @NonNls
    public static final String USER_HOME;
    @NonNls
    private static final HashSet<String> ALLOWED_METHODS;

    @NotNull
    public Host lookup(@Nullable String user, @NotNull String host, @Nullable Integer port) {
        Host rc = new Host();
        block0: for (HostEntry e : this.myEntries) {
            for (Pattern p : e.myNegative) {
                if (!p.matcher(host).matches()) continue;
                continue block0;
            }
            if (e.myExactPositive.contains(host)) {
                Host.merge(e.myHost, rc, rc);
                continue;
            }
            for (Pattern p : e.myPositive) {
                if (!p.matcher(host).matches()) continue;
                Host.merge(rc, e.myHost, rc);
            }
        }
        if (user != null) {
            rc.myUser = user;
        }
        if (port != null) {
            rc.myPort = port;
        }
        if (rc.myHostName == null) {
            rc.myHostName = host;
        }
        rc.setDefaults();
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static SSHConfig load() throws IOException {
        SSHConfig rc = new SSHConfig();
        File configFile = new File(USER_HOME + File.separatorChar + ".ssh", "config");
        if (!configFile.exists()) {
            return rc;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "ISO-8859-1"));){
            String line;
            Host host = null;
            while ((line = in.readLine()) != null) {
                HostEntry entry;
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] parts = line.split("[ \t]*[= \t]", 2);
                String keyword = parts[0];
                String argument = SSHConfig.unquoteIfNeeded(parts[1]);
                if ("Host".equalsIgnoreCase(keyword)) {
                    entry = new HostEntry(argument);
                    rc.myEntries.add(entry);
                    host = entry.myHost;
                    continue;
                }
                if (host == null) {
                    entry = new HostEntry("*");
                    rc.myEntries.add(entry);
                    host = entry.myHost;
                }
                if ("BatchMode".equalsIgnoreCase(keyword)) {
                    host.myBatchMode = SSHConfig.parseBoolean(argument);
                    continue;
                }
                if ("HostKeyAlgorithms".equalsIgnoreCase(keyword)) {
                    host.myHostKeyAlgorithms = Collections.unmodifiableList(SSHConfig.parseList(argument));
                    continue;
                }
                if ("HostKeyAlias".equalsIgnoreCase(keyword)) {
                    host.myHostKeyAlias = argument;
                    continue;
                }
                if ("HostName".equalsIgnoreCase(keyword)) {
                    host.myHostName = argument;
                    continue;
                }
                if ("IdentityFile".equalsIgnoreCase(keyword)) {
                    host.myIdentityFile = argument;
                    continue;
                }
                if ("NumberOfPasswordPrompts".equalsIgnoreCase(keyword)) {
                    host.myNumberOfPasswordPrompts = SSHConfig.parseInt(argument);
                    continue;
                }
                if ("PasswordAuthentication".equalsIgnoreCase(keyword)) {
                    host.myPasswordAuthentication = SSHConfig.parseBoolean(argument);
                    continue;
                }
                if ("Port".equalsIgnoreCase(keyword)) {
                    host.myPort = SSHConfig.parseInt(argument);
                    continue;
                }
                if ("PreferredAuthentications".equalsIgnoreCase(keyword)) {
                    List<String> list = SSHConfig.parseList(argument);
                    list.retainAll(ALLOWED_METHODS);
                    if (list.isEmpty()) continue;
                    host.myPreferredMethods = Collections.unmodifiableList(list);
                    continue;
                }
                if ("PubkeyAuthentication".equalsIgnoreCase(keyword)) {
                    host.myPubkeyAuthentication = SSHConfig.parseBoolean(argument);
                    continue;
                }
                if (!"User".equalsIgnoreCase(keyword)) continue;
                host.myUser = argument;
            }
        }
        return rc;
    }

    private static Integer parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static File parseFileName(Host host, String value) {
        try {
            StringBuilder rc = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (i == 0 && ch == '~') {
                    rc.append(USER_HOME);
                    continue;
                }
                if (ch == '%' && i + 1 < value.length()) {
                    switch (value.charAt(++i)) {
                        case '%': {
                            rc.append('%');
                            break;
                        }
                        case 'd': {
                            rc.append(USER_HOME);
                            break;
                        }
                        case 'h': {
                            rc.append(host.getHostName());
                            break;
                        }
                        case 'l': {
                            rc.append(InetAddress.getLocalHost().getHostName());
                            break;
                        }
                        case 'r': {
                            rc.append(host.getUser());
                            break;
                        }
                        default: {
                            rc.append('%');
                            rc.append(ch);
                        }
                    }
                }
                rc.append(ch);
            }
            return new File(rc.toString());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static Boolean parseBoolean(String value) {
        return "yes".equals(value);
    }

    private static List<String> parseList(String arg) {
        ArrayList<String> values = new ArrayList<String>();
        for (String a : arg.split("[ \t,]+")) {
            if (a.length() == 0) continue;
            values.add(a);
        }
        return values;
    }

    private static String unquoteIfNeeded(String part) {
        if (part.length() > 1 && part.charAt(0) == '\"' && part.charAt(part.length() - 1) == '\"') {
            part = part.substring(1, part.length() - 1);
        }
        return part.trim();
    }

    static {
        String e = System.getenv("HOME");
        USER_HOME = e != null ? e : System.getProperty("user.home");
        ALLOWED_METHODS = new HashSet();
        ALLOWED_METHODS.add("publickey");
        ALLOWED_METHODS.add("keyboard-interactive");
        ALLOWED_METHODS.add("password");
    }

    public static class Host {
        @Nullable
        private String myUser;
        @Nullable
        private String myHostName;
        @Nullable
        private Integer myPort;
        @Nullable
        private String myIdentityFile;
        @Nullable
        private List<String> myPreferredMethods;
        @Nullable
        private List<String> myHostKeyAlgorithms;
        @Nullable
        private Boolean myBatchMode;
        @Nullable
        private String myHostKeyAlias;
        @Nullable
        private Integer myNumberOfPasswordPrompts;
        @Nullable
        private Boolean myPasswordAuthentication;
        @Nullable
        private Boolean myPubkeyAuthentication;

        @NotNull
        public String getUser() {
            return Host.notNull(this.myUser);
        }

        @NotNull
        public String getHostName() {
            return Host.notNull(this.myHostName);
        }

        public int getPort() {
            return Host.notNull(this.myPort);
        }

        @Nullable
        public File getIdentityFile() {
            if (this.myIdentityFile == null) {
                return null;
            }
            return SSHConfig.parseFileName(this, this.myIdentityFile);
        }

        @NotNull
        public List<String> getPreferredMethods() {
            return Host.notNull(this.myPreferredMethods);
        }

        public boolean isBatchMode() {
            return Host.notNull(this.myBatchMode);
        }

        @NotNull
        public List<String> getHostKeyAlgorithms() {
            return Host.notNull(this.myHostKeyAlgorithms);
        }

        public int getNumberOfPasswordPrompts() {
            return Host.notNull(this.myNumberOfPasswordPrompts);
        }

        @NotNull
        public String getHostKeyAlias() {
            return Host.notNull(this.myHostKeyAlias);
        }

        public boolean supportsPasswordAuthentication() {
            return Host.notNull(this.myPasswordAuthentication);
        }

        public boolean supportsPubkeyAuthentication() {
            return Host.notNull(this.myPubkeyAuthentication);
        }

        private void setDefaults() {
            if (this.myUser == null) {
                this.myUser = System.getProperty("user.name");
            }
            if (this.myPort == null) {
                this.myPort = 22;
            }
            if (this.myPreferredMethods == null) {
                this.myPreferredMethods = Collections.unmodifiableList(Arrays.asList("publickey", "keyboard-interactive", "password"));
            }
            if (this.myBatchMode == null) {
                this.myBatchMode = Boolean.FALSE;
            }
            if (this.myHostKeyAlgorithms == null) {
                this.myHostKeyAlgorithms = Collections.unmodifiableList(Arrays.asList("ssh-rsa", "ssh-dss"));
            }
            if (this.myNumberOfPasswordPrompts == null) {
                this.myNumberOfPasswordPrompts = 3;
            }
            if (this.myHostKeyAlias == null) {
                this.myHostKeyAlias = this.myHostName;
            }
            if (this.myPasswordAuthentication == null) {
                this.myPasswordAuthentication = Boolean.TRUE;
            }
            if (this.myPubkeyAuthentication == null) {
                this.myPubkeyAuthentication = Boolean.TRUE;
            }
        }

        @NotNull
        private static <T> T notNull(@Nullable T value) {
            if (value == null) {
                throw new IllegalStateException("The value must not be null");
            }
            return value;
        }

        private static void merge(Host first, Host second, Host result) {
            result.myUser = Host.mergeValue(first.myUser, second.myUser);
            result.myHostName = Host.mergeValue(first.myHostName, second.myHostName);
            result.myPort = Host.mergeValue(first.myPort, second.myPort);
            result.myIdentityFile = Host.mergeValue(first.myIdentityFile, second.myIdentityFile);
            result.myPreferredMethods = Host.mergeValue(first.myPreferredMethods, second.myPreferredMethods);
            result.myHostKeyAlgorithms = Host.mergeValue(first.myHostKeyAlgorithms, second.myHostKeyAlgorithms);
            result.myBatchMode = Host.mergeValue(first.myBatchMode, second.myBatchMode);
            result.myHostKeyAlias = Host.mergeValue(first.myHostKeyAlias, second.myHostKeyAlias);
            result.myNumberOfPasswordPrompts = Host.mergeValue(first.myNumberOfPasswordPrompts, second.myNumberOfPasswordPrompts);
            result.myPasswordAuthentication = Host.mergeValue(first.myPasswordAuthentication, second.myPasswordAuthentication);
            result.myPubkeyAuthentication = Host.mergeValue(first.myPubkeyAuthentication, second.myPubkeyAuthentication);
        }

        private static <T> T mergeValue(T first, T second) {
            return first == null ? second : first;
        }

        public String toString() {
            return String.format("Host{myUser='%s', myHostName='%s', myPort=%d, myIdentityFile='%s'}", this.myUser, this.myHostName, this.myPort, this.myIdentityFile);
        }
    }

    private static class HostEntry {
        private final List<Pattern> myNegative = new ArrayList<Pattern>();
        private final List<Pattern> myPositive = new ArrayList<Pattern>();
        private final List<String> myExactPositive = new ArrayList<String>();
        private final Host myHost = new Host();

        public HostEntry(String patterns) {
            for (String pattern : patterns.split("[\t ,]+")) {
                if (pattern.length() == 0) continue;
                if (pattern.startsWith("!")) {
                    this.myNegative.add(HostEntry.compilePattern(pattern.substring(1).trim()));
                    continue;
                }
                if (pattern.indexOf(63) == 0 && pattern.indexOf(42) == 0) {
                    this.myExactPositive.add(pattern);
                    continue;
                }
                this.myPositive.add(HostEntry.compilePattern(pattern));
            }
        }

        private static Pattern compilePattern(String s) {
            StringBuilder rc = new StringBuilder();
            block5: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '?': {
                        rc.append('.');
                        continue block5;
                    }
                    case '*': {
                        rc.append(".*");
                        continue block5;
                    }
                    case '.': {
                        rc.append('\\');
                    }
                    default: {
                        rc.append(ch);
                    }
                }
            }
            return Pattern.compile(rc.toString());
        }
    }
}

