/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.xmlrpc.DefaultXmlRpcTransportFactory;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransportFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitSSHHandler;

public class GitSSHXmlRpcClient
implements GitSSHHandler {
    @Nullable
    private final XmlRpcClient myClient;

    GitSSHXmlRpcClient(int port, boolean batchMode, String token) throws IOException {
        if (!batchMode) {
            URL url = new URL("http", "localhost", port, "/RPC2");
            DefaultXmlRpcTransportFactory factory = new DefaultXmlRpcTransportFactory(url);
            factory.setBasicAuthentication("_token_", token);
            this.myClient = new XmlRpcClient(url, (XmlRpcTransportFactory)factory);
        } else {
            this.myClient = null;
        }
    }

    @Override
    public boolean verifyServerHostKey(String token, String hostname, int port, String serverHostKeyAlgorithm, String serverHostKey, boolean isNew) {
        if (this.myClient == null) {
            return false;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(token);
        parameters.add(hostname);
        parameters.add(port);
        parameters.add(serverHostKeyAlgorithm);
        parameters.add(serverHostKey);
        parameters.add(isNew);
        try {
            return (Boolean)this.myClient.execute(GitSSHXmlRpcClient.methodName("verifyServerHostKey"), parameters);
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    private static String methodName(@NonNls String method) {
        return "Git4ideaSSHHandler." + method;
    }

    @Override
    @Nullable
    public String askPassphrase(String token, String username, String keyPath, boolean resetPassword, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(token);
        parameters.add(username);
        parameters.add(keyPath);
        parameters.add(resetPassword);
        parameters.add(lastError);
        try {
            return GitSSHXmlRpcClient.adjustNull((String)this.myClient.execute(GitSSHXmlRpcClient.methodName("askPassphrase"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public Vector<String> replyToChallenge(String token, String username, String name, String instruction, int numPrompts, Vector<String> prompt, Vector<Boolean> echo, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(token);
        parameters.add(username);
        parameters.add(name);
        parameters.add(instruction);
        parameters.add(numPrompts);
        parameters.add(prompt);
        parameters.add(echo);
        parameters.add(lastError);
        try {
            return GitSSHXmlRpcClient.adjustNull((Vector)this.myClient.execute(GitSSHXmlRpcClient.methodName("replyToChallenge"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public String askPassword(String token, String username, boolean resetPassword, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(token);
        parameters.add(username);
        parameters.add(resetPassword);
        parameters.add(lastError);
        try {
            return GitSSHXmlRpcClient.adjustNull((String)this.myClient.execute(GitSSHXmlRpcClient.methodName("askPassword"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    public String setLastSuccessful(String token, String userName, String method, String error) {
        if (this.myClient == null) {
            return "";
        }
        Vector<String> parameters = new Vector<String>();
        parameters.add(token);
        parameters.add(userName);
        parameters.add(method);
        parameters.add(error);
        try {
            return (String)this.myClient.execute(GitSSHXmlRpcClient.methodName("setLastSuccessful"), parameters);
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    public String getLastSuccessful(String token, String userName) {
        if (this.myClient == null) {
            return "";
        }
        Vector<String> parameters = new Vector<String>();
        parameters.add(token);
        parameters.add(userName);
        try {
            return (String)this.myClient.execute(GitSSHXmlRpcClient.methodName("getLastSuccessful"), parameters);
        }
        catch (XmlRpcException e) {
            GitSSHXmlRpcClient.log("getLastSuccessful failed. token: " + token + ", userName: " + userName + ", client: " + this.myClient.getURL());
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            GitSSHXmlRpcClient.log("getLastSuccessful failed. token: " + token + ", userName: " + userName + ", client: " + this.myClient.getURL());
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Nullable
    private static String adjustNull(String s) {
        return s.charAt(0) == '-' ? null : s.substring(1);
    }

    @Nullable
    private static <T> Vector<T> adjustNull(Vector<T> s) {
        return s.size() == 0 ? null : s;
    }

    private static void log(String s) {
        System.err.println(s);
    }
}

