/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.http;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.http.GitAskPassXmlRpcClient;

public class GitAskPassApp
implements GitExternalApp {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("No arguments specified!");
            }
            Pair<Boolean, String> arguments = GitAskPassApp.parseArguments(args[0]);
            boolean usernameNeeded = (Boolean)arguments.getFirst();
            String url = (String)arguments.getSecond();
            String token = GitAskPassApp.getNotNull("GIT_ASKPASS_HANDLER");
            int xmlRpcPort = Integer.parseInt(GitAskPassApp.getNotNull("GIT_ASKPASS_PORT"));
            String xmlRpcToken = GitAskPassApp.getNotNull("GIT_ASKPASS_TOKEN");
            GitAskPassXmlRpcClient xmlRpcClient = new GitAskPassXmlRpcClient(xmlRpcPort, xmlRpcToken);
            if (usernameNeeded) {
                String username = xmlRpcClient.askUsername(token, url);
                System.out.println(username);
            } else {
                String pass = xmlRpcClient.askPassword(token, url);
                System.out.println(pass);
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    private static String getNotNull(@NotNull String env) {
        String value = System.getenv(env);
        if (value == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        return value;
    }

    @NotNull
    private static Pair<Boolean, String> parseArguments(@NotNull String arg) {
        boolean username = StringUtilRt.startsWithIgnoreCase((String)arg, (String)"username");
        String[] split = arg.split(" ");
        String url = split.length > 2 ? GitAskPassApp.parseUrl(split[2]) : "";
        return Pair.create((Object)username, (Object)url);
    }

    private static String parseUrl(@NotNull String urlArg) {
        String url = urlArg;
        if (url.startsWith("'")) {
            url = url.substring(1);
        }
        if (url.endsWith(":")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("'")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

