/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.PreprocessDataFile;
import com.android.ide.common.res2.PreprocessDataItem;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreprocessDataSet
extends DataSet<PreprocessDataItem, PreprocessDataFile> {
    private ResourcesDirectory mResourcesDirectory;
    private SetMultimap<File, File> mGeneratedFiles;
    private File generatedResDirectory;
    private File mergedResDirectory;

    public PreprocessDataSet(String configName, ResourcesDirectory resourcesDirectory) {
        super(configName + ":" + resourcesDirectory.name(), true);
        this.mResourcesDirectory = resourcesDirectory;
    }

    public void setGeneratedFiles(SetMultimap<File, File> generatedFiles) {
        this.mGeneratedFiles = generatedFiles;
    }

    @Override
    protected DataSet<PreprocessDataItem, PreprocessDataFile> createSet(String name) {
        List parts = Splitter.on((String)":").splitToList((CharSequence)name);
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (Object)"Invalid data set name.");
        return new PreprocessDataSet((String)parts.get(0), Enum.valueOf(ResourcesDirectory.class, (String)parts.get(1)));
    }

    @Override
    protected PreprocessDataFile createFileAndItems(@NonNull File file, @NonNull Node fileNode) {
        Node name = fileNode.getAttributes().getNamedItem("name");
        if (name != null) {
            PreprocessDataFile dataFile = new PreprocessDataFile(file, DataFile.FileType.SINGLE);
            PreprocessDataItem dataItem = new PreprocessDataItem(((Attr)name).getValue(), file);
            dataFile.addItem(dataItem);
            return dataFile;
        }
        PreprocessDataFile dataFile = new PreprocessDataFile(file, DataFile.FileType.SINGLE);
        NodeList childNodes = fileNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node itemNode = childNodes.item(i);
            name = itemNode.getAttributes().getNamedItem("name");
            Attr path = (Attr)itemNode.getAttributes().getNamedItem("file-to-use");
            File fileToUse = new File(path.getValue());
            PreprocessDataItem dataItem = new PreprocessDataItem(((Attr)name).getValue(), fileToUse);
            dataFile.addItem(dataItem);
        }
        return dataFile;
    }

    @Override
    @Nullable
    protected PreprocessDataFile createFileAndItems(File sourceFolder, File file, ILogger logger) throws MergingException {
        if (this.mResourcesDirectory == ResourcesDirectory.MERGED) {
            String name = FileUtils.relativePath((File)file, (File)this.getMergedResDirectory());
            PreprocessDataFile dataFile = new PreprocessDataFile(file, DataFile.FileType.SINGLE);
            PreprocessDataItem dataItem = new PreprocessDataItem(name, file);
            dataFile.addItem(dataItem);
            return dataFile;
        }
        PreprocessDataFile dataFile = new PreprocessDataFile(file, DataFile.FileType.MULTI);
        for (File generatedFile : this.mGeneratedFiles.get((Object)file)) {
            String name = FileUtils.relativePath((File)generatedFile, (File)this.getGeneratedResDirectory());
            dataFile.addItem(new PreprocessDataItem(name, generatedFile));
        }
        return dataFile;
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger) throws MergingException {
        throw new UnsupportedOperationException("Use per-file methods on PreprocessDataSet instead.");
    }

    public File getGeneratedResDirectory() {
        return this.generatedResDirectory;
    }

    public void setGeneratedResDirectory(File generatedResDirectory) {
        this.generatedResDirectory = generatedResDirectory;
    }

    public File getMergedResDirectory() {
        return this.mergedResDirectory;
    }

    public void setMergedResDirectory(File mergedResDirectory) {
        this.mergedResDirectory = mergedResDirectory;
    }

    public ResourcesDirectory getResourcesDirectory() {
        return this.mResourcesDirectory;
    }

    public static enum ResourcesDirectory {
        MERGED,
        GENERATED;

    }
}

