/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class SourceFilePositionJsonSerializer
implements JsonSerializer<SourceFilePosition>,
JsonDeserializer<SourceFilePosition> {
    private static final String POSITION = "position";
    private static final String FILE = "file";

    public SourceFilePosition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject object = json.getAsJsonObject();
        SourceFile file = object.has(FILE) ? (SourceFile)context.deserialize(object.get(FILE), SourceFile.class) : SourceFile.UNKNOWN;
        SourcePosition position = object.has(POSITION) ? (SourcePosition)context.deserialize(object.get(POSITION), SourcePosition.class) : SourcePosition.UNKNOWN;
        return new SourceFilePosition(file, position);
    }

    public JsonElement serialize(SourceFilePosition src, Type typeOfSrc, JsonSerializationContext context) {
        SourcePosition position;
        JsonObject object = new JsonObject();
        SourceFile sourceFile = src.getFile();
        if (!sourceFile.equals((Object)SourceFile.UNKNOWN)) {
            object.add(FILE, context.serialize((Object)sourceFile));
        }
        if (!(position = src.getPosition()).equals((Object)SourcePosition.UNKNOWN)) {
            object.add(POSITION, context.serialize((Object)position));
        }
        return object;
    }
}

