/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public abstract class OrTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a, TreeFilter b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        return new Binary(a, b);
    }

    public static TreeFilter create(TreeFilter[] list) {
        if (list.length == 2) {
            return OrTreeFilter.create(list[0], list[1]);
        }
        if (list.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.length];
        System.arraycopy(list, 0, subfilters, 0, list.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.size()];
        list.toArray(subfilters);
        if (subfilters.length == 2) {
            return OrTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class List
    extends OrTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list) {
            this.subfilters = list;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            for (TreeFilter f : this.subfilters) {
                if (!f.include(walker)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean shouldBeRecursive() {
            for (TreeFilter f : this.subfilters) {
                if (!f.shouldBeRecursive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public TreeFilter clone() {
            TreeFilter[] s = new TreeFilter[this.subfilters.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = this.subfilters[i].clone();
            }
            return new List(s);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            for (int i = 0; i < this.subfilters.length; ++i) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.subfilters[i].toString());
            }
            r.append(")");
            return r.toString();
        }
    }

    private static class Binary
    extends OrTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker) || this.b.include(walker);
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " OR " + this.b.toString() + ")";
        }
    }
}

