/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.java.LanguageReference;
import org.intellij.plugins.intelliLang.inject.java.RegExpEnumReference;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

public final class LanguageReferenceProvider
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        final Configuration configuration = Configuration.getInstance();
        registrar.registerReferenceProvider((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().annotationParam((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("isLanguageAnnotation"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                return Comparing.equal((String)configuration.getAdvancedConfiguration().getLanguageAnnotationClass(), (String)s);
            }
        }), "value")).and((ElementPattern)PsiJavaPatterns.literalExpression().with((PatternCondition)new PatternCondition<PsiLiteralExpression>("isStringLiteral"){

            public boolean accepts(@NotNull PsiLiteralExpression expression, ProcessingContext context) {
                return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)expression);
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                return new PsiReference[]{new LanguageReference((PsiLiteral)((PsiLiteralExpression)element))};
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().with((PatternCondition)new PatternCondition<PsiLiteralExpression>("isStringLiteral"){

            public boolean accepts(@NotNull PsiLiteralExpression expression, ProcessingContext context) {
                return PsiUtilEx.isStringOrCharacterLiteral((PsiElement)expression);
            }
        }), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
                String pattern;
                PsiAnnotation[] annotations;
                PsiLiteralExpression expression = (PsiLiteralExpression)psiElement;
                PsiModifierListOwner owner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION);
                if (owner != null && PsiUtilEx.isLanguageAnnotationTarget(owner) && (annotations = AnnotationUtilEx.getAnnotationFrom(owner, configuration.getAdvancedConfiguration().getPatternAnnotationPair(), true)).length > 0 && (pattern = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null) {
                    return new PsiReference[]{new RegExpEnumReference(expression, pattern)};
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }
}

