/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.shell.GroovyShellCodeFragment;

public class GroovyShellLanguageConsoleView
extends LanguageConsoleImpl {
    public GroovyShellLanguageConsoleView(Project project, String name) {
        super(new LanguageConsoleImpl.Helper(project, (VirtualFile)new LightVirtualFile(name, (Language)GroovyLanguage.INSTANCE, (CharSequence)"")){

            @NotNull
            public PsiFile getFile() {
                return new GroovyShellCodeFragment(this.project, (LightVirtualFile)this.virtualFile);
            }
        });
    }

    protected void processCode() {
        GroovyShellCodeFragment groovyFile = this.getGroovyFile();
        for (GrTopStatement statement : groovyFile.getTopStatements()) {
            if (statement instanceof GrImportStatement) {
                groovyFile.addImportsFromString(GroovyShellLanguageConsoleView.importToString((GrImportStatement)statement));
                continue;
            }
            if (statement instanceof GrMethod) {
                groovyFile.addVariable(((GrMethod)statement).getName(), this.generateClosure((GrMethod)statement));
                continue;
            }
            if (statement instanceof GrAssignmentExpression) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
                GrExpression left = assignment.getLValue();
                if (!(left instanceof GrReferenceExpression) || ((GrReferenceExpression)left).isQualified()) continue;
                groovyFile.addVariable(((GrReferenceExpression)left).getReferenceName(), assignment.getRValue());
                continue;
            }
            if (!(statement instanceof GrTypeDefinition)) continue;
            groovyFile.addTypeDefinition(this.prepareTypeDefinition((GrTypeDefinition)statement));
        }
        PsiType scriptType = groovyFile.getInferredScriptReturnType();
        if (scriptType != null) {
            groovyFile.addVariable("_", scriptType);
        }
    }

    @NotNull
    public GroovyShellCodeFragment getGroovyFile() {
        return (GroovyShellCodeFragment)this.getFile();
    }

    @NotNull
    private GrTypeDefinition prepareTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GroovyFile file = factory.createGroovyFile("", false, (PsiElement)this.getFile());
        return (GrTypeDefinition)file.add(typeDefinition);
    }

    @NotNull
    private GrClosableBlock generateClosure(@NotNull GrMethod method) {
        GrParameter[] parameters;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (GrParameter parameter : parameters = method.getParameters()) {
            buffer.append(parameter.getText());
            buffer.append(',');
        }
        if (parameters.length > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("->}");
        return factory.createClosureFromText(buffer.toString(), (PsiElement)this.getFile());
    }

    @Nullable
    private static String importToString(@NotNull GrImportStatement anImport) {
        StringBuilder buffer = new StringBuilder();
        GrCodeReferenceElement reference = anImport.getImportReference();
        if (reference == null) {
            return null;
        }
        String qname = reference.getClassNameText();
        buffer.append(qname);
        if (!anImport.isOnDemand()) {
            String importedName = anImport.getImportedName();
            buffer.append(":").append(importedName);
        }
        return buffer.toString();
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        String result = super.addToHistoryInner(textRange, editor, erase, preserveMarkup);
        if ("purge variables".equals(result.trim())) {
            this.clearVariables();
        } else if ("purge classes".equals(result.trim())) {
            this.clearClasses();
        } else if ("purge imports".equals(result.trim())) {
            this.clearImports();
        } else if ("purge all".equals(result.trim())) {
            this.clearVariables();
            this.clearClasses();
            this.clearImports();
        } else {
            this.processCode();
        }
        return result;
    }

    private void clearVariables() {
        this.getGroovyFile().clearVariables();
    }

    private void clearClasses() {
        this.getGroovyFile().clearClasses();
    }

    private void clearImports() {
        this.getGroovyFile().clearImports();
    }
}

