/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyRunConfigurationEditor;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GroovyScriptRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance(GroovyScriptRunConfiguration.class);
    private String vmParams;
    private String workDir;
    private boolean isDebugEnabled;
    @Nullable
    private String scriptParams;
    @Nullable
    private String scriptPath;
    private final Map<String, String> envs = new LinkedHashMap();
    public boolean passParentEnv = true;

    public GroovyScriptRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, new RunConfigurationModule(project), factory);
        this.workDir = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    public void setWorkDir(String dir) {
        this.workDir = dir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    public Collection<Module> getValidModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        GroovyScriptRunner scriptRunner = this.findConfiguration();
        if (scriptRunner == null) {
            return Arrays.asList(modules);
        }
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (!scriptRunner.isValidModule(module)) continue;
            res.add(module);
        }
        return res;
    }

    @Nullable
    private GroovyScriptRunner findConfiguration() {
        VirtualFile scriptFile = this.getScriptFile();
        if (scriptFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(scriptFile);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        if (!((GroovyFile)psiFile).isScript()) {
            return new DefaultGroovyScriptRunner();
        }
        return GroovyScriptUtil.getScriptType((GroovyFile)psiFile).getRunner();
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.readModule(element);
        this.scriptPath = ExternalizablePath.localPathValue((String)JDOMExternalizer.readString((Element)element, (String)"path"));
        this.vmParams = JDOMExternalizer.readString((Element)element, (String)"vmparams");
        this.scriptParams = JDOMExternalizer.readString((Element)element, (String)"params");
        String wrk = JDOMExternalizer.readString((Element)element, (String)"workDir");
        if (!".".equals(wrk)) {
            this.workDir = ExternalizablePath.localPathValue((String)wrk);
        }
        this.isDebugEnabled = Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)"debug"));
        this.envs.clear();
        JDOMExternalizer.readMap((Element)element, this.envs, null, (String)"env");
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        JDOMExternalizer.write((Element)element, (String)"path", (String)ExternalizablePath.urlValue((String)this.scriptPath));
        JDOMExternalizer.write((Element)element, (String)"vmparams", (String)this.vmParams);
        JDOMExternalizer.write((Element)element, (String)"params", (String)this.scriptParams);
        JDOMExternalizer.write((Element)element, (String)"workDir", (String)ExternalizablePath.urlValue((String)this.workDir));
        JDOMExternalizer.write((Element)element, (String)"debug", (boolean)this.isDebugEnabled);
        JDOMExternalizer.writeMap((Element)element, this.envs, null, (String)"env");
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        final VirtualFile script = this.getScriptFile();
        if (script == null) {
            throw new CantRunException("Cannot find script " + this.scriptPath);
        }
        final GroovyScriptRunner scriptRunner = this.findConfiguration();
        if (scriptRunner == null) {
            throw new CantRunException("Unknown script type " + this.scriptPath);
        }
        final Module module = (Module)ObjectUtils.chooseNotNull((Object)this.getModule(), (Object)ContainerUtil.getFirstItem(this.getValidModules()));
        if (!scriptRunner.ensureRunnerConfigured(module, (RunProfile)this, executor, this.getProject())) {
            return null;
        }
        final boolean tests = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInTestSourceContent(script);
        return new JavaCommandLineState(environment){

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler handler = super.startProcess();
                handler.setShouldDestroyProcessRecursively(true);
                if (scriptRunner.shouldRefreshAfterFinish()) {
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            if (!ApplicationManager.getApplication().isDisposed()) {
                                VirtualFileManager.getInstance().asyncRefresh(null);
                            }
                        }
                    });
                }
                return handler;
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                JavaParameters params = GroovyScriptRunConfiguration.createJavaParametersWithSdk(module);
                ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)params, (CommonProgramRunConfigurationParameters)GroovyScriptRunConfiguration.this);
                scriptRunner.configureCommandLine(params, module, tests, script, GroovyScriptRunConfiguration.this);
                return params;
            }
        };
    }

    public void setScriptParameters(String scriptParameters) {
        this.scriptParams = scriptParameters;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.scriptPath == null || !this.scriptPath.equals(GroovyScriptRunConfiguration.getPathByElement(element))) {
            return null;
        }
        PsiClass classToRun = GroovyRunnerPsiUtil.getRunningClass(element);
        if (element instanceof GroovyFile) {
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof GroovyFile) {
                        GroovyFile file = (GroovyFile)newElement;
                        GroovyScriptRunConfiguration.this.setScriptPath(ScriptFileUtil.getScriptFilePath((VirtualFile)file.getVirtualFile()));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    this.elementRenamedOrMoved(newElement);
                }
            };
        }
        if (element instanceof PsiClass && element.getManager().areElementsEquivalent(element, (PsiElement)classToRun)) {
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    GroovyScriptRunConfiguration.this.setName(((PsiClass)newElement).getName());
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    this.elementRenamedOrMoved(newElement);
                }
            };
        }
        return null;
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return null;
        }
        return vfile.getPath();
    }

    public static JavaParameters createJavaParametersWithSdk(@Nullable Module module) {
        Sdk sdk;
        JavaParameters params = new JavaParameters();
        params.setCharset(null);
        if (module != null && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdkType) {
            params.setJdk(sdk);
        }
        if (params.getJdk() == null) {
            params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        return params;
    }

    @Nullable
    private VirtualFile getScriptFile() {
        return ScriptFileUtil.findScriptFileByPath((String)this.scriptPath);
    }

    @Nullable
    private PsiClass getScriptClass() {
        VirtualFile scriptFile = this.getScriptFile();
        if (scriptFile == null) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)this.getProject()).findFile(scriptFile);
        return GroovyRunnerPsiUtil.getRunningClass((PsiElement)file);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new GroovyRunConfigurationEditor();
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        PsiClass toRun = this.getScriptClass();
        if (toRun == null) {
            throw new RuntimeConfigurationWarning(GroovyBundle.message("class.does.not.exist", new Object[0]));
        }
        if (toRun instanceof GrTypeDefinition) {
            if (!GroovyRunnerPsiUtil.canBeRunByGroovy(toRun)) {
                throw new RuntimeConfigurationWarning(GroovyBundle.message("class.can't be executed", new Object[0]));
            }
        } else if (!(toRun instanceof GroovyScriptClass)) {
            throw new RuntimeConfigurationWarning(GroovyBundle.message("script.file.is.not.groovy.file", new Object[0]));
        }
    }

    public void setVMParameters(String value) {
        this.vmParams = value;
    }

    public String getVMParameters() {
        return this.vmParams;
    }

    public boolean isAlternativeJrePathEnabled() {
        throw new UnsupportedOperationException();
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getAlternativeJrePath() {
        throw new UnsupportedOperationException();
    }

    public void setAlternativeJrePath(String path) {
        throw new UnsupportedOperationException();
    }

    public String getRunClass() {
        return null;
    }

    public String getPackage() {
        return null;
    }

    public void setProgramParameters(@Nullable String value) {
        LOG.error("Don't add program parameters to Groovy script run configuration. Use Script parameters instead");
    }

    public String getProgramParameters() {
        return null;
    }

    @Nullable
    public String getScriptParameters() {
        return this.scriptParams;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.workDir = value;
    }

    public String getWorkingDirectory() {
        return this.workDir;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        this.envs.clear();
        this.envs.putAll(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return this.envs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.passParentEnv = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.passParentEnv;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.isDebugEnabled = debugEnabled;
    }

    @Nullable
    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(@Nullable String scriptPath) {
        this.scriptPath = scriptPath;
    }
}

