/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public class GroovyRunConfigurationEditor
extends SettingsEditor<GroovyScriptRunConfiguration>
implements PanelWithAnchor {
    private ModulesComboBox myModulesBox;
    private JPanel myMainPanel;
    private RawCommandLineEditor myVMParameters;
    private RawCommandLineEditor myParameters;
    private JPanel scriptPathPanel;
    private JPanel workDirPanel;
    private JCheckBox myDebugCB;
    private EnvironmentVariablesComponent myEnvVariables;
    private JBLabel myScriptParametersLabel;
    private final JTextField scriptPathField;
    private final JTextField workDirField;
    private JComponent anchor;

    public GroovyRunConfigurationEditor() {
        this.$$$setupUI$$$();
        this.scriptPathField = new JTextField();
        BrowseFilesListener scriptBrowseListener = new BrowseFilesListener(this.scriptPathField, "Script Path", "Specify path to script", new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return file.getFileType() == GroovyFileType.GROOVY_FILE_TYPE;
            }
        });
        FieldPanel scriptFieldPanel = new FieldPanel(this.scriptPathField, null, null, (ActionListener)scriptBrowseListener, null);
        this.scriptPathPanel.setLayout(new BorderLayout());
        this.scriptPathPanel.add((Component)scriptFieldPanel, "Center");
        this.workDirField = new JTextField();
        BrowseFilesListener workDirBrowseFilesListener = new BrowseFilesListener(this.workDirField, "Working directory", "Specify working directory", BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
        FieldPanel workDirFieldPanel = new FieldPanel(this.workDirField, null, null, (ActionListener)workDirBrowseFilesListener, null);
        this.workDirPanel.setLayout(new BorderLayout());
        this.workDirPanel.add((Component)workDirFieldPanel, "Center");
        this.setAnchor((JComponent)this.myEnvVariables.getLabel());
    }

    public void resetEditorFrom(GroovyScriptRunConfiguration configuration) {
        this.myVMParameters.setDialogCaption("VM Options");
        this.myVMParameters.setText(configuration.getVMParameters());
        this.myParameters.setDialogCaption("Script Parameters");
        this.myParameters.setText(configuration.getScriptParameters());
        this.scriptPathField.setText(configuration.getScriptPath());
        this.workDirField.setText(configuration.getWorkDir());
        this.myDebugCB.setEnabled(true);
        this.myDebugCB.setSelected(configuration.isDebugEnabled());
        this.myModulesBox.setModules(configuration.getValidModules());
        this.myModulesBox.setSelectedModule(configuration.getModule());
        this.myEnvVariables.setEnvs(configuration.getEnvs());
    }

    public void applyEditorTo(GroovyScriptRunConfiguration configuration) throws ConfigurationException {
        configuration.setModule(this.myModulesBox.getSelectedModule());
        configuration.setVMParameters(this.myVMParameters.getText());
        configuration.setDebugEnabled(this.myDebugCB.isSelected());
        configuration.setScriptParameters(this.myParameters.getText());
        configuration.setScriptPath(this.scriptPathField.getText().trim());
        configuration.setWorkDir(this.workDirField.getText().trim());
        configuration.setEnvs(this.myEnvVariables.getEnvs());
    }

    @NotNull
    public JComponent createEditor() {
        this.myDebugCB.setEnabled(true);
        this.myDebugCB.setSelected(false);
        return this.myMainPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myScriptParametersLabel.setAnchor(anchor);
        this.myEnvVariables.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JPanel jPanel;
        JPanel jPanel2;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVMParameters = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor2, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.scriptPathPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.workDirPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEnvVariables = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel3.add((Component)environmentVariablesComponent, new GridConstraints(4, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myScriptParametersLabel = jBLabel = new JBLabel();
        jBLabel.setText("Script parameters:");
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("VM options:");
        jPanel3.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Module:");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModulesBox = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Script path:");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Working directory:");
        jPanel3.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebugCB = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/GroovyBundle").getString("debug.option"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

