/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.constant;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrFieldNameSuggester;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyVariableValidator;
import org.jetbrains.plugins.groovy.refactoring.ui.GrTypeComboBox;

public class GrIntroduceConstantDialog
extends DialogWrapper
implements GrIntroduceConstantSettings,
GrIntroduceDialog<GrIntroduceConstantSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantDialog");
    private final GrIntroduceContext myContext;
    private JLabel myNameLabel;
    private JCheckBox myReplaceAllOccurrences;
    private JPanel myPanel;
    private GrTypeComboBox myTypeCombo;
    private ReferenceEditorComboWithBrowseButton myTargetClassEditor;
    private NameSuggestionsField myNameField;
    private JavaVisibilityPanel myJavaVisibilityPanel;
    private JPanel myTargetClassPanel;
    private JLabel myTargetClassLabel;
    @Nullable
    private PsiClass myTargetClass;
    @Nullable
    private final PsiClass myDefaultTargetClass;
    private TargetClassInfo myTargetClassInfo;
    @NonNls
    private static final String RECENTS_KEY = "GrIntroduceConstantDialog.RECENTS_KEY";

    public GrIntroduceConstantDialog(GrIntroduceContext context, @Nullable PsiClass defaultTargetClass) {
        super(context.getProject());
        this.myContext = context;
        this.myTargetClass = defaultTargetClass;
        this.myDefaultTargetClass = defaultTargetClass;
        this.$$$setupUI$$$();
        this.setTitle("Introduce Constant");
        this.myJavaVisibilityPanel.setVisibility(JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY);
        this.updateVisibilityPanel();
        this.updateOkStatus();
        this.init();
    }

    @Nullable
    public static PsiClass getParentClass(PsiElement occurrence) {
        PsiElement cur = occurrence;
        PsiClass parentClass;
        while ((parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cur, PsiClass.class, (boolean)true)) != null && !parentClass.hasModifierProperty("static")) {
            cur = parentClass;
        }
        return parentClass;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        this.initializeName();
        this.initializeTargetClassEditor();
        if (GrIntroduceHandlerBase.resolveLocalVar(this.myContext) != null) {
            this.myReplaceAllOccurrences.setEnabled(false);
            this.myReplaceAllOccurrences.setSelected(true);
        } else if (this.myContext.getOccurrences().length < 2) {
            this.myReplaceAllOccurrences.setVisible(false);
        }
        return this.myPanel;
    }

    private void initializeTargetClassEditor() {
        this.myTargetClassEditor = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)GrIntroduceConstantDialog.this.myContext.getProject()).createWithInnerClassesScopeChooser(RefactoringBundle.message((String)"choose.destination.class"), GlobalSearchScope.projectScope((Project)GrIntroduceConstantDialog.this.myContext.getProject()), new ClassFilter(){

                    public boolean isAccepted(PsiClass aClass) {
                        return aClass.getParent() instanceof GroovyFile || aClass.hasModifierProperty("static");
                    }
                }, null);
                if (GrIntroduceConstantDialog.this.myTargetClass != null) {
                    chooser.selectDirectory(GrIntroduceConstantDialog.this.myTargetClass.getContainingFile().getContainingDirectory());
                }
                chooser.showDialog();
                PsiClass aClass = chooser.getSelected();
                if (aClass != null) {
                    GrIntroduceConstantDialog.this.myTargetClassEditor.setText(aClass.getQualifiedName());
                }
            }
        }, "", this.myContext.getProject(), true, RECENTS_KEY);
        this.myTargetClassPanel.setLayout(new BorderLayout());
        this.myTargetClassPanel.add((Component)this.myTargetClassLabel, "North");
        this.myTargetClassPanel.add((Component)this.myTargetClassEditor, "Center");
        LinkedHashSet<String> possibleClassNames = new LinkedHashSet<String>();
        for (PsiElement occurrence : this.myContext.getOccurrences()) {
            PsiClass parentClass = GrIntroduceConstantDialog.getParentClass(occurrence);
            if (parentClass == null || parentClass.getQualifiedName() == null) continue;
            possibleClassNames.add(parentClass.getQualifiedName());
        }
        for (String possibleClassName : possibleClassNames) {
            this.myTargetClassEditor.prependItem(possibleClassName);
        }
        if (this.myDefaultTargetClass != null) {
            this.myTargetClassEditor.prependItem(this.myDefaultTargetClass.getQualifiedName());
        }
        ((EditorComboBox)this.myTargetClassEditor.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                GrIntroduceConstantDialog.this.targetClassChanged();
                GrIntroduceConstantDialog.this.updateOkStatus();
            }
        });
    }

    private void initializeName() {
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrIntroduceConstantDialog.this.myNameField.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        this.myNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                GrIntroduceConstantDialog.this.updateOkStatus();
            }
        });
    }

    @Override
    public String getVisibilityModifier() {
        return this.myJavaVisibilityPanel.getVisibility();
    }

    @Override
    @Nullable
    public PsiClass getTargetClass() {
        return this.myTargetClassInfo.getTargetClass();
    }

    @NotNull
    public String getTargetClassName() {
        return this.myTargetClassEditor.getText();
    }

    @Override
    public GrIntroduceConstantSettings getSettings() {
        return this;
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggestNames() {
        return new GrFieldNameSuggester(this.myContext, new GroovyVariableValidator(this.myContext), true).suggestNames();
    }

    @Override
    @Nullable
    public String getName() {
        return this.myNameField.getEnteredName();
    }

    @Override
    public boolean replaceAllOccurrences() {
        return this.myReplaceAllOccurrences.isSelected();
    }

    @Override
    public PsiType getSelectedType() {
        return this.myTypeCombo.getSelectedType();
    }

    private void createUIComponents() {
        this.myJavaVisibilityPanel = new JavaVisibilityPanel(false, true);
        GrVariable var = this.myContext.getVar();
        GrExpression expression = this.myContext.getExpression();
        StringPartInfo stringPart = this.myContext.getStringPart();
        if (expression != null) {
            this.myTypeCombo = GrTypeComboBox.createTypeComboBoxFromExpression(expression);
        } else if (stringPart != null) {
            this.myTypeCombo = GrTypeComboBox.createTypeComboBoxFromExpression(stringPart.getLiteral());
        } else {
            assert (var != null);
            this.myTypeCombo = GrTypeComboBox.createTypeComboBoxWithDefType(var.getDeclaredType(), var);
        }
        ArrayList<String> names = new ArrayList<String>();
        if (var != null) {
            names.add(var.getName());
        }
        if (expression != null) {
            ContainerUtil.addAll(names, this.suggestNames());
        }
        this.myNameField = new NameSuggestionsField(ArrayUtil.toStringArray(names), this.myContext.getProject(), (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        GrTypeComboBox.registerUpDownHint((JComponent)this.myNameField, this.myTypeCombo);
    }

    private void targetClassChanged() {
        String targetClassName = this.getTargetClassName();
        this.myTargetClass = JavaPsiFacade.getInstance((Project)this.myContext.getProject()).findClass(targetClassName, GlobalSearchScope.projectScope((Project)this.myContext.getProject()));
        this.updateVisibilityPanel();
    }

    private void updateVisibilityPanel() {
        if (this.myTargetClass != null && this.myTargetClass.isInterface()) {
            this.myJavaVisibilityPanel.disableAllButPublic();
        } else {
            UIUtil.setEnabled((Component)this.myJavaVisibilityPanel, (boolean)true, (boolean)true);
            THashSet visible = new THashSet();
            visible.add("private");
            visible.add("protected");
            visible.add("packageLocal");
            visible.add("public");
            for (PsiElement occurrence : this.myContext.getOccurrences()) {
                PsiManager psiManager = PsiManager.getInstance((Project)this.myContext.getProject());
                Iterator iterator = visible.iterator();
                while (iterator.hasNext()) {
                    String modifier = (String)iterator.next();
                    try {
                        String modifierText;
                        String string = modifierText = "packageLocal".equals(modifier) ? "" : modifier + " ";
                        PsiField field = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createFieldFromText(modifierText + "int xxx;", (PsiElement)this.myTargetClass);
                        if (JavaResolveUtil.isAccessible((PsiMember)field, (PsiClass)this.myTargetClass, (PsiModifierList)field.getModifierList(), (PsiElement)occurrence, (PsiClass)this.myTargetClass, null)) continue;
                        iterator.remove();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            if (!visible.contains(this.getVisibilityModifier())) {
                if (visible.contains("public")) {
                    this.myJavaVisibilityPanel.setVisibility("public");
                }
                if (visible.contains("packageLocal")) {
                    this.myJavaVisibilityPanel.setVisibility("packageLocal");
                }
                if (visible.contains("protected")) {
                    this.myJavaVisibilityPanel.setVisibility("protected");
                }
                if (visible.contains("private")) {
                    this.myJavaVisibilityPanel.setVisibility("private");
                }
            }
        }
    }

    private void updateOkStatus() {
        if (this.myTargetClassEditor == null) {
            return;
        }
        String text = this.getName();
        if (!GroovyNamesUtil.isIdentifier(text)) {
            this.setOKActionEnabled(false);
            return;
        }
        String targetClassName = this.myTargetClassEditor.getText();
        if (targetClassName.trim().isEmpty() && this.myDefaultTargetClass == null) {
            this.setOKActionEnabled(false);
            return;
        }
        String trimmed = targetClassName.trim();
        if (!PsiNameHelper.getInstance((Project)this.myContext.getProject()).isQualifiedName(trimmed)) {
            this.setOKActionEnabled(false);
            return;
        }
        this.setOKActionEnabled(true);
    }

    protected void doOKAction() {
        String targetClassName = this.getTargetClassName();
        if (this.myDefaultTargetClass == null || !targetClassName.isEmpty() && !Comparing.strEqual((String)targetClassName, (String)this.myDefaultTargetClass.getQualifiedName())) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myContext.getPlace());
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myContext.getProject());
            PsiClass newClass = facade.findClass(targetClassName, GlobalSearchScope.projectScope((Project)this.myContext.getProject()));
            if (newClass == null && Messages.showOkCancelDialog((Project)this.myContext.getProject(), (String)GroovyRefactoringBundle.message("class.does.not.exist.in.the.module", new Object[0]), (String)IntroduceConstantHandler.REFACTORING_NAME, (Icon)Messages.getErrorIcon()) != 0) {
                return;
            }
            this.myTargetClassInfo = new TargetClassInfo(targetClassName, this.myContext.getPlace().getContainingFile().getContainingDirectory(), module, this.myContext.getProject());
        } else {
            this.myTargetClassInfo = new TargetClassInfo(this.myDefaultTargetClass);
        }
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY = this.getVisibilityModifier();
        RecentsManager.getInstance((Project)this.myContext.getProject()).registerRecentEntry(RECENTS_KEY, targetClassName);
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JLabel jLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        GrTypeComboBox grTypeComboBox = this.myTypeCombo;
        jPanel3.add((Component)((Object)grTypeComboBox), new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Name:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(35, 49), null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel3.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        JavaVisibilityPanel javaVisibilityPanel = this.myJavaVisibilityPanel;
        jPanel4.add((Component)javaVisibilityPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myReplaceAllOccurrences = jCheckBox = new JCheckBox();
        jCheckBox.setText("Replace all occurrences");
        jCheckBox.setMnemonic('A');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTargetClassPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTargetClassLabel = jLabel = new JLabel();
        jLabel.setText("Introduce to class (fully qualified name):");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor((Component)((Object)grTypeComboBox));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class TargetClassInfo {
        private PsiClass myTargetClass;
        String myQualifiedName;
        PsiDirectory myBaseDirectory;
        Module myModule;
        Project myProject;

        private TargetClassInfo(PsiClass targetClass) {
            this.myTargetClass = targetClass;
        }

        private TargetClassInfo(String qualifiedName, PsiDirectory baseDirectory, Module module, Project project) {
            this.myQualifiedName = qualifiedName;
            this.myBaseDirectory = baseDirectory;
            this.myModule = module;
            this.myProject = project;
        }

        @Nullable
        public PsiClass getTargetClass() {
            if (this.myTargetClass == null) {
                this.myTargetClass = TargetClassInfo.getTargetClass(this.myQualifiedName, this.myBaseDirectory, this.myProject, this.myModule);
            }
            return this.myTargetClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static PsiClass getTargetClass(String qualifiedName, PsiDirectory baseDirectory, Project project, Module module) {
            PsiDirectory[] directories;
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
            PsiClass targetClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, scope);
            if (targetClass != null) {
                return targetClass;
            }
            String packageName = StringUtil.getPackageName((String)qualifiedName);
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
            PsiDirectory psiDirectory = psiPackage != null ? ((directories = psiPackage.getDirectories(GlobalSearchScope.allScope((Project)project))).length > 1 ? DirectoryChooserUtil.chooseDirectory((PsiDirectory[])directories, null, (Project)project, new HashMap()) : directories[0]) : PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)packageName, (PsiDirectory)baseDirectory, (boolean)false);
            if (psiDirectory == null) {
                return null;
            }
            String shortName = StringUtil.getShortName((String)qualifiedName);
            String fileName = shortName + ".groovy";
            AccessToken lock = ApplicationManager.getApplication().acquireWriteActionLock(GrIntroduceConstantDialog.class);
            try {
                GroovyFile file = (GroovyFile)GroovyTemplatesFactory.createFromTemplate(psiDirectory, shortName, fileName, "GroovyClass.groovy", true, new String[0]);
                GrTypeDefinition grTypeDefinition = file.getTypeDefinitions()[0];
                return grTypeDefinition;
            }
            finally {
                lock.finish();
            }
        }
    }
}

