/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ArgumentListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionContext;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ExpressionGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.LocalVarAnalyzer;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ModifierListGenerator;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.StatementWriter;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.TypeWriter;

public class GenerationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil");
    private static final Map<IElementType, Pair<String, IElementType>> binOpTypes = new HashMap();

    private GenerationUtil() {
    }

    public static void writeTypeParameters(StringBuilder builder, PsiType[] parameters, PsiElement context, ClassNameProvider classNameProvider) {
        if (parameters.length == 0) {
            return;
        }
        builder.append('<');
        for (PsiType parameter : parameters) {
            if (parameter instanceof PsiPrimitiveType) {
                parameter = TypesUtil.boxPrimitiveType(parameter, context.getManager(), context.getResolveScope(), true);
            }
            TypeWriter.writeType(builder, parameter, context, classNameProvider);
            builder.append(", ");
        }
        builder.delete(builder.length() - 2, builder.length()).append('>');
    }

    static String suggestVarName(GrExpression expr, ExpressionContext expressionContext) {
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(expr, expressionContext.myUsedVarNames, true);
        String[] varNames = GroovyNameSuggestionUtil.suggestVariableNames(expr, nameValidator);
        LOG.assertTrue(varNames.length > 0);
        expressionContext.myUsedVarNames.add(varNames[0]);
        return varNames[0];
    }

    static String suggestVarName(PsiType type, GroovyPsiElement context, ExpressionContext expressionContext) {
        String[] varNames;
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(context, expressionContext.myUsedVarNames, true, true);
        if (type instanceof PsiPrimitiveType) {
            type = TypesUtil.boxPrimitiveType(type, context.getManager(), context.getResolveScope());
        }
        LOG.assertTrue((varNames = GroovyNameSuggestionUtil.suggestVariableNameByType(type, nameValidator)).length > 0);
        expressionContext.myUsedVarNames.add(varNames[0]);
        return varNames[0];
    }

    public static String validateName(String name, GroovyPsiElement context, ExpressionContext expressionContext) {
        return new DefaultGroovyVariableNameValidator(context, expressionContext.myUsedVarNames, true).validateName(name, true);
    }

    public static void writeCodeReferenceElement(StringBuilder builder, GrCodeReferenceElement referenceElement) {
        GroovyResolveResult resolveResult = referenceElement.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (resolved == null) {
            builder.append(referenceElement.getText());
            return;
        }
        LOG.assertTrue(resolved instanceof PsiClass || resolved instanceof PsiPackage);
        if (resolved instanceof PsiClass) {
            builder.append(((PsiClass)resolved).getQualifiedName());
        } else {
            builder.append(((PsiPackage)resolved).getQualifiedName());
        }
        GenerationUtil.writeTypeParameters(builder, referenceElement.getTypeArguments(), referenceElement, new GeneratorClassNameProvider());
    }

    public static void invokeMethodByName(@Nullable GrExpression caller, @NotNull String methodName, @NotNull GrExpression[] exprs, @NotNull GrNamedArgument[] namedArgs, @NotNull GrClosableBlock[] closureArgs, @NotNull ExpressionGenerator expressionGenerator, @NotNull GroovyPsiElement psiContext) {
        GroovyResolveResult call = GenerationUtil.resolveMethod(caller, methodName, exprs, namedArgs, closureArgs, psiContext);
        GenerationUtil.invokeMethodByResolveResult(caller, call, methodName, exprs, namedArgs, closureArgs, expressionGenerator, psiContext);
    }

    @NotNull
    public static GroovyResolveResult resolveMethod(@Nullable GrExpression caller, @NotNull String methodName, @NotNull GrExpression[] exprs, @NotNull GrNamedArgument[] namedArgs, @NotNull GrClosableBlock[] closureArgs, @NotNull GroovyPsiElement psiContext) {
        GroovyResolveResult call = GroovyResolveResult.EMPTY_RESULT;
        PsiType type = caller == null ? GroovyPsiElementFactory.getInstance(psiContext.getProject()).createExpressionFromText("this", psiContext).getType() : caller.getType();
        if (type != null) {
            PsiType[] argumentTypes = PsiUtil.getArgumentTypes(namedArgs, exprs, closureArgs, false, null, false);
            GroovyResolveResult[] candidates = ResolveUtil.getMethodCandidates(type, methodName, (PsiElement)psiContext, argumentTypes);
            call = PsiImplUtil.extractUniqueResult(candidates);
        }
        return call;
    }

    public static void invokeMethodByResolveResult(@Nullable GrExpression caller, @NotNull GroovyResolveResult resolveResult, @NotNull String methodName, @NotNull GrExpression[] exprs, @NotNull GrNamedArgument[] namedArgs, @NotNull GrClosableBlock[] closureArgs, @NotNull ExpressionGenerator expressionGenerator, @NotNull GroovyPsiElement psiContext) {
        PsiElement resolved = resolveResult.getElement();
        if (resolved instanceof PsiMethod) {
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            expressionGenerator.invokeMethodOn((PsiMethod)resolved, caller, exprs, namedArgs, closureArgs, substitutor, psiContext);
            return;
        }
        StringBuilder builder = expressionGenerator.getBuilder();
        ExpressionContext expressionContext = expressionGenerator.getContext();
        if (caller != null) {
            caller.accept(expressionGenerator);
            builder.append('.');
        }
        builder.append(methodName);
        ArgumentListGenerator argumentListGenerator = new ArgumentListGenerator(builder, expressionContext);
        argumentListGenerator.generate(null, exprs, namedArgs, closureArgs, psiContext);
    }

    static void writeStatement(@NotNull StringBuilder codeBlockBuilder, @NotNull StringBuilder statementBuilder, @Nullable GrStatement statement, @Nullable ExpressionContext context) {
        boolean addParentheses;
        PsiElement parent;
        PsiElement psiElement = parent = statement == null ? null : statement.getParent();
        if (statement == null) {
            addParentheses = context != null && context.shouldInsertCurlyBrackets();
        } else {
            boolean bl = addParentheses = context != null && (context.shouldInsertCurlyBrackets() || !context.myStatements.isEmpty()) && parent instanceof GrControlStatement;
        }
        if (addParentheses) {
            codeBlockBuilder.append("{\n");
        }
        if (context != null) {
            GenerationUtil.insertStatementFromContextBefore(codeBlockBuilder, context);
        }
        codeBlockBuilder.append((CharSequence)statementBuilder);
        if (addParentheses) {
            codeBlockBuilder.append("}\n");
        }
    }

    public static void insertStatementFromContextBefore(StringBuilder codeBlockBuilder, ExpressionContext context) {
        for (String st : context.myStatements) {
            codeBlockBuilder.append(st).append('\n');
        }
    }

    public static void writeStatement(@NotNull StringBuilder builder, @NotNull ExpressionContext context, @Nullable GrStatement statement, @NotNull StatementWriter writer) {
        StringBuilder statementBuilder = new StringBuilder();
        ExpressionContext statementContext = context.copy();
        writer.writeStatement(statementBuilder, statementContext);
        GenerationUtil.writeStatement(builder, statementBuilder, statement, statementContext);
    }

    @Nullable
    static PsiClass findAccessibleSuperClass(@NotNull PsiElement context, @NotNull PsiClass initialClass) {
        HashSet visitedClasses = new HashSet();
        PsiClass curClass = initialClass;
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
        while (curClass != null && !resolveHelper.isAccessible((PsiMember)curClass, context, null)) {
            if (visitedClasses.contains(curClass = curClass.getSuperClass())) {
                return null;
            }
            visitedClasses.add(curClass);
        }
        return curClass;
    }

    static void writeTypeParameters(StringBuilder text, PsiTypeParameterListOwner typeParameterListOwner, ClassNameProvider classNameProvider) {
        if (!typeParameterListOwner.hasTypeParameters()) {
            return;
        }
        text.append('<');
        PsiTypeParameter[] parameters = typeParameterListOwner.getTypeParameters();
        PsiTypeParameterList typeParameterList = typeParameterListOwner.getTypeParameterList();
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                text.append(", ");
            }
            PsiTypeParameter parameter = parameters[i];
            text.append(parameter.getName());
            PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length <= 0) continue;
            text.append(" extends ");
            for (int j = 0; j < extendsListTypes.length; ++j) {
                if (j > 0) {
                    text.append(" & ");
                }
                TypeWriter.writeType(text, (PsiType)extendsListTypes[j], (PsiElement)typeParameterList, classNameProvider);
            }
        }
        text.append('>');
    }

    static void writeParameterList(@NotNull StringBuilder text, @NotNull PsiParameter[] parameters, @NotNull ClassNameProvider classNameProvider, @Nullable ExpressionContext context) {
        HashSet usedNames = new HashSet();
        text.append('(');
        int i = 0;
        while (i < parameters.length) {
            PsiParameter parameter = parameters[i];
            if (parameter == null) continue;
            if (parameter instanceof PsiCompiledElement) {
                parameter = (PsiParameter)((PsiCompiledElement)parameter).getMirror();
            }
            if (i > 0) {
                text.append(", ");
            }
            if (!classNameProvider.forStubs()) {
                ModifierListGenerator.writeModifiers(text, parameter.getModifierList(), ModifierListGenerator.JAVA_MODIFIERS, true);
            }
            if (context != null) {
                if (context.analyzedVars.toMakeFinal((PsiVariable)parameter) && !parameter.hasModifierProperty("final")) {
                    text.append("final").append(' ');
                }
                TypeWriter.writeType(text, context.typeProvider.getParameterType(parameter), (PsiElement)parameter, classNameProvider);
            } else {
                TypeWriter.writeType(text, parameter.getType(), (PsiElement)parameter, classNameProvider);
            }
            text.append(' ');
            text.append(GenerationUtil.generateUniqueName((Set<String>)usedNames, parameter.getName()));
            ++i;
        }
        text.append(')');
        text.append(' ');
    }

    private static String generateUniqueName(Set<String> usedNames, String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            name = "p";
        }
        while (!usedNames.add(name)) {
            name = name + "x";
        }
        return name;
    }

    static void writeThrowsList(StringBuilder text, PsiReferenceList throwsList, PsiClassType[] exceptions, ClassNameProvider classNameProvider) {
        if (exceptions.length <= 0) {
            return;
        }
        text.append("throws ");
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType exception = exceptions[i];
            if (i != 0) {
                text.append(',');
            }
            TypeWriter.writeType(text, (PsiType)exception, (PsiElement)throwsList, classNameProvider);
            text.append(' ');
        }
    }

    static Set<String> getVarTypes(GrVariableDeclaration variableDeclaration) {
        GrVariable[] variables = variableDeclaration.getVariables();
        GrTypeElement typeElement = variableDeclaration.getTypeElementGroovy();
        HashSet types = new HashSet(variables.length);
        if (typeElement == null && variables.length > 1) {
            for (GrVariable variable : variables) {
                PsiType varType;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer == null || (varType = initializer.getType()) == null) continue;
                types.add(GenerationUtil.getTypeText(varType, variableDeclaration));
            }
        }
        return types;
    }

    static String getTypeText(PsiType varType, PsiElement context) {
        StringBuilder builder = new StringBuilder();
        TypeWriter.writeType(builder, varType, context);
        return builder.toString();
    }

    static ArrayList<GrParameter> getActualParams(GrMethod constructor, int skipOptional) {
        GrParameter[] parameterList = constructor.getParameters();
        return GenerationUtil.getActualParams(parameterList, skipOptional);
    }

    public static ArrayList<GrParameter> getActualParams(GrParameter[] parameters, int skipOptional) {
        ArrayList<GrParameter> actual = new ArrayList<GrParameter>(Arrays.asList(parameters));
        if (skipOptional == 0) {
            return actual;
        }
        for (int i = parameters.length - 1; i >= 0; --i) {
            if (!actual.get(i).isOptional()) continue;
            actual.remove(i);
            if (--skipOptional == 0) break;
        }
        return actual;
    }

    public static void writeSimpleVarDeclaration(GrVariableDeclaration variableDeclaration, StringBuilder builder, ExpressionContext expressionContext) {
        GrVariable[] variables = variableDeclaration.getVariables();
        if (variables.length > 1 && variableDeclaration.getParent() instanceof GrControlStatement) {
            expressionContext.setInsertCurlyBrackets();
        }
        for (GrVariable variable : variables) {
            GenerationUtil.writeVariableSeparately(variable, builder, expressionContext);
            builder.append(";\n");
        }
        builder.delete(builder.length() - 1, builder.length());
    }

    static void writeVariableWithoutType(StringBuilder builder, ExpressionContext expressionContext, GrVariable variable, boolean wrapped, PsiType original) {
        builder.append(variable.getName());
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer != null) {
            builder.append(" = ");
            if (wrapped) {
                builder.append("new ").append("groovy.lang.Reference");
                if (original != null) {
                    builder.append('<');
                    TypeWriter.writeType(builder, original, variable, new GeneratorClassNameProvider());
                    builder.append('>');
                }
                builder.append('(');
            }
            PsiType iType = GenerationUtil.getDeclaredType(initializer, expressionContext);
            if (original != null && iType != null && !TypesUtil.isAssignable(original, iType, initializer)) {
                builder.append('(');
                TypeWriter.writeType(builder, original, initializer);
                builder.append(')');
            }
            initializer.accept(new ExpressionGenerator(builder, expressionContext));
            if (wrapped) {
                builder.append(')');
            }
        }
    }

    static void writeVariableSeparately(GrVariable variable, StringBuilder builder, ExpressionContext expressionContext) {
        PsiType type = expressionContext.typeProvider.getVarType(variable);
        ModifierListGenerator.writeModifiers(builder, variable.getModifierList());
        PsiType originalType = type;
        LocalVarAnalyzer.Result analyzedVars = expressionContext.analyzedVars;
        boolean wrapped = false;
        if (analyzedVars != null) {
            if (analyzedVars.toMakeFinal(variable) && !variable.hasModifierProperty("final")) {
                builder.append("final").append(' ');
            } else if (analyzedVars.toWrap(variable)) {
                builder.append("final").append(' ');
                type = JavaPsiFacade.getElementFactory((Project)expressionContext.project).createTypeFromText("groovy.lang.Reference<" + GenerationUtil.getTypeText(originalType, variable) + ">", (PsiElement)variable);
                wrapped = true;
            }
        }
        TypeWriter.writeType(builder, type, variable);
        builder.append(' ');
        GenerationUtil.writeVariableWithoutType(builder, expressionContext, variable, wrapped, originalType);
    }

    public static Pair<String, IElementType> getBinaryOperatorType(IElementType op_assign) {
        return binOpTypes.get(op_assign);
    }

    public static String suggestMethodName(GroovyPsiElement place, String initialName, ExpressionContext context) {
        int count = 0;
        String name = initialName;
        Class[] classes = new Class[]{PsiMethod.class};
        Map<PsiMethod, String> setters = context.getSetters();
        while (setters.containsValue(name) || ResolveUtil.resolveExistingElement(place, new MethodResolverProcessor(name, place, false, null, null, null, true), classes) != null) {
            name = initialName + count;
            ++count;
        }
        return name;
    }

    public static boolean isCastNeeded(@NotNull GrExpression qualifier, @NotNull PsiMember member, ExpressionContext context) {
        PsiType declared = GenerationUtil.getDeclaredType(qualifier, context);
        if (declared == null) {
            return false;
        }
        CheckProcessElement checker = new CheckProcessElement((PsiElement)member);
        ResolveUtil.processAllDeclarationsSeparately(declared, checker, (PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                return false;
            }
        }, ResolveState.initial(), qualifier);
        return !checker.isFound();
    }

    @Nullable
    public static PsiType getDeclaredType(@Nullable GrExpression expression, ExpressionContext context) {
        if (expression instanceof GrReferenceExpression) {
            GroovyResolveResult resolveResult = ((GrReferenceExpression)expression).advancedResolve();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            PsiElement resolved = resolveResult.getElement();
            if (resolved instanceof PsiVariable) {
                return substitutor.substitute(context.typeProvider.getVarType((PsiVariable)resolved));
            }
            if (resolved instanceof PsiMethod) {
                return GenerationUtil.getDeclaredType((PsiMethod)resolved, substitutor, context);
            }
        } else {
            if (expression instanceof GrMethodCall) {
                GrExpression invokedExpression = ((GrMethodCall)expression).getInvokedExpression();
                return GenerationUtil.getDeclaredType(invokedExpression, context);
            }
            if (expression instanceof GrBinaryExpression) {
                GroovyResolveResult result = PsiImplUtil.extractUniqueResult(((GrBinaryExpression)expression).multiResolve(false));
                if (result.getElement() instanceof PsiMethod) {
                    return GenerationUtil.getDeclaredType((PsiMethod)result.getElement(), result.getSubstitutor(), context);
                }
            } else if (expression instanceof GrIndexProperty) {
                GroovyResolveResult result = ((GrIndexProperty)expression).advancedResolve();
                if (result.getElement() instanceof PsiMethod) {
                    return GenerationUtil.getDeclaredType((PsiMethod)result.getElement(), result.getSubstitutor(), context);
                }
            } else {
                if (expression instanceof GrAssignmentExpression) {
                    return GenerationUtil.getDeclaredType(((GrAssignmentExpression)expression).getRValue(), context);
                }
                if (expression instanceof GrConditionalExpression) {
                    return TypesUtil.getLeastUpperBoundNullable(GenerationUtil.getDeclaredType(((GrConditionalExpression)expression).getThenBranch(), context), GenerationUtil.getDeclaredType(((GrConditionalExpression)expression).getElseBranch(), context), expression.getManager());
                }
                if (expression instanceof GrParenthesizedExpression) {
                    return GenerationUtil.getDeclaredType(((GrParenthesizedExpression)expression).getOperand(), context);
                }
                if (expression == null) {
                    return null;
                }
            }
        }
        return expression.getType();
    }

    public static PsiType getDeclaredType(PsiMethod method, PsiSubstitutor substitutor, ExpressionContext context) {
        if (method instanceof GrGdkMethod) {
            method = ((GrGdkMethod)method).getStaticMethod();
        }
        if (context.isClassConverted(method.getContainingClass())) {
            return substitutor.substitute(PsiUtil.getSmartReturnType(method));
        }
        return substitutor.substitute(method.getReturnType());
    }

    public static void wrapInCastIfNeeded(StringBuilder builder, @NotNull PsiType expected, @Nullable PsiType actual, GroovyPsiElement context, ExpressionContext expressionContext, StatementWriter writer) {
        if (actual != null && TypesUtil.isAssignable(expected, actual, context) || expected.equalsToText("java.lang.Object")) {
            writer.writeStatement(builder, expressionContext);
        } else {
            GenerationUtil.wrapInCast(builder, expected, context, expressionContext, writer);
        }
    }

    private static void wrapInCast(StringBuilder builder, @NotNull PsiType expected, PsiElement context, ExpressionContext expressionContext, StatementWriter writer) {
        builder.append("((");
        TypeWriter.writeType(builder, expected, context);
        builder.append(")(");
        writer.writeStatement(builder, expressionContext);
        builder.append("))");
    }

    static PsiType getNotNullType(PsiElement context, PsiType type) {
        return type != null ? type : TypesUtil.getJavaLangObject(context);
    }

    public static void writeThisReference(@Nullable PsiClass targetClass, StringBuilder buffer, ExpressionContext context) {
        if (targetClass != null && !(targetClass instanceof PsiAnonymousClass)) {
            GrCodeReferenceElement ref = GroovyPsiElementFactory.getInstance(context.project).createCodeReferenceElementFromClass(targetClass);
            GenerationUtil.writeCodeReferenceElement(buffer, ref);
            buffer.append('.');
        }
        buffer.append("this");
    }

    public static void writeSuperReference(@Nullable PsiClass targetClass, StringBuilder buffer, ExpressionContext context) {
        if (targetClass != null && !(targetClass instanceof PsiAnonymousClass)) {
            GrCodeReferenceElement ref = GroovyPsiElementFactory.getInstance(context.project).createCodeReferenceElementFromClass(targetClass);
            GenerationUtil.writeCodeReferenceElement(buffer, ref);
            buffer.append('.');
        }
        buffer.append("super");
    }

    @Nullable
    static PsiElement getWrappingImplicitClass(@NotNull PsiElement place) {
        for (PsiElement parent = place.getParent(); parent != null; parent = parent.getContext()) {
            if (parent instanceof PsiClass) {
                return null;
            }
            if (parent instanceof GroovyFile && !PsiUtil.isInDummyFile(parent)) {
                return null;
            }
            if (!(parent instanceof GrClosableBlock)) continue;
            return parent;
        }
        return null;
    }

    static void writeDocComment(StringBuilder buffer, PsiMember member, boolean addLineFeed) {
        PsiDocComment comment;
        if (member instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)member).getDocComment()) != null) {
            String text = comment.getText();
            buffer.append(text);
            if (addLineFeed) {
                buffer.append('\n');
            }
        }
    }

    static {
        binOpTypes.put(GroovyTokenTypes.mPLUS_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"+", (Object)GroovyTokenTypes.mPLUS));
        binOpTypes.put(GroovyTokenTypes.mMINUS_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"-", (Object)GroovyTokenTypes.mMINUS));
        binOpTypes.put(GroovyTokenTypes.mSTAR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"*", (Object)GroovyTokenTypes.mSTAR));
        binOpTypes.put(GroovyTokenTypes.mDIV_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"/", (Object)GroovyTokenTypes.mDIV));
        binOpTypes.put(GroovyTokenTypes.mMOD_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"%", (Object)GroovyTokenTypes.mMOD));
        binOpTypes.put(GroovyTokenTypes.mSL_ASSIGN, (Pair<String, IElementType>)new Pair((Object)"<<", (Object)GroovyElementTypes.COMPOSITE_LSHIFT_SIGN));
        binOpTypes.put(GroovyTokenTypes.mSR_ASSIGN, (Pair<String, IElementType>)new Pair((Object)">>", (Object)GroovyElementTypes.COMPOSITE_RSHIFT_SIGN));
        binOpTypes.put(GroovyTokenTypes.mBSR_ASSIGN, (Pair<String, IElementType>)new Pair((Object)">>>", (Object)GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN));
        binOpTypes.put(GroovyTokenTypes.mBAND_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"&", (Object)GroovyTokenTypes.mBAND));
        binOpTypes.put(GroovyTokenTypes.mBOR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"|", (Object)GroovyTokenTypes.mBOR));
        binOpTypes.put(GroovyTokenTypes.mBXOR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"^", (Object)GroovyTokenTypes.mBXOR));
        binOpTypes.put(GroovyTokenTypes.mSTAR_STAR_ASSIGN, (Pair<String, IElementType>)Pair.create((Object)"**", (Object)GroovyTokenTypes.mSTAR_STAR));
    }

    static class CheckProcessElement
    implements PsiScopeProcessor {
        private final PsiElement myMember;
        private final PsiManager myManager;
        private boolean myResult = false;

        public CheckProcessElement(@NotNull PsiElement member) {
            this.myMember = member;
            this.myManager = member.getManager();
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (this.myManager.areElementsEquivalent(element, this.myMember)) {
                this.myResult = true;
                return false;
            }
            return true;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            return null;
        }

        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        }

        public boolean isFound() {
            return this.myResult;
        }
    }
}

