/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.util;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcTargetDialogCompletionUtils {
    private static final String[] SYSTEM_PROPERTIES = new String[]{"ivy.default.ivy.user.dir", "ivy.default.conf.dir", "ivy.local.default.root", "ivy.local.default.ivy.pattern", "ivy.local.default.artifact.pattern", "ivy.shared.default.root", "ivy.shared.default.ivy.pattern", "ivy.shared.default.artifact.pattern", "ivy.ivyrep.default.ivy.root", "ivy.ivyrep.default.ivy.pattern", "ivy.ivyrep.default.artifact.root", "ivy.ivyrep.default.artifact.pattern"};
    private static final NotNullLazyValue<List<LookupElement>> SYSTEM_PROPERTIES_VARIANTS = new NotNullLazyValue<List<LookupElement>>(){

        @NotNull
        protected List<LookupElement> compute() {
            ArrayList result = ContainerUtil.newArrayList();
            for (String property : SYSTEM_PROPERTIES) {
                result.add(TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)("-D" + property)), (TailType)MyTailTypeEQ.INSTANCE));
            }
            return Collections.unmodifiableList(result);
        }
    };

    private MvcTargetDialogCompletionUtils() {
    }

    public static List<LookupElement> getSystemPropertiesVariants() {
        return (List)SYSTEM_PROPERTIES_VARIANTS.getValue();
    }

    public static Collection<LookupElement> collectVariants(@NotNull Module module, @NotNull String text, int offset, @NotNull String prefix) {
        if (prefix.startsWith("-D")) {
            return MvcTargetDialogCompletionUtils.getSystemPropertiesVariants();
        }
        if (text.substring(0, offset).matches("\\s*(grails\\s*)?(?:(:?-D\\S+|dev|prod|test)\\s+)*\\S*")) {
            ArrayList<LookupElement> res = new ArrayList<LookupElement>();
            for (String completionVariant : MvcTargetDialogCompletionUtils.getAllTargetNames(module)) {
                res.add((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)completionVariant), (TailType)TailType.SPACE));
            }
            return res;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module);
        return MvcTargetDialogCompletionUtils.completeClassesAndPackages(prefix, scope);
    }

    public static List<LookupElement> completeClassesAndPackages(@NotNull String prefix, @NotNull GlobalSearchScope scope) {
        PsiPackage defaultPackage;
        PsiPackage p;
        if (scope.getProject() == null) {
            return Collections.emptyList();
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)scope.getProject());
        ArrayList<LookupElement> res = new ArrayList<LookupElement>();
        if (prefix.endsWith(".") && prefix.length() > 1 && (p = facade.findPackage(prefix.substring(0, prefix.length() - 1))) != null) {
            for (PsiClass aClass : p.getClasses(scope)) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null) continue;
                res.add((LookupElement)LookupElementBuilder.create((Object)aClass, (String)qualifiedName));
            }
        }
        if ((defaultPackage = facade.findPackage("")) != null) {
            MvcTargetDialogCompletionUtils.collectClassesAndPackageNames(res, defaultPackage, scope);
        }
        return res;
    }

    private static void collectClassesAndPackageNames(Collection<LookupElement> res, @NotNull PsiPackage aPackage, GlobalSearchScope scope) {
        PsiPackage[] subPackages = aPackage.getSubPackages(scope);
        String qualifiedName = aPackage.getQualifiedName();
        if (!(qualifiedName.isEmpty() || subPackages.length != 0 && aPackage.getClasses(scope).length <= 0)) {
            res.add((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)qualifiedName), (TailType)TailType.DOT));
        }
        for (PsiPackage subPackage : subPackages) {
            MvcTargetDialogCompletionUtils.collectClassesAndPackageNames(res, subPackage, scope);
        }
    }

    public static Set<String> getAllTargetNamesInternal(@NotNull Module module) {
        HashSet<String> result = new HashSet<String>();
        MvcFramework.addAvailableSystemScripts(result, module);
        MvcFramework framework = MvcFramework.getInstance(module);
        if (framework != null) {
            VirtualFile root = framework.findAppRoot(module);
            if (root != null) {
                MvcFramework.addAvailableScripts(result, root);
            }
            for (VirtualFile pluginRoot : framework.getAllPluginRoots(module, false)) {
                MvcFramework.addAvailableScripts(result, pluginRoot);
            }
        }
        MvcTargetDialogCompletionUtils.collectScriptsFromUserHome(result);
        return result;
    }

    private static void collectScriptsFromUserHome(Set<String> result) {
        String userHome = SystemProperties.getUserHome();
        if (userHome == null) {
            return;
        }
        File scriptFolder = new File(userHome, ".grails/scripts");
        File[] files = scriptFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith("IdeaPrintProjectSettings") || !MvcTargetDialogCompletionUtils.isScriptFile(file)) continue;
            String name = file.getName();
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
            result.add(GroovyNamesUtil.camelToSnake(name));
        }
    }

    public static boolean isScriptFile(File file) {
        return file.isFile() && MvcFramework.isScriptFileName(file.getName());
    }

    public static Set<String> getAllTargetNames(@NotNull Module module) {
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(MvcTargetDialogCompletionUtils.getAllTargetNamesInternal(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static class MyTailTypeEQ
    extends TailType.TailTypeEQ {
        public static final MyTailTypeEQ INSTANCE = new MyTailTypeEQ();

        protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
            return false;
        }

        public String toString() {
            return "MvcTargetDialogCompletionUtils.TailTypeEQ";
        }
    }
}

