/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ParameterizedRunnable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;
import org.jetbrains.plugins.groovy.mvc.MvcActionBase;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;

public class MvcUpgradeAction
extends MvcActionBase {
    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Module module, final @NotNull MvcFramework framework) {
        GroovyLibraryDescription description = framework.createLibraryDescription();
        AddCustomLibraryDialog dialog = AddCustomLibraryDialog.createDialog((CustomLibraryDescription)description, (Module)module, (ParameterizedRunnable)new ParameterizedRunnable<ModifiableRootModel>(){

            public void run(ModifiableRootModel modifiableRootModel) {
                MvcUpgradeAction.removeOldMvcSdk(framework, modifiableRootModel);
            }
        });
        dialog.setTitle("Change " + framework.getDisplayName() + " SDK version");
        if (dialog.showAndGet()) {
            module.putUserData(MvcFramework.UPGRADE, (Object)Boolean.TRUE);
            module.putUserData(MvcModuleStructureUtil.LAST_MVC_VERSION, null);
        }
    }

    public static void removeOldMvcSdk(MvcFramework framework, ModifiableRootModel model) {
        LibraryPresentationManager presentationManager = LibraryPresentationManager.getInstance();
        for (OrderEntry entry : model.getOrderEntries()) {
            VirtualFile[] files;
            if (!(entry instanceof LibraryOrderEntry)) continue;
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            LibrariesContainer container = LibrariesContainerFactory.createContainer((ModifiableRootModel)model);
            if (library == null || !presentationManager.isLibraryOfKind(Arrays.asList(files = container.getLibraryFiles(library, OrderRootType.CLASSES)), framework.getLibraryKind())) continue;
            model.removeOrderEntry(entry);
        }
    }

    @Override
    protected void updateView(AnActionEvent event, @NotNull MvcFramework framework, @NotNull Module module) {
        event.getPresentation().setEnabledAndVisible(framework.isUpgradeActionSupported(module));
        event.getPresentation().setIcon(framework.getIcon());
    }
}

