/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class AccessorResolverProcessor
extends MethodResolverProcessor {
    private final String myPropertyName;
    private final boolean mySearchForGetter;
    private final SubstitutorComputer mySubstitutorComputer;

    public AccessorResolverProcessor(@Nullable String accessorName, @NotNull String propertyName, @NotNull PsiElement place, boolean searchForGetter) {
        this(accessorName, propertyName, place, searchForGetter, null, PsiType.EMPTY_ARRAY);
    }

    public AccessorResolverProcessor(@Nullable String accessorName, @NotNull String propertyName, @NotNull PsiElement place, boolean searchForGetter, @Nullable PsiType thisType, @NotNull PsiType[] typeArguments) {
        super(accessorName, place, false, thisType, null, typeArguments, false);
        this.myPropertyName = propertyName;
        this.mySearchForGetter = searchForGetter;
        this.mySubstitutorComputer = new SubstitutorComputer(thisType, PsiType.EMPTY_ARRAY, typeArguments, place, this.myPlace);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        return !AccessorResolverProcessor.checkAccessor(element, state, this.myPropertyName, this.mySearchForGetter) || this.addAccessor((PsiMethod)element, state);
    }

    static boolean checkAccessor(@NotNull PsiElement element, @NotNull ResolveState state, @NotNull String myPropertyName, boolean mySearchForGetter) {
        String importedName;
        PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        String string = importedName = resolveContext instanceof GrImportStatement ? ((GrImportStatement)resolveContext).getImportedName() : null;
        return mySearchForGetter ? element instanceof PsiMethod && (importedName != null && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForGetter((PsiMethod)element, importedName, myPropertyName) || myPropertyName.equals(importedName)) || importedName == null && GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, myPropertyName)) : element instanceof PsiMethod && (importedName != null && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForSetter(importedName, myPropertyName) || myPropertyName.equals(importedName)) || importedName == null && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, myPropertyName));
    }

    public static boolean isAppropriatePropertyNameForSetter(@NotNull String importedName, @NotNull String propertyName) {
        propertyName = GroovyPropertyUtils.decapitalize(propertyName);
        return propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(importedName));
    }

    public static boolean isAppropriatePropertyNameForGetter(@NotNull PsiMethod getter, @NotNull String importedNameForGetter, @NotNull String propertyName) {
        propertyName = GroovyPropertyUtils.decapitalize(propertyName);
        return propertyName.equals(AccessorResolverProcessor.getPropertyNameByGetter(getter, importedNameForGetter));
    }

    @Nullable
    private static String getPropertyNameByGetter(PsiMethod element, String importedName) {
        return GroovyPropertyUtils.getPropertyNameByGetterName(importedName, AccessorResolverProcessor.isBoolean(element));
    }

    private static boolean isBoolean(PsiMethod method) {
        return PsiType.BOOLEAN.equals((Object)method.getReturnType());
    }

    private boolean addAccessor(PsiMethod method, ResolveState state) {
        PsiSubstitutor substitutor = AccessorResolverProcessor.getSubstitutor(state);
        PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        NotNullComputable substitutorComputer = () -> this.mySubstitutorComputer.obtainSubstitutor(substitutor, method, resolveContext);
        boolean isAccessible = this.isAccessible((PsiNamedElement)method);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method, resolveContext, false);
        GroovyMethodResult candidate = new GroovyMethodResult(method, resolveContext, spreadState, substitutor, (NotNullComputable<PsiSubstitutor>)substitutorComputer, isAccessible, isStaticsOK);
        if (isAccessible && isStaticsOK) {
            this.addCandidate(candidate);
            return method instanceof GrGdkMethod;
        }
        this.addInapplicableCandidate(candidate);
        return true;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        boolean hasApplicableCandidates = this.hasApplicableCandidates();
        GroovyResolveResult[] candidates = super.getCandidates();
        if (hasApplicableCandidates) {
            if (candidates.length <= 1) {
                return candidates;
            }
            return new GroovyResolveResult[]{candidates[0]};
        }
        return candidates;
    }
}

