/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PropertyUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.Members;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy.DefaultBuilderStrategySupport;

public class ExternalBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String EXTERNAL_STRATEGY_NAME = "ExternalStrategy";

    @Override
    public void collectMethods(@NotNull GrTypeDefinition clazz, Collection<PsiMethod> collector) {
        collector.addAll(this.collect(clazz).getMethods());
    }

    @NotNull
    public Members collect(@NotNull GrTypeDefinition builderClass) {
        Pair<PsiAnnotation, PsiClass> definitionPair = ExternalBuilderStrategySupport.getConstructedClassPair(builderClass);
        if (definitionPair == null) {
            return Members.EMPTY;
        }
        PsiAnnotation annotation = (PsiAnnotation)definitionPair.first;
        PsiClass constructedClass = (PsiClass)definitionPair.second;
        Members result = Members.create();
        if (constructedClass instanceof GrTypeDefinition) {
            for (GrField field : ((GrTypeDefinition)constructedClass).getCodeFields()) {
                result.getMethods().add((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter(builderClass, field, annotation));
            }
        } else {
            for (PsiMethod setter : PropertyUtil.getAllProperties((PsiClass)constructedClass, (boolean)true, (boolean)false).values()) {
                LightMethodBuilder builderSetter = ExternalBuilderStrategySupport.createFieldSetter(builderClass, setter, annotation);
                if (builderSetter == null) continue;
                result.getMethods().add((PsiMethod)builderSetter);
            }
        }
        result.getMethods().add((PsiMethod)DefaultBuilderStrategySupport.createBuildMethod(annotation, ExternalBuilderStrategySupport.createType(constructedClass), builderClass));
        return result;
    }

    private static Pair<PsiAnnotation, PsiClass> getConstructedClassPair(GrTypeDefinition builderClass) {
        PsiAnnotation annotation = PsiImplUtil.getAnnotation((PsiModifierListOwner)builderClass, "groovy.transform.builder.Builder");
        if (!ExternalBuilderStrategySupport.isApplicable(annotation, EXTERNAL_STRATEGY_NAME)) {
            return null;
        }
        PsiClass constructedClass = ExternalBuilderStrategySupport.getClassAttributeValue(annotation, "forClass");
        if (constructedClass == null) {
            return null;
        }
        return Pair.create((Object)annotation, (Object)constructedClass);
    }

    @Nullable
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull PsiMethod setter, @NotNull PsiAnnotation annotation) {
        String name = PropertyUtil.getPropertyNameBySetter((PsiMethod)setter);
        PsiType type = PropertyUtil.getPropertyType((PsiMember)setter);
        if (type == null) {
            return null;
        }
        return DefaultBuilderStrategySupport.createFieldSetter(builderClass, name, type, annotation, (PsiElement)setter);
    }
}

