/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightPsiClassBuilder;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.Members;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderHelperLightPsiClass;

public class DefaultBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String DEFAULT_STRATEGY_NAME = "DefaultStrategy";

    @Override
    public void collectClasses(@NotNull GrTypeDefinition clazz, Collection<PsiClass> collector) {
        collector.addAll(this.collect(clazz).getClasses());
    }

    @Override
    public void collectMethods(@NotNull GrTypeDefinition clazz, Collection<PsiMethod> collector) {
        collector.addAll(this.collect(clazz).getMethods());
    }

    @NotNull
    public Members collect(@NotNull GrTypeDefinition typeDefinition) {
        return new DefaultBuilderStrategyHandler(typeDefinition).doProcess();
    }

    @NotNull
    public static String getBuilderClassName(@NotNull PsiAnnotation annotation, @NotNull GrTypeDefinition clazz) {
        String builderClassName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderClassName");
        return builderClassName == null ? String.format("%s%s", clazz.getName(), "Builder") : builderClassName;
    }

    @NotNull
    public static LightMethodBuilder createBuildMethod(@NotNull PsiAnnotation annotation, @NotNull PsiType builtType, PsiClass builderClass) {
        LightMethodBuilder buildMethod = new LightMethodBuilder(annotation.getManager(), DefaultBuilderStrategySupport.getBuildMethodName(annotation));
        buildMethod.setContainingClass(builderClass);
        buildMethod.setOriginInfo("via @Builder");
        buildMethod.setMethodReturnType(builtType);
        return buildMethod;
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull GrVariable field, @NotNull PsiAnnotation annotation) {
        return DefaultBuilderStrategySupport.createFieldSetter(builderClass, field.getName(), field.getType(), annotation, field);
    }

    @NotNull
    public static LightMethodBuilder createFieldSetter(@NotNull PsiClass builderClass, @NotNull String name, @NotNull PsiType type, @NotNull PsiAnnotation annotation, @NotNull PsiElement navigationElement) {
        LightMethodBuilder fieldSetter = new LightMethodBuilder(builderClass.getManager(), DefaultBuilderStrategySupport.getFieldMethodName(annotation, name));
        fieldSetter.addModifier("public");
        fieldSetter.addParameter(name, type);
        fieldSetter.setContainingClass(builderClass);
        fieldSetter.setMethodReturnType((PsiType)JavaPsiFacade.getElementFactory((Project)builderClass.getProject()).createType(builderClass));
        fieldSetter.setNavigationElement(navigationElement);
        fieldSetter.setOriginInfo("via @Builder");
        return fieldSetter;
    }

    @NotNull
    public static String getFieldMethodName(@NotNull PsiAnnotation annotation, @NotNull String fieldName) {
        String prefix = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"prefix");
        return StringUtil.isEmpty((String)prefix) ? fieldName : String.format("%s%s", prefix, StringUtil.capitalize((String)fieldName));
    }

    @NotNull
    private static String getBuildMethodName(@NotNull PsiAnnotation annotation) {
        String buildMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"buildMethodName");
        return StringUtil.isEmpty((String)buildMethodName) ? "build" : buildMethodName;
    }

    private static class DefaultBuilderStrategyHandler {
        @NotNull
        private final GrTypeDefinition myContainingClass;
        @NotNull
        private final PsiElementFactory myElementFactory;
        private final Members myMembers;

        private DefaultBuilderStrategyHandler(@NotNull GrTypeDefinition typeDefinition) {
            this.myContainingClass = typeDefinition;
            this.myElementFactory = PsiElementFactory.SERVICE.getInstance((Project)typeDefinition.getProject());
            this.myMembers = Members.create();
        }

        @NotNull
        private PsiManager getManager() {
            return this.myContainingClass.getManager();
        }

        @NotNull
        public Members doProcess() {
            this.processTypeDefinition();
            this.processMethods();
            return this.myMembers;
        }

        private void processTypeDefinition() {
            PsiAnnotation builderAnno = PsiImplUtil.getAnnotation((PsiModifierListOwner)this.myContainingClass, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(builderAnno, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            LightPsiClassBuilder builderClass = this.createBuilderClass(builderAnno, this.myContainingClass.getCodeFields());
            this.myMembers.getMethods().add((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, builderAnno));
            this.myMembers.getClasses().add((PsiClass)builderClass);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters) {
            return this.createBuilderClass(annotation, setters, null);
        }

        @NotNull
        private LightPsiClassBuilder createBuilderClass(@NotNull PsiAnnotation annotation, @NotNull GrVariable[] setters, @Nullable PsiType builtType) {
            BuilderHelperLightPsiClass builderClass = new BuilderHelperLightPsiClass(this.myContainingClass, DefaultBuilderStrategySupport.getBuilderClassName(annotation, this.myContainingClass));
            for (GrVariable field : setters) {
                builderClass.addMethod((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter((PsiClass)builderClass, field, annotation));
            }
            LightMethodBuilder buildMethod = DefaultBuilderStrategySupport.createBuildMethod(annotation, (PsiType)(builtType == null ? this.myElementFactory.createType((PsiClass)this.myContainingClass) : builtType), (PsiClass)builderClass);
            return builderClass.addMethod((PsiMethod)buildMethod);
        }

        @NotNull
        private LightMethodBuilder createBuilderMethod(@NotNull PsiClass builderClass, @NotNull PsiAnnotation annotation) {
            LightMethodBuilder builderMethod = new LightMethodBuilder(this.getManager(), DefaultBuilderStrategyHandler.getBuilderMethodName(annotation));
            builderMethod.addModifier("static");
            builderMethod.setContainingClass((PsiClass)this.myContainingClass);
            builderMethod.setOriginInfo("via @Builder");
            builderMethod.setNavigationElement((PsiElement)annotation);
            builderMethod.setMethodReturnType((PsiType)this.myElementFactory.createType(builderClass));
            return builderMethod;
        }

        private void processMethods() {
            for (GrMethod method : this.myContainingClass.getCodeMethods()) {
                this.processMethod(method);
            }
        }

        private void processMethod(@NotNull GrMethod method) {
            PsiAnnotation annotation = PsiImplUtil.getAnnotation(method, "groovy.transform.builder.Builder");
            if (!BuilderAnnotationContributor.isApplicable(annotation, DefaultBuilderStrategySupport.DEFAULT_STRATEGY_NAME)) {
                return;
            }
            if (method.isConstructor()) {
                this.processConstructor(method, annotation);
            } else if (method.hasModifierProperty("static")) {
                this.processFactoryMethod(method, annotation);
            }
        }

        private void processConstructor(@NotNull GrMethod method, PsiAnnotation annotation) {
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters());
            this.myMembers.getMethods().add((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myMembers.getClasses().add((PsiClass)builderClass);
        }

        private void processFactoryMethod(@NotNull GrMethod method, PsiAnnotation annotation) {
            LightPsiClassBuilder builderClass = this.createBuilderClass(annotation, method.getParameters(), method.getReturnType());
            this.myMembers.getMethods().add((PsiMethod)this.createBuilderMethod((PsiClass)builderClass, annotation));
            this.myMembers.getClasses().add((PsiClass)builderClass);
        }

        @NotNull
        private static String getBuilderMethodName(@NotNull PsiAnnotation annotation) {
            String builderMethodName = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)"builderMethodName");
            return StringUtil.isEmpty((String)builderMethodName) ? "builder" : builderMethodName;
        }
    }
}

