/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;

public abstract class BuilderAnnotationContributor
extends AstTransformContributor {
    public static final String BUILDER_PACKAGE = "groovy.transform.builder";
    public static final String BUILDER_FQN = "groovy.transform.builder.Builder";
    public static final String ORIGIN_INFO = "via @Builder";
    public static final String STRATEGY_ATTRIBUTE = "builderStrategy";

    @Nullable
    @Contract(value="null,_ -> null")
    public static PsiClass getClassAttributeValue(@Nullable PsiAnnotation annotation, @NotNull String attributeName) {
        if (annotation == null) {
            return null;
        }
        PsiAnnotationMemberValue value = annotation.findAttributeValue(attributeName);
        if (value instanceof GrReferenceExpression) {
            PsiElement element = ((GrReferenceExpression)value).resolve();
            return element instanceof PsiClass ? (PsiClass)element : null;
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isApplicable(@Nullable PsiAnnotation annotation, @NotNull String strategy) {
        if (annotation == null) {
            return false;
        }
        PsiAnnotationMemberValue attributeValue = annotation.findDeclaredAttributeValue(STRATEGY_ATTRIBUTE);
        if (attributeValue == null) {
            return strategy == "DefaultStrategy";
        }
        String value = attributeValue.getText();
        return strategy.equals(value) || StringUtil.getQualifiedName((String)BUILDER_PACKAGE, (String)strategy).equals(value);
    }

    public static PsiType createType(PsiClass clazz) {
        return JavaPsiFacade.getElementFactory((Project)clazz.getProject()).createType(clazz);
    }
}

