/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class GroovyTraitMethodsFileIndex
extends SingleEntryFileBasedIndexExtension<PsiJavaFileStub>
implements DataExternalizer<PsiJavaFileStub> {
    public static final ID<Integer, PsiJavaFileStub> INDEX_ID = ID.create((String)"groovy.trait.methods");
    public static final String HELPER_SUFFIX = "$Trait$Helper.class";
    private static final Logger LOG = Logger.getInstance(GroovyTraitMethodsFileIndex.class);
    private final FileBasedIndex.InputFilter myFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

        public boolean acceptInput(@NotNull VirtualFile file) {
            return StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)GroovyTraitMethodsFileIndex.HELPER_SUFFIX);
        }
    };
    private final SingleEntryIndexer<PsiJavaFileStub> myIndexer = new SingleEntryIndexer<PsiJavaFileStub>(true){

        protected PsiJavaFileStub computeValue(@NotNull FileContent inputData) {
            return GroovyTraitMethodsFileIndex.index(inputData.getFile(), inputData.getContent());
        }
    };
    private final SerializationManagerEx mySerializer;

    public GroovyTraitMethodsFileIndex(@NotNull SerializationManagerEx serializer) {
        this.mySerializer = serializer;
    }

    @NotNull
    public ID<Integer, PsiJavaFileStub> getName() {
        return INDEX_ID;
    }

    public int getVersion() {
        return 13;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myFilter;
    }

    @NotNull
    public SingleEntryIndexer<PsiJavaFileStub> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public DataExternalizer<PsiJavaFileStub> getValueExternalizer() {
        return this;
    }

    private static PsiJavaFileStub index(VirtualFile file, byte[] content) {
        try {
            PsiJavaFileStubImpl root = new PsiJavaFileStubImpl("", true);
            new ClassReader(content).accept((ClassVisitor)new GrTraitMethodVisitor(file, (StubElement)root), ClsFileImpl.EMPTY_ATTRIBUTES, 1);
            return root;
        }
        catch (Exception e) {
            LOG.info(file.getPath(), (Throwable)e);
            return null;
        }
    }

    public void save(@NotNull DataOutput out, PsiJavaFileStub value) throws IOException {
        BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream();
        this.mySerializer.serialize((Stub)value, (OutputStream)buffer);
        out.writeInt(buffer.size());
        out.write(buffer.getInternalBuffer(), 0, buffer.size());
    }

    public PsiJavaFileStub read(@NotNull DataInput in) throws IOException {
        try {
            byte[] buffer = new byte[in.readInt()];
            in.readFully(buffer);
            return (PsiJavaFileStub)this.mySerializer.deserialize((InputStream)new ByteArrayInputStream(buffer));
        }
        catch (SerializerNotFoundException e) {
            throw new IOException(e);
        }
    }

    private static class GrTraitMethodVisitor
    extends StubBuildingVisitor<VirtualFile> {
        public GrTraitMethodVisitor(VirtualFile file, StubElement root) {
            super((Object)file, null, root, 0, null);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, "gr_trait_helper", null, null, null);
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Nullable
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Nullable
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Type[] args;
            if ((access & 0x1000) == 0 && (access & 8) != 0 && name != null && (args = Type.getArgumentTypes((String)desc)).length > 0 && args[0].getSort() == 10 && "java.lang.Class".equals(args[0].getClassName())) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            return null;
        }
    }
}

