/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class GroovyTraitFieldsFileIndex
extends SingleEntryFileBasedIndexExtension<Collection<TraitFieldDescriptor>>
implements DataExternalizer<Collection<TraitFieldDescriptor>> {
    public static final ID<Integer, Collection<TraitFieldDescriptor>> INDEX_ID = ID.create((String)"groovy.trait.fields");
    public static final String HELPER_SUFFIX = "$Trait$FieldHelper.class";
    private static final FileBasedIndex.InputFilter FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

        public boolean acceptInput(@NotNull VirtualFile file) {
            return StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)GroovyTraitFieldsFileIndex.HELPER_SUFFIX);
        }
    };
    private static final SingleEntryIndexer<Collection<TraitFieldDescriptor>> INDEXER = new SingleEntryIndexer<Collection<TraitFieldDescriptor>>(true){

        protected Collection<TraitFieldDescriptor> computeValue(@NotNull FileContent inputData) {
            return GroovyTraitFieldsFileIndex.index(inputData);
        }
    };
    private static final String INSTANCE_PREFIX = "$ins";
    private static final String STATIC_PREFIX = "$static";
    private static final String PRIVATE_PREFIX = "$0";
    private static final String PUBLIC_PREFIX = "$1";
    private static final String DELIMITER = "__";

    @NotNull
    public ID<Integer, Collection<TraitFieldDescriptor>> getName() {
        return INDEX_ID;
    }

    @NotNull
    public SingleEntryIndexer<Collection<TraitFieldDescriptor>> getIndexer() {
        return INDEXER;
    }

    @NotNull
    public DataExternalizer<Collection<TraitFieldDescriptor>> getValueExternalizer() {
        return this;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return FILTER;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 3;
    }

    private static Collection<TraitFieldDescriptor> index(FileContent inputData) {
        final ArrayList values = ContainerUtil.newArrayList();
        new ClassReader(inputData.getContent()).accept(new ClassVisitor(327680){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                this.processField(access, name, desc, signature);
                return null;
            }

            private void processField(int access, String name, String desc, String signature) {
                if ((access & 0x1000) == 0) {
                    return;
                }
                Pair<Boolean, String> p = this.parse(GroovyTraitFieldsFileIndex.STATIC_PREFIX, GroovyTraitFieldsFileIndex.INSTANCE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isStatic = (Boolean)p.first;
                name = (String)p.second;
                p = this.parse(GroovyTraitFieldsFileIndex.PUBLIC_PREFIX, GroovyTraitFieldsFileIndex.PRIVATE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isPublic = (Boolean)p.first;
                name = (String)p.second;
                String typeString = this.fieldType(desc, signature);
                if (typeString == null) {
                    return;
                }
                int delimiter = name.indexOf(GroovyTraitFieldsFileIndex.DELIMITER);
                if (delimiter > -1) {
                    name = name.substring(delimiter + GroovyTraitFieldsFileIndex.DELIMITER.length());
                }
                byte flags = (byte)((isPublic ? 1 : 0) | (isStatic ? 2 : 0));
                values.add(new TraitFieldDescriptor(flags, typeString, name));
            }

            private Pair<Boolean, String> parse(String prefix, String prefix2, String input) {
                if (input.startsWith(prefix)) {
                    return Pair.create((Object)true, (Object)input.substring(prefix.length()));
                }
                if (input.startsWith(prefix2)) {
                    return Pair.create((Object)false, (Object)input.substring(prefix2.length()));
                }
                return Pair.create(null, (Object)input);
            }

            private String fieldType(String desc, String signature) {
                if (signature != null) {
                    try {
                        return SignatureParsing.parseTypeString((CharacterIterator)new StringCharacterIterator(signature), (Function)StubBuildingVisitor.GUESSING_MAPPER);
                    }
                    catch (ClsFormatException clsFormatException) {
                        // empty catch block
                    }
                }
                String raw = Type.getType((String)desc).getClassName();
                return (String)StubBuildingVisitor.GUESSING_MAPPER.fun((Object)raw);
            }
        }, ClsFileImpl.EMPTY_ATTRIBUTES, 1);
        return values;
    }

    public void save(@NotNull DataOutput out, Collection<TraitFieldDescriptor> values) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)values.size());
        for (TraitFieldDescriptor descriptor : values) {
            out.writeByte(descriptor.flags);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor.typeString);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor.name);
        }
    }

    public Collection<TraitFieldDescriptor> read(@NotNull DataInput in) throws IOException {
        int size = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            result.add(new TraitFieldDescriptor(in.readByte(), IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in)));
        }
        return result;
    }

    public static class TraitFieldDescriptor {
        public static final byte PUBLIC = 1;
        public static final byte STATIC = 2;
        public final byte flags;
        public final String typeString;
        public final String name;

        private TraitFieldDescriptor(byte flags, @NotNull String typeString, @NotNull String name) {
            this.flags = flags;
            this.typeString = typeString;
            this.name = name;
        }
    }
}

