/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;

public class GroovyPropertyUtils {
    private static final Logger LOG = Logger.getInstance(GroovyPropertyUtils.class);
    public static final String IS_PREFIX = "is";
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";

    private GroovyPropertyUtils() {
    }

    public static PsiMethod[] getAllSettersByField(PsiField field) {
        return GroovyPropertyUtils.getAllSetters(field.getContainingClass(), field.getName(), field.hasModifierProperty("static"), false);
    }

    @NotNull
    public static PsiMethod[] getAllGettersByField(PsiField field) {
        return GroovyPropertyUtils.getAllGetters(field.getContainingClass(), field.getName(), field.hasModifierProperty("static"), false);
    }

    @Nullable
    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        return GroovyPropertyUtils.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        return GroovyPropertyUtils.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiMethod findPropertySetter(@Nullable PsiType type, String propertyName, @NotNull GroovyPsiElement context) {
        String setterName = GroovyPropertyUtils.getSetterName(propertyName);
        if (type == null) {
            GrExpression fromText = GroovyPsiElementFactory.getInstance(context.getProject()).createExpressionFromText("this", context);
            return GroovyPropertyUtils.findPropertySetter(fromText.getType(), propertyName, context);
        }
        AccessorResolverProcessor processor = new AccessorResolverProcessor(setterName, propertyName, context, false);
        ResolveUtil.processAllDeclarations(type, processor, ResolveState.initial(), context);
        GroovyResolveResult[] setterCandidates = processor.getCandidates();
        return PsiImplUtil.extractUniqueElement(setterCandidates);
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertySetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetter(method))) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public static PsiMethod[] getAllGetters(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertyGetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetter(method))) continue;
            result.add(method);
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    @NotNull
    public static PsiMethod[] getAllSetters(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !GroovyPropertyUtils.isSimplePropertySetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetter(method))) continue;
            result.add(method);
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    @Nullable
    public static PsiMethod findPropertyGetter(@Nullable PsiClass aClass, String propertyName, @Nullable Boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (isStatic != null && method.hasModifierProperty("static") != isStatic.booleanValue() || !GroovyPropertyUtils.isSimplePropertyGetter(method) || !propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetter(method))) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertyGetter(method) || GroovyPropertyUtils.isSimplePropertySetter(method);
    }

    public static boolean isSimplePropertyGetter(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertyGetter(method, null);
    }

    public static boolean isSimplePropertyGetter(PsiMethod method, @Nullable String propertyName) {
        if (method == null || method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 0) {
            return false;
        }
        if (!GroovyPropertyUtils.isGetterName(method.getName())) {
            return false;
        }
        if (method.getName().startsWith(IS_PREFIX) && !PsiType.BOOLEAN.equals((Object)method.getReturnType())) {
            return false;
        }
        if (PsiType.VOID.equals((Object)method.getReturnType())) {
            return false;
        }
        if (propertyName == null) {
            return true;
        }
        String byGetter = GroovyPropertyUtils.getPropertyNameByGetter(method);
        return propertyName.equals(byGetter) || !GroovyPropertyUtils.isPropertyName(byGetter) && propertyName.equals(GroovyPropertyUtils.getPropertyNameByGetterName(method.getName(), PsiType.BOOLEAN.equals((Object)method.getReturnType())));
    }

    public static boolean isSimplePropertySetter(PsiMethod method) {
        return GroovyPropertyUtils.isSimplePropertySetter(method, null);
    }

    public static boolean isSimplePropertySetter(PsiMethod method, @Nullable String propertyName) {
        if (method == null || method.isConstructor()) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        if (!GroovyPropertyUtils.isSetterName(method.getName())) {
            return false;
        }
        if (propertyName == null) {
            return true;
        }
        String bySetter = GroovyPropertyUtils.getPropertyNameBySetter(method);
        return propertyName.equals(bySetter) || !GroovyPropertyUtils.isPropertyName(bySetter) && propertyName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(method.getName()));
    }

    @Nullable
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        if (getterMethod instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)getterMethod).getProperty().getName();
        }
        String methodName = getterMethod.getName();
        boolean isPropertyBoolean = PsiType.BOOLEAN.equals((Object)getterMethod.getReturnType());
        return GroovyPropertyUtils.getPropertyNameByGetterName(methodName, isPropertyBoolean);
    }

    @Nullable
    public static String getPropertyNameByGetterName(@NotNull String methodName, boolean canBeBoolean) {
        if (methodName.startsWith(GET_PREFIX) && methodName.length() > 3) {
            return GroovyPropertyUtils.decapitalize(methodName.substring(3));
        }
        if (canBeBoolean && methodName.startsWith(IS_PREFIX) && methodName.length() > 2) {
            return GroovyPropertyUtils.decapitalize(methodName.substring(2));
        }
        return null;
    }

    @Nullable
    public static String getPropertyNameBySetter(PsiMethod setterMethod) {
        if (setterMethod instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)setterMethod).getProperty().getName();
        }
        String methodName = setterMethod.getName();
        return GroovyPropertyUtils.getPropertyNameBySetterName(methodName);
    }

    @Nullable
    public static String getPropertyNameBySetterName(@NotNull String methodName) {
        if (methodName.startsWith(SET_PREFIX) && methodName.length() > 3) {
            return StringUtil.decapitalize((String)methodName.substring(3));
        }
        return null;
    }

    @Nullable
    public static String getPropertyNameByAccessorName(String accessorName) {
        if (GroovyPropertyUtils.isGetterName(accessorName)) {
            return GroovyPropertyUtils.getPropertyNameByGetterName(accessorName, true);
        }
        if (GroovyPropertyUtils.isSetterName(accessorName)) {
            return GroovyPropertyUtils.getPropertyNameBySetterName(accessorName);
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(PsiMethod accessor) {
        if (GroovyPropertyUtils.isSimplePropertyGetter(accessor)) {
            return GroovyPropertyUtils.getPropertyNameByGetter(accessor);
        }
        if (GroovyPropertyUtils.isSimplePropertySetter(accessor)) {
            return GroovyPropertyUtils.getPropertyNameBySetter(accessor);
        }
        return null;
    }

    public static boolean isGetterName(@NotNull String name) {
        int prefixLength;
        if (name.startsWith(GET_PREFIX)) {
            prefixLength = 3;
        } else if (name.startsWith(IS_PREFIX)) {
            prefixLength = 2;
        } else {
            return false;
        }
        if (name.length() == prefixLength) {
            return false;
        }
        if (GroovyPropertyUtils.isUpperCase(name.charAt(prefixLength))) {
            return true;
        }
        return name.length() > prefixLength + 1 && GroovyPropertyUtils.isUpperCase(name.charAt(prefixLength + 1));
    }

    public static String getGetterNameNonBoolean(@NotNull String name) {
        return GroovyPropertyUtils.getAccessorName(GET_PREFIX, name);
    }

    public static String getGetterNameBoolean(@NotNull String name) {
        return GroovyPropertyUtils.getAccessorName(IS_PREFIX, name);
    }

    public static String getSetterName(@NotNull String name) {
        return GroovyPropertyUtils.getAccessorName(SET_PREFIX, name);
    }

    public static String getAccessorName(String prefix, String name) {
        if (name.isEmpty()) {
            return prefix;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            sb.append(name);
        } else {
            sb.append(Character.toUpperCase(name.charAt(0)));
            sb.append(name, 1, name.length());
        }
        return sb.toString();
    }

    public static String[] suggestGettersName(@NotNull String name) {
        return new String[]{GroovyPropertyUtils.getGetterNameBoolean(name), GroovyPropertyUtils.getGetterNameNonBoolean(name)};
    }

    public static boolean isPropertyName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        return !Character.isUpperCase(name.charAt(0)) || name.length() != 1 && Character.isUpperCase(name.charAt(1));
    }

    public static String[] suggestSettersName(@NotNull String name) {
        return new String[]{GroovyPropertyUtils.getSetterName(name)};
    }

    public static boolean isSetterName(String name) {
        return name != null && name.startsWith(SET_PREFIX) && name.length() > 3 && (GroovyPropertyUtils.isUpperCase(name.charAt(3)) || name.length() > 4 && GroovyPropertyUtils.isUpperCase(name.charAt(3)));
    }

    public static boolean isProperty(@Nullable PsiClass aClass, @Nullable String propertyName, boolean isStatic) {
        if (aClass == null || propertyName == null) {
            return false;
        }
        PsiField field = aClass.findFieldByName(propertyName, true);
        if (field instanceof GrField && ((GrField)field).isProperty() && field.hasModifierProperty("static") == isStatic) {
            return true;
        }
        PsiMethod getter = GroovyPropertyUtils.findPropertyGetter(aClass, propertyName, isStatic, true);
        if (getter != null && getter.hasModifierProperty("public")) {
            return true;
        }
        PsiMethod setter = GroovyPropertyUtils.findPropertySetter(aClass, propertyName, isStatic, true);
        return setter != null && setter.hasModifierProperty("public");
    }

    public static boolean isProperty(GrField field) {
        PsiClass clazz = field.getContainingClass();
        return GroovyPropertyUtils.isProperty(clazz, field.getName(), field.hasModifierProperty("static"));
    }

    private static boolean isUpperCase(char c) {
        return Character.toUpperCase(c) == c;
    }

    public static String capitalize(String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        if (Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @Nullable
    public static PsiField findFieldForAccessor(PsiMethod accessor, boolean checkSuperClasses) {
        PsiClass psiClass = accessor.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiField field = null;
        if (!checkSuperClasses) {
            field = psiClass.findFieldByName(GroovyPropertyUtils.getPropertyNameByAccessorName(accessor.getName()), true);
        } else {
            PsiField[] allFields;
            String name = GroovyPropertyUtils.getPropertyNameByAccessorName(accessor.getName());
            assert (name != null);
            for (PsiField psiField : allFields = psiClass.getAllFields()) {
                if (!name.equals(psiField.getName())) continue;
                field = psiField;
                break;
            }
        }
        if (field == null) {
            return null;
        }
        if (field.hasModifierProperty("static") == accessor.hasModifierProperty("static")) {
            return field;
        }
        return null;
    }

    @Nullable
    public static String getGetterPrefix(PsiMethod getter) {
        String name = getter.getName();
        if (name.startsWith(GET_PREFIX)) {
            return GET_PREFIX;
        }
        if (name.startsWith(IS_PREFIX)) {
            return IS_PREFIX;
        }
        return null;
    }

    @Nullable
    public static String getSetterPrefix(PsiMethod setter) {
        if (setter.getName().startsWith(SET_PREFIX)) {
            return SET_PREFIX;
        }
        return null;
    }

    @Nullable
    public static String getAccessorPrefix(PsiMethod method) {
        String prefix = GroovyPropertyUtils.getGetterPrefix(method);
        if (prefix != null) {
            return prefix;
        }
        return GroovyPropertyUtils.getSetterPrefix(method);
    }

    public static boolean isAccessorFor(PsiMethod accessor, PsiField field) {
        String fieldName;
        String accessorName = accessor.getName();
        if (!ArrayUtil.contains((String)accessorName, (String[])GroovyPropertyUtils.suggestGettersName(fieldName = field.getName())) && !ArrayUtil.contains((String)accessorName, (String[])GroovyPropertyUtils.suggestSettersName(fieldName))) {
            return false;
        }
        PsiClass accessorClass = accessor.getContainingClass();
        PsiClass fieldClass = field.getContainingClass();
        if (!field.getManager().areElementsEquivalent((PsiElement)accessorClass, (PsiElement)fieldClass)) {
            return false;
        }
        return accessor.hasModifierProperty("static") == field.hasModifierProperty("static");
    }

    public static List<GrAccessorMethod> getFieldAccessors(GrField field) {
        ArrayList<GrAccessorMethod> accessors = new ArrayList<GrAccessorMethod>();
        GrAccessorMethod[] getters = field.getGetters();
        Collections.addAll(accessors, getters);
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            accessors.add(setter);
        }
        return accessors;
    }

    public static GrMethod generateGetterPrototype(PsiField field) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(field.getProject());
        String name = field.getName();
        String getName = GroovyPropertyUtils.getGetterNameNonBoolean(field.getName());
        try {
            PsiType type = field instanceof GrField ? ((GrField)field).getDeclaredType() : field.getType();
            GrMethod getter = factory.createMethod(getName, type);
            if (field.hasModifierProperty("static")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)getter, (String)"static", (boolean)true);
            }
            GroovyPropertyUtils.annotateWithNullableStuff((PsiModifierListOwner)field, getter);
            GrCodeBlock body = factory.createMethodBodyFromText("\nreturn " + name + "\n");
            getter.getBlock().replace(body);
            return getter;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static GrMethod generateSetterPrototype(PsiField field) {
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind((PsiVariable)field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = GroovyPropertyUtils.getSetterName(field.getName());
        PsiClass containingClass = field.getContainingClass();
        try {
            GrMethod setMethod = factory.createMethod(setName, (PsiType)PsiType.VOID);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiType type = field instanceof GrField ? ((GrField)field).getDeclaredType() : field.getType();
            GrParameter param = factory.createParameter(parameterName, type);
            GroovyPropertyUtils.annotateWithNullableStuff((PsiModifierListOwner)field, (PsiModifierListOwner)param);
            setMethod.getParameterList().add(param);
            PsiUtil.setModifierProperty((PsiModifierListOwner)setMethod, (String)"static", (boolean)isStatic);
            StringBuilder builder = new StringBuilder();
            if (name.equals(parameterName)) {
                if (!isStatic) {
                    builder.append("this.");
                } else {
                    String className = containingClass.getName();
                    if (className != null) {
                        builder.append(className);
                        builder.append(".");
                    }
                }
            }
            builder.append(name);
            builder.append("=");
            builder.append(parameterName);
            builder.append("\n");
            GrCodeBlock body = factory.createMethodBodyFromText(builder.toString());
            setMethod.getBlock().replace(body);
            return setMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static void annotateWithNullableStuff(PsiModifierListOwner original, PsiModifierListOwner generated) throws IncorrectOperationException {
        NullableNotNullManager.getInstance((Project)original.getProject()).copyNullableOrNotNullAnnotation(original, generated);
        PsiModifierList modifierList = generated.getModifierList();
        if (modifierList != null && modifierList.hasExplicitModifier("def")) {
            LOG.assertTrue(modifierList instanceof GrModifierList);
            if (modifierList.getAnnotations().length > 0 || ((GrModifierList)modifierList).getModifiers().length > 1) {
                modifierList.setModifierProperty("def", false);
            }
        }
    }
}

