/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyTraitMethodsFileIndex;

public class GrTraitUtil {
    private static final Logger LOG = Logger.getInstance(GrTraitUtil.class);
    private static final PsiTypeMapper ID_MAPPER = new PsiTypeMapper(){

        public PsiType visitClassType(PsiClassType classType) {
            return classType;
        }
    };

    @Contract(value="null -> false")
    public static boolean isInterface(@Nullable PsiClass aClass) {
        return aClass != null && aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    public static boolean isMethodAbstract(@NotNull PsiMethod method) {
        return method.getModifierList().hasExplicitModifier("abstract") || GrTraitUtil.isInterface(method.getContainingClass());
    }

    @NotNull
    public static String getTraitFieldPrefix(@NotNull PsiClass aClass) {
        String qname = aClass.getQualifiedName();
        LOG.assertTrue(qname != null, aClass.getClass());
        String[] identifiers = qname.split("\\.");
        StringBuilder buffer = new StringBuilder();
        for (String identifier : identifiers) {
            buffer.append(identifier).append('_');
        }
        buffer.append('_');
        return buffer.toString();
    }

    @Contract(value="null -> false")
    public static boolean isTrait(@Nullable PsiClass aClass) {
        return aClass instanceof GrTypeDefinition && ((GrTypeDefinition)aClass).isTrait() || aClass instanceof ClsClassImpl && aClass.isInterface() && AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"groovy.transform.Trait", (boolean)false);
    }

    public static Collection<PsiMethod> getCompiledTraitConcreteMethods(@NotNull ClsClassImpl trait) {
        return (Collection)CachedValuesManager.getCachedValue((PsiElement)trait, () -> {
            ArrayList result = ContainerUtil.newArrayList();
            GrTraitUtil.doCollectCompiledTraitMethods(trait, result);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{trait});
        });
    }

    private static void doCollectCompiledTraitMethods(ClsClassImpl trait, Collection<PsiMethod> result) {
        VirtualFile helperFile;
        for (PsiMethod method : trait.getMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.codehaus.groovy.transform.trait.Traits.Implemented", (boolean)false)) continue;
            result.add(method);
        }
        VirtualFile traitFile = trait.getContainingFile().getVirtualFile();
        if (traitFile != null && (helperFile = traitFile.getParent().findChild(trait.getName() + "$Trait$Helper.class")) != null) {
            int key = FileBasedIndex.getFileId((VirtualFile)helperFile);
            List values = FileBasedIndex.getInstance().getValues(GroovyTraitMethodsFileIndex.INDEX_ID, (Object)key, trait.getResolveScope());
            values.forEach(root -> ((PsiJavaFileStubImpl)root).setPsi((PsiFile)((PsiJavaFile)trait.getContainingFile())));
            values.stream().map(root -> ((StubElement)root.getChildrenStubs().get(0)).getChildrenStubs()).flatMap(Collection::stream).filter(stub -> stub instanceof PsiMethodStub).forEach(stub -> result.add(GrTraitUtil.createTraitMethodFromCompiledHelperMethod((PsiMethod)((PsiMethodStub)stub).getPsi(), trait)));
        }
    }

    private static PsiMethod createTraitMethodFromCompiledHelperMethod(PsiMethod compiledMethod, ClsClassImpl trait) {
        GrLightMethodBuilder result = new GrLightMethodBuilder(trait.getManager(), compiledMethod.getName());
        result.setOriginInfo("via @Trait");
        result.addModifier("static");
        for (PsiTypeParameter parameter : compiledMethod.getTypeParameters()) {
            result.getTypeParameterList().addParameter(parameter);
        }
        PsiTypeMapper corrector = GrTraitUtil.createCorrector(compiledMethod, (PsiClass)trait);
        PsiParameter[] methodParameters = compiledMethod.getParameterList().getParameters();
        for (int i = 1; i < methodParameters.length; ++i) {
            PsiParameter originalParameter = methodParameters[i];
            PsiType correctedType = (PsiType)originalParameter.getType().accept((PsiTypeVisitor)corrector);
            String name = originalParameter.getName();
            assert (name != null) : compiledMethod;
            result.addParameter(name, correctedType, false);
        }
        for (PsiClassType type : compiledMethod.getThrowsList().getReferencedTypes()) {
            PsiType correctedType = (PsiType)type.accept((PsiTypeVisitor)corrector);
            result.getThrowsList().addReference(correctedType instanceof PsiClassType ? (PsiClassType)correctedType : type);
        }
        PsiType originalType = compiledMethod.getReturnType();
        result.setReturnType(originalType == null ? null : (PsiType)originalType.accept((PsiTypeVisitor)corrector));
        PsiClass traitSource = trait.getSourceMirrorClass();
        PsiMethod sourceMethod = traitSource == null ? null : traitSource.findMethodBySignature((PsiMethod)result, false);
        result.setNavigationElement((PsiElement)(sourceMethod != null ? sourceMethod : compiledMethod));
        return result;
    }

    @NotNull
    private static PsiTypeMapper createCorrector(final PsiMethod compiledMethod, PsiClass trait) {
        PsiTypeParameter[] traitTypeParameters = trait.getTypeParameters();
        if (traitTypeParameters.length == 0) {
            return ID_MAPPER;
        }
        THashMap substitutionMap = ContainerUtil.newTroveMap();
        for (PsiTypeParameter parameter : traitTypeParameters) {
            substitutionMap.put(parameter.getName(), parameter);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)trait.getProject()).getElementFactory();
        return new PsiTypeMapper((Map)substitutionMap, elementFactory){
            final /* synthetic */ Map val$substitutionMap;
            final /* synthetic */ PsiElementFactory val$elementFactory;
            {
                this.val$substitutionMap = map;
                this.val$elementFactory = psiElementFactory;
            }

            public PsiType visitClassType(PsiClassType originalType) {
                PsiClass resolved = originalType.resolve();
                if (resolved instanceof PsiTypeParameter && compiledMethod.equals(((PsiTypeParameter)resolved).getOwner())) {
                    return originalType;
                }
                Object[] typeParameters = originalType.getParameters();
                PsiTypeParameter byName = (PsiTypeParameter)this.val$substitutionMap.get(originalType.getCanonicalText());
                if (byName != null) {
                    assert (typeParameters.length == 0);
                    return this.val$elementFactory.createType((PsiClass)byName);
                }
                if (resolved == null) {
                    return originalType;
                }
                if (typeParameters.length == 0) {
                    return originalType;
                }
                Ref hasChanges = Ref.create((Object)false);
                2 $this = this;
                PsiType[] substitutes = (PsiType[])ContainerUtil.map2Array((Object[])typeParameters, PsiType.class, arg_0 -> 2.lambda$visitClassType$7((PsiTypeVisitor)$this, hasChanges, arg_0));
                return (Boolean)hasChanges.get() != false ? this.val$elementFactory.createType(resolved, substitutes) : originalType;
            }

            private static /* synthetic */ PsiType lambda$visitClassType$7(PsiTypeVisitor psiTypeVisitor, Ref ref, PsiType type) {
                PsiType mapped = (PsiType)type.accept(psiTypeVisitor);
                ref.set((Object)(mapped != type ? 1 : 0));
                return mapped;
            }
        };
    }
}

