/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrEnumConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        return position == GrTypeConverter.ApplicableTo.ASSIGNMENT || position == GrTypeConverter.ApplicableTo.RETURN_VALUE;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (!TypesUtil.isEnum(targetType)) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiType)actualType, (String)"groovy.lang.GString") || InheritanceUtil.isInheritor((PsiType)actualType, (String)"java.lang.String")) {
            return GroovyConfigUtils.getInstance().isVersionAtLeast(context, "1.8") ? ConversionResult.OK : ConversionResult.ERROR;
        }
        return null;
    }
}

