/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrBooleanTypeConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        return true;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (!PsiType.BOOLEAN.equals((Object)TypesUtil.unboxPrimitiveTypeWrapper(targetType))) {
            return null;
        }
        if (PsiType.NULL == actualType) {
            switch (currentPosition) {
                case METHOD_PARAMETER: {
                    return null;
                }
                case EXPLICIT_CAST: 
                case ASSIGNMENT: 
                case RETURN_VALUE: {
                    return ConversionResult.OK;
                }
            }
            return null;
        }
        return currentPosition == GrTypeConverter.ApplicableTo.ASSIGNMENT || currentPosition == GrTypeConverter.ApplicableTo.RETURN_VALUE ? ConversionResult.OK : null;
    }
}

